/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.corba.ee.CosTransactions.TransactionService;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CoordinatorResourceServantActivator;
import com.sun.jts.CosTransactions.CurrentImpl;
import com.sun.jts.CosTransactions.ErrorLog;
import com.sun.jts.CosTransactions.ProxyChecker;
import com.sun.jts.CosTransactions.RecoveryCoordinatorServantActivator;
import com.sun.jts.CosTransactions.SenderReceiver;
import com.sun.jts.CosTransactions.TransactionFactoryImpl;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.TSIdentification;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.TransactionFactory;
import org.omg.CosTransactions.TransactionFactoryHelper;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.RequestProcessingPolicyValue;

public class DefaultTransactionService
implements TransactionService,
ProxyChecker {
    private static CurrentImpl currentInstance = null;
    private static TransactionFactoryImpl factoryInstance = null;
    private static NamingContext namingContext = null;
    private static ORB orb = null;
    private static boolean recoverable = false;
    private static boolean poasCreated = false;

    public Current get_current() {
        CurrentImpl result = null;
        result = currentInstance;
        return result;
    }

    public void identify_ORB(ORB orb, TSIdentification ident, Properties properties) {
        if (DefaultTransactionService.orb == null) {
            DefaultTransactionService.orb = orb;
            Configuration.setORB(orb);
            Configuration.setProperties(properties);
            Configuration.setProxyChecker(this);
        }
        if (!poasCreated) {
            String serverId = properties.getProperty("com.sun.corba.ee.internal.POA.ORBServerId");
            if (serverId == null) {
                serverId = properties.getProperty("com.sun.jts.persistentServerId");
            }
            if (serverId != null) {
                System.err.println(ErrorLog.getMessage(59, new java.lang.Object[]{serverId}));
            }
            String serverName = "UnknownHost";
            try {
                serverName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException ex2) {
                // empty catch block
            }
            if (serverId != null) {
                Configuration.setServerName(serverName + ",P" + serverId, true);
                recoverable = true;
            } else {
                long timestamp = System.currentTimeMillis();
                Configuration.setServerName(serverName + ",T" + String.valueOf(timestamp), false);
            }
            try {
                DefaultTransactionService.createPOAs();
            }
            catch (Exception exc) {
                exc.printStackTrace();
                throw new INTERNAL(265, CompletionStatus.COMPLETED_NO);
            }
        }
        if (currentInstance == null) {
            try {
                currentInstance = new CurrentImpl();
            }
            catch (Exception exc) {
                exc.printStackTrace();
                throw new INTERNAL(265, CompletionStatus.COMPLETED_NO);
            }
        }
        SenderReceiver.identify(ident);
        if (recoverable && namingContext == null) {
            try {
                namingContext = NamingContextHelper.narrow((Object)orb.resolve_initial_references("NameService"));
            }
            catch (Exception exc) {
                ErrorLog.warning(2, null);
            }
        }
        if (factoryInstance == null) {
            try {
                boolean localFactory = true;
                TransactionFactory factory = null;
                factoryInstance = new TransactionFactoryImpl();
                factory = localFactory ? factoryInstance : factoryInstance.object();
                Configuration.setFactory(factory, localFactory);
                if (!Configuration.isLocalFactory() && namingContext != null) {
                    NameComponent nc = new NameComponent(TransactionFactoryHelper.id(), "");
                    NameComponent[] path = new NameComponent[]{nc};
                    namingContext.rebind(path, (Object)factory);
                }
            }
            catch (Exception exc) {
                ErrorLog.warning(4, new java.lang.Object[]{"TransactionFactory"});
            }
        }
    }

    public static void shutdown(boolean immediate) {
        if (namingContext != null) {
            try {
                NameComponent nc = new NameComponent(TransactionFactoryHelper.id(), "");
                NameComponent[] path = new NameComponent[]{nc};
                namingContext.unbind(path);
                namingContext = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        TransactionFactoryImpl.deactivate();
        CurrentImpl.deactivate();
        currentInstance.shutdown(immediate);
        currentInstance = null;
        factoryInstance = null;
    }

    public final boolean isProxy(Object obj) {
        return !((ObjectImpl)obj)._is_local();
    }

    static final void createPOAs() throws Exception {
        POA rootPOA = (POA)orb.resolve_initial_references("RootPOA");
        POA CRpoa = null;
        if (recoverable) {
            Policy[] tpolicy = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER)};
            CRpoa = rootPOA.create_POA("com.sun.jts.CosTransactions.CoordinatorResourcePOA", null, tpolicy);
            CoordinatorResourceServantActivator crsa = new CoordinatorResourceServantActivator(orb);
            CRpoa.set_servant_manager(crsa);
        } else {
            CRpoa = rootPOA;
        }
        Configuration.setPOA("CoordinatorResource", CRpoa);
        POA RCpoa = null;
        if (recoverable) {
            Policy[] tpolicy = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER)};
            RCpoa = rootPOA.create_POA("com.sun.jts.CosTransactions.RecoveryCoordinatorPOA", null, tpolicy);
            RecoveryCoordinatorServantActivator rcsa = new RecoveryCoordinatorServantActivator(orb);
            RCpoa.set_servant_manager(rcsa);
        } else {
            RCpoa = rootPOA;
        }
        Configuration.setPOA("RecoveryCoordinator", RCpoa);
        POA Cpoa = rootPOA.create_POA("CoordinatorPOA", null, null);
        Configuration.setPOA("Coordinator", Cpoa);
        Configuration.setPOA("transient", rootPOA);
        CRpoa.the_POAManager().activate();
        RCpoa.the_POAManager().activate();
        Cpoa.the_POAManager().activate();
        rootPOA.the_POAManager().activate();
        poasCreated = true;
    }
}

