/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.url.corbaname;

import com.sun.jndi.cosnaming.CNCtx;
import com.sun.jndi.url.corbaname.CNCtxHelper;
import com.sun.jndi.url.corbaname.CorbanameUrl;
import com.sun.jndi.url.corbaname.corbanameURLContext;
import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ResolveResult;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class corbanameURLContextFactory
implements ObjectFactory {
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_PORT = "2089";
    public static final String[] tests = new String[]{"corbaname:rir:", "corbaname:rir:/NameService", "corbaname:rir:/dev/NameService", "corbaname:rir:,rir:/NameService", "corbaname::", "corbaname::orbhost:999#this/is/a/name", "corbaname::orbhost:999,:webhost#this/is/a/name", "corbaname::orbhost:999,:webhost/key/String#this/is/a/name", "corbaname:iiop:", "corbaname:iiop:orbhost:999#this/is/a/name", "corbaname:iiop:orbhost:999,iiop:webhost#this/is/a/name", "corbaname:iiop:orbhost:999,iiop:webhost/key/String#this/is/a/name", "corbaname:iiop:orbhost:999,:webhost#this/is/a/name", "corbaname::orbhost:999,iiop:webhost#this/is/a/name", "corbaname:foo:bar#this/is/a/name"};

    public java.lang.Object getObjectInstance(java.lang.Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (object == null) {
            return new corbanameURLContext(hashtable);
        }
        if (object instanceof String) {
            return corbanameURLContextFactory.getUsingURL((String)object, hashtable);
        }
        if (object instanceof String[]) {
            return corbanameURLContextFactory.getUsingURLs((String[])object, hashtable);
        }
        throw new IllegalArgumentException("iiopURLContextFactory.getObjectInstance: argument must be an iiop URL String or array of iiop URLs");
    }

    private static java.lang.Object getUsingURL(String string, Hashtable hashtable) throws NamingException {
        java.lang.Object object;
        ResolveResult resolveResult = corbanameURLContextFactory.getUsingURLIgnoreRest(string, hashtable);
        Context context = (Context)resolveResult.getResolvedObj();
        try {
            object = context.lookup(resolveResult.getRemainingName());
            java.lang.Object var6_5 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            context.close();
            throw throwable;
        }
        context.close();
        return object;
    }

    static ResolveResult getUsingURLIgnoreRest(String string, Hashtable hashtable) throws NamingException {
        ORB oRB;
        ORB oRB2 = oRB = hashtable != null ? (ORB)hashtable.get("java.naming.corba.orb") : null;
        if (oRB != null) {
            try {
                CorbanameUrl corbanameUrl = new CorbanameUrl(string);
                Object object = null;
                try {
                    object = oRB.string_to_object(corbanameUrl.getLocation());
                }
                catch (Exception exception) {}
                if (object != null) {
                    Context context = CNCtxHelper.getInstance(oRB, object, hashtable);
                    return new ResolveResult((java.lang.Object)context, corbanameUrl.getCosName());
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new ConfigurationException(malformedURLException.getMessage());
            }
        }
        string = corbanameURLContextFactory.rewriteUrl(string);
        return CNCtx.createUsingURL((String)string, (Hashtable)hashtable);
    }

    private static java.lang.Object getUsingURLs(String[] stringArray, Hashtable hashtable) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            try {
                java.lang.Object object = corbanameURLContextFactory.getUsingURL(string, hashtable);
                if (object != null) {
                    return object;
                }
            }
            catch (NamingException namingException) {}
            ++n2;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        int n2 = 0;
        while (n2 < tests.length) {
            System.out.println(tests[n2]);
            try {
                System.out.println("    " + corbanameURLContextFactory.rewriteUrl(tests[n2]));
            }
            catch (NamingException namingException) {
                System.out.println("    " + namingException);
            }
            ++n2;
        }
    }

    static String rewriteUrl(String string) throws NamingException {
        String string2;
        String string3;
        String string4 = null;
        int n2 = string.indexOf(35);
        if (n2 >= 0) {
            string4 = string.substring(n2 + 1);
            string3 = string.substring(10, n2);
        } else {
            string3 = string.substring(10);
        }
        int n3 = string3.indexOf(47);
        if (n3 >= 0) {
            String string5 = string3.substring(n3 + 1);
            if ("".equals(string5)) {
                string5 = "NameService";
            } else if (!"NameService".equals(string5)) {
                throw new InvalidNameException("Support is available only for the NameService key string");
            }
            string2 = string3.substring(0, n3);
        } else {
            string2 = string3;
        }
        int n4 = string2.length();
        int n5 = 0;
        StringBuffer stringBuffer = new StringBuffer("iiopname://");
        while (n5 < n4) {
            int n6 = string2.indexOf(58, n5);
            String string6 = string2.substring(n5, n6);
            if (string6.equals("") || string6.equals("iiop")) {
                String string7;
                int n7 = string2.indexOf(44, n6 + 1);
                if (n7 < 0) {
                    string7 = string2.substring(n6 + 1, n4);
                    n5 = n4;
                } else {
                    string7 = string2.substring(n6 + 1, n7);
                    n5 = n7 + 1;
                }
                stringBuffer.append(string7);
                if (string7.indexOf(58) < 0) {
                    stringBuffer.append(':');
                    stringBuffer.append(DEFAULT_PORT);
                }
                if (n7 < 0) continue;
                stringBuffer.append(',');
                continue;
            }
            if (string6.equals("rir")) {
                stringBuffer.append(DEFAULT_HOST);
                stringBuffer.append(':');
                stringBuffer.append(DEFAULT_PORT);
                n5 = n6 + 1;
                if (n5 == n4) continue;
                throw new InvalidNameException("Only one rir is supported");
            }
            throw new InvalidNameException("Unknown subscheme: " + string);
        }
        if (string4 != null) {
            stringBuffer.append('/');
            stringBuffer.append(string4);
        }
        return stringBuffer.toString();
    }
}

