/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.util;

import com.sun.jms.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;

public class Logger {
    private static final String TRACE_DELIMITER = "\n";
    private static final String JMS_LEADER = "com.sun.jms.";
    private static final String TRACE_LEADER = "\tat ";
    private StringWriter stringWriter = new StringWriter();
    private PrintWriter printWriter = new PrintWriter((Writer)this.stringWriter, true);
    private Throwable traceThrowable = new Throwable();
    private String logLeader = this.getClass().getName();
    private int logLevel = 2;
    private int id = -1;
    private String name = "com.sun.jms.default";

    public Logger() {
    }

    public Logger(int id, String name) {
        this();
        this.id = id;
        this.name = name;
    }

    private int boundLogLevel(int level) {
        if (level < 0) {
            return -1;
        }
        if (level > 7) {
            return 7;
        }
        return level;
    }

    public int setLevel(int level) {
        this.logLevel = this.boundLogLevel(level);
        return this.logLevel;
    }

    public boolean isLogging(int level) {
        if (this.logLevel == -1 || level == -1) {
            return false;
        }
        return level <= this.logLevel;
    }

    public void log(int proposedLevel, String msg) {
        if (!this.isLogging(proposedLevel)) {
            return;
        }
        int level = this.boundLogLevel(proposedLevel);
        if (level == 5 || level == 6 || level == 7) {
            Log.log(level, Log.LEVEL_LABEL[level] + this.getCaller() + ": " + msg);
        } else {
            Log.log(level, Log.LEVEL_LABEL[level] + msg);
        }
    }

    public void log(int level, Collection buffer, String name) {
        if (!this.isLogging(level)) {
            return;
        }
        int index = 0;
        StringBuffer text = new StringBuffer(500);
        if (buffer.size() > 0) {
            text.append("\n\tStart Collection " + name + ", size=" + buffer.size());
            Iterator iter = buffer.iterator();
            while (iter.hasNext()) {
                Object con = iter.next();
                text.append("\n\t\t" + index++ + ": " + con.toString());
            }
            text.append("\n\tEnd");
        } else {
            text.append("Collection " + name + " is empty.");
        }
        this.log(level, text.toString());
    }

    public void log(int level, Throwable t2) {
        if (!this.isLogging(level)) {
            return;
        }
        StringBuffer exText = new StringBuffer(300);
        if (t2 instanceof SQLException) {
            SQLException sqle = (SQLException)t2;
            while (sqle != null) {
                exText.append("SQL Exception");
                String sql_state = sqle.getSQLState();
                exText.append("\nSQLState:   " + sql_state);
                exText.append("\tError Code: " + sqle.getErrorCode());
                exText.append("\nMessage:  " + sqle.getMessage());
                exText.append("\nSystem directory: " + System.getProperty("cloudscape.system.home", System.getProperty("user.dir")) + TRACE_DELIMITER);
                sqle = sqle.getNextException();
            }
        } else {
            exText.append("Exception");
            exText.append("\nMessage:  " + t2.getMessage() + TRACE_DELIMITER);
        }
        exText.append(this.getStackTraceText(t2));
        this.log(level, exText.toString());
    }

    public void severe(String text) {
        this.log(1, text);
    }

    public void severe(Throwable t2) {
        this.log(1, t2);
    }

    public void severe(Collection buffer, String name) {
        this.log(1, buffer, name);
    }

    public void info(String text) {
        this.log(3, text);
    }

    public void info(Throwable t2) {
        this.log(3, t2);
    }

    public void info(Collection buffer, String name) {
        this.log(3, buffer, name);
    }

    public void debugInfo(String text) {
        this.log(0, text);
    }

    public void debugInfo(Throwable t2) {
        this.log(0, t2);
    }

    public void debugInfo(Collection buffer, String name) {
        this.log(0, buffer, name);
    }

    public void warning(String text) {
        this.log(2, text);
    }

    public void warning(Throwable t2) {
        this.log(2, t2);
    }

    public void warning(Collection buffer, String name) {
        this.log(2, buffer, name);
    }

    public void config(String text) {
        this.log(4, text);
    }

    public void config(Throwable t2) {
        this.log(4, t2);
    }

    public void config(Collection buffer, String name) {
        this.log(4, buffer, name);
    }

    public void fine(String text) {
        this.log(5, text);
    }

    public void fine(Throwable t2) {
        this.log(5, t2);
    }

    public void fine(Collection buffer, String name) {
        this.log(5, buffer, name);
    }

    public void finer(String text) {
        this.log(6, text);
    }

    public void finer(Throwable t2) {
        this.log(6, t2);
    }

    public void finer(Collection buffer, String name) {
        this.log(6, buffer, name);
    }

    public void finest(String text) {
        this.log(7, text);
    }

    public void finest(Throwable t2) {
        this.log(7, t2);
    }

    public void finest(Collection buffer, String name) {
        this.log(7, buffer, name);
    }

    public void initialize(String name, int id, int level) {
        this.setLevel(level);
        this.name = name;
        this.id = id;
        this.fine("Initialized Logger: " + name + ",  Id: " + id + ",  Level: " + Log.LEVEL_NAME[level]);
    }

    private String getStackTraceText(Throwable t2) {
        this.stringWriter.getBuffer().setLength(0);
        try {
            t2.printStackTrace(this.printWriter);
        }
        catch (Throwable tt) {
            return "<no stack trace due to " + tt + ">";
        }
        return this.stringWriter.getBuffer().toString();
    }

    private String getCaller() {
        String token;
        this.stringWriter.getBuffer().setLength(0);
        this.traceThrowable.fillInStackTrace();
        try {
            this.traceThrowable.printStackTrace(this.printWriter);
        }
        catch (Throwable tt) {
            return "<no stack trace due to " + tt + ">";
        }
        StringTokenizer tokenizer = new StringTokenizer(this.stringWriter.getBuffer().toString(), TRACE_DELIMITER);
        try {
            int end;
            int start;
            while ((token = tokenizer.nextToken()).indexOf(TRACE_LEADER) == -1) {
            }
            while ((token = tokenizer.nextToken()).indexOf(this.logLeader) != -1) {
            }
            int i2 = token.indexOf(TRACE_LEADER);
            if (i2 == -1) {
                start = 0;
                end = token.length();
            } else {
                int j2 = token.indexOf(JMS_LEADER);
                start = j2 == -1 ? i2 + TRACE_LEADER.length() : j2 + JMS_LEADER.length();
                j2 = token.indexOf(40);
                end = j2 == -1 ? token.length() : j2;
            }
            token = token.substring(start, end);
        }
        catch (Exception e10) {
            token = "";
        }
        return token;
    }

    public String getName() {
        return this.name;
    }

    public void entering(Object[] params) {
        if (!this.isLogging(6)) {
            return;
        }
        StringBuffer paramSbuf = new StringBuffer();
        if (paramSbuf != null) {
            paramSbuf.append("(");
            int i2 = 0;
            while (i2 < params.length) {
                paramSbuf.append(params[i2]);
                if (i2 != params.length - 1) {
                    paramSbuf.append(",");
                }
                ++i2;
            }
            paramSbuf.append(")");
        }
        Log.log(6, "ENTRY  " + this.getCaller() + paramSbuf);
    }

    public void exiting(Object[] params) {
        this.exiting(params, null);
    }

    public void exiting(Object[] params, Object returning) {
        if (!this.isLogging(6)) {
            return;
        }
        StringBuffer paramSbuf = new StringBuffer();
        if (params != null) {
            paramSbuf.append("(");
            int i2 = 0;
            while (i2 < params.length) {
                paramSbuf.append(params[i2]);
                if (i2 != params.length - 1) {
                    paramSbuf.append(",");
                }
                ++i2;
            }
            paramSbuf.append(")");
        }
        if (returning != null) {
            paramSbuf.append(" return=" + returning);
        }
        Log.log(6, "RETURN " + this.getCaller() + paramSbuf);
    }
}

