/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service.selector;

import com.sun.jms.service.selector.ParseException;
import com.sun.jms.service.selector.SQLParser;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.io.ByteArrayInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;

public class JMSSelector {
    public static final Logger logger = Log.getLogger(5);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.selector.LocalStrings");
    static final boolean debug = false;
    SQLParser parser;
    String pattern;
    Message msg;

    public JMSSelector(String pattern, Message msg) {
        if (pattern == null) {
            pattern = "";
        }
        this.msg = msg;
        this.pattern = pattern;
        ByteArrayInputStream stream = new ByteArrayInputStream(pattern.getBytes());
        this.parser = new SQLParser(this, stream);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String p2) throws InvalidSelectorException, JMSException {
        this.pattern = p2;
        ByteArrayInputStream stream = new ByteArrayInputStream(this.pattern.getBytes());
        this.parser.ReInit(stream);
        try {
            this.match(this.msg);
        }
        catch (ParseException e10) {
            InvalidSelectorException je = new InvalidSelectorException(MessageFormat.format(resource.getString("jmsselector.invalid_selector"), p2, e10.getMessage()));
            throw je;
        }
        catch (Throwable t2) {
            InvalidSelectorException je = new InvalidSelectorException(MessageFormat.format(resource.getString("jmsselector.invalid_selector"), p2, t2));
            throw je;
        }
    }

    public boolean match(Message msg) throws ParseException, JMSException {
        boolean matched = false;
        if (this.pattern.equals("")) {
            matched = true;
        } else {
            try {
                matched = this.parser.match(msg);
                Object var4_3 = null;
                ByteArrayInputStream stream = new ByteArrayInputStream(this.pattern.getBytes());
                this.parser.ReInit(stream);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                ByteArrayInputStream stream = new ByteArrayInputStream(this.pattern.getBytes());
                this.parser.ReInit(stream);
                throw throwable;
            }
        }
        return matched;
    }

    boolean matchPattern(String patternStr, String str, char escapeChar) {
        boolean matched = false;
        String escapeCharStr = String.valueOf(escapeChar);
        String wildCards = "_%";
        String delims = wildCards + escapeCharStr;
        boolean escaped = false;
        int index = 0;
        String tok = null;
        try {
            block35: {
                try {
                    if (str != null) {
                        StringTokenizer st = new StringTokenizer(patternStr, delims, true);
                        ArrayList<String> tokens = new ArrayList<String>();
                        boolean k2 = true;
                        while (st.hasMoreTokens()) {
                            tok = st.nextToken();
                            tokens.add(tok);
                        }
                        matched = true;
                        int numTokens = tokens.size();
                        int i2 = 0;
                        while (i2 < numTokens) {
                            tok = (String)tokens.get(i2);
                            if (tok.equals(escapeCharStr) && !escaped) {
                                escaped = true;
                            } else if (tok.equals("%") && !escaped) {
                                if (i2 == numTokens - 1) {
                                    index = str.length();
                                } else if (i2 != numTokens - 1) {
                                    int _cnt = 0;
                                    ++i2;
                                    while (i2 < numTokens) {
                                        tok = (String)tokens.get(i2);
                                        if (tok.equals(escapeCharStr) && !escaped) {
                                            escaped = true;
                                        } else if (!tok.equals("%") || escaped) {
                                            if (!tok.equals("_") || escaped) {
                                                int oldIndex = index;
                                                if (i2 == numTokens - 1) {
                                                    if (str.endsWith(tok)) {
                                                        index = str.length() - tok.length();
                                                    } else {
                                                        matched = false;
                                                    }
                                                } else {
                                                    index = str.indexOf(tok, index);
                                                }
                                                if (index < 0) {
                                                    matched = false;
                                                } else if (index - oldIndex >= _cnt) {
                                                    index += tok.length();
                                                } else {
                                                    matched = false;
                                                }
                                                escaped = false;
                                                break;
                                            }
                                            ++_cnt;
                                        }
                                        ++i2;
                                    }
                                }
                            } else if (tok.equals("_") && !escaped) {
                                ++index;
                            } else {
                                int tokLen = tok.length();
                                if (index + tokLen <= str.length()) {
                                    String subStr = null;
                                    try {
                                        subStr = str.substring(index, index + tokLen);
                                    }
                                    catch (StringIndexOutOfBoundsException e10) {
                                        matched = false;
                                        break;
                                    }
                                    if (!subStr.equalsIgnoreCase(tok)) {
                                        matched = false;
                                        break;
                                    }
                                    index += tok.length();
                                } else {
                                    matched = false;
                                    break;
                                }
                                escaped = false;
                            }
                            ++i2;
                        }
                    }
                    if (!matched || index == str.length()) break block35;
                    matched = false;
                }
                catch (StringIndexOutOfBoundsException e11) {
                    matched = false;
                    Object var20_22 = null;
                    return matched;
                }
            }
            Object var20_21 = null;
            return matched;
        }
        catch (Throwable throwable) {
            Object var20_23 = null;
            return matched;
        }
    }

    String processStringLiteral(String strLiteral) {
        int index = (strLiteral = strLiteral.substring(1, strLiteral.length() - 1)).indexOf("''");
        if (index > -1) {
            StringBuffer sb = new StringBuffer(strLiteral);
            while (index != -1) {
                sb.deleteCharAt(index);
                index = sb.toString().indexOf("''");
            }
            strLiteral = sb.toString();
        }
        return strLiteral;
    }
}

