/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.DestinationImpl;
import com.sun.jms.MessageImpl;
import com.sun.jms.service.ConsumerImpl;
import com.sun.jms.service.DBManager;
import com.sun.jms.service.JMSServiceImpl;
import com.sun.jms.service.MessageConsumerImpl;
import com.sun.jms.service.QueueReceiverImpl;
import com.sun.jms.service.QueueSubscription;
import com.sun.jms.util.JmsResourceBundle;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.JMSException;
import javax.jms.Queue;

public class QueueImpl
extends com.sun.jms.service.DestinationImpl
implements Queue {
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");
    LinkedList waitingSynchronousConsumers = new LinkedList();
    int messageSendCount = 0;

    public QueueImpl(String name) {
        this(name, false);
    }

    public QueueImpl(String name, boolean isTemporary) {
        this(name, isTemporary, true);
    }

    public QueueImpl(String name, boolean isTemporary, boolean persistenceRequired) {
        super(name, isTemporary, persistenceRequired);
        if (!isTemporary) {
            try {
                this.loadLoggedMessages();
            }
            catch (JMSException jmse) {
                com.sun.jms.service.DestinationImpl.logger.warning(jmse);
            }
        }
    }

    public String getQueueName() throws JMSException {
        return this.getName();
    }

    public boolean isQueue() {
        return true;
    }

    private ConsumerImpl getSelectorMatchingConsumer(MessageImpl msg) {
        LinkedList linkedList = this.waitingSynchronousConsumers;
        synchronized (linkedList) {
            QueueReceiverImpl qr = null;
            Iterator iter = this.waitingSynchronousConsumers.iterator();
            while (iter.hasNext()) {
                qr = (QueueReceiverImpl)iter.next();
                if (qr.isStopped() || !qr.selectorMatch(msg)) continue;
                iter.remove();
                QueueReceiverImpl queueReceiverImpl = qr;
                return queueReceiverImpl;
            }
        }
        ConsumerImpl consumer = null;
        AbstractList consumerList = this.getConsumers();
        int numConsumers = consumerList.size();
        if (numConsumers > 0) {
            int index;
            int i2 = index = ++this.messageSendCount % numConsumers;
            while (i2 < numConsumers) {
                consumer = (ConsumerImpl)consumerList.get(i2);
                if (consumer.presendToClient() && consumer.selectorMatch(msg)) {
                    return consumer;
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < index) {
                consumer = (ConsumerImpl)consumerList.get(i3);
                if (consumer.presendToClient() && consumer.selectorMatch(msg)) {
                    return consumer;
                }
                ++i3;
            }
        }
        return null;
    }

    boolean sendMessageToConsumers(MessageImpl msg) throws JMSException {
        ConsumerImpl consumer;
        boolean deliveredMessage = false;
        if (com.sun.jms.service.DestinationImpl.logger.isLogging(6)) {
            com.sun.jms.service.DestinationImpl.logger.finer("msg: " + msg);
        }
        if ((consumer = this.getSelectorMatchingConsumer(msg)) != null) {
            if (consumer.awaitingSynchronousReceive()) {
                consumer.deliverSynchronousMessage(msg);
                deliveredMessage = true;
            } else if (consumer.presendToClient()) {
                consumer.sendMessage(msg);
                deliveredMessage = true;
            }
        }
        return deliveredMessage;
    }

    void register(ConsumerImpl consumer) throws JMSException {
        boolean wakeupMessageBufferWaiter;
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            wakeupMessageBufferWaiter = !this.hasConsumers();
            super.register(consumer);
        }
        if (wakeupMessageBufferWaiter) {
            this.wakeup();
        }
    }

    DestinationImpl getDestinationWrapper() {
        com.sun.jms.QueueImpl dest = new com.sun.jms.QueueImpl(this.name);
        return dest;
    }

    public boolean hasDurableSubscribers() {
        return false;
    }

    protected boolean okToProcessMessageBuffer() {
        boolean okToProcess = true;
        if (!this.hasConsumers()) {
            com.sun.jms.service.DestinationImpl.logger.finer("NO CONSUMERS REGISTERED");
            okToProcess = false;
        }
        return okToProcess;
    }

    private void loadLoggedMessages() throws JMSException {
        block6: {
            Connection con = null;
            try {
                try {
                    con = DBManager.getInstance().getDBConnection();
                    Collection loggedMessages = QueueSubscription.loadUnackedMessages(con, this.getName());
                    Iterator loggedMessagesIter = loggedMessages.iterator();
                    while (loggedMessagesIter.hasNext()) {
                        MessageImpl msg = (MessageImpl)loggedMessagesIter.next();
                        JMSServiceImpl.getInstance().addMessage(msg);
                        msg.receivedByServer();
                    }
                    this.addMessages(loggedMessages);
                }
                catch (JMSException e10) {
                    com.sun.jms.service.DestinationImpl.logger.warning(e10);
                    Object var6_9 = null;
                    DBManager.getInstance().closeDBConnection(con);
                    break block6;
                }
                catch (SQLException sqle) {
                    JMSException jmse = new JMSException(resource.getString("queueimpl.error_loading_logged_messages"));
                    com.sun.jms.service.DestinationImpl.logger.warning(sqle);
                    jmse.setLinkedException(sqle);
                    throw jmse;
                }
                Object var6_8 = null;
                DBManager.getInstance().closeDBConnection(con);
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                DBManager.getInstance().closeDBConnection(con);
                throw throwable;
            }
        }
    }

    public void delete() throws JMSException {
        Connection con = null;
        try {
            block4: {
                try {
                    super.delete();
                    if (this.isTemporary) break block4;
                    con = DBManager.getInstance().getDBConnection();
                    QueueSubscription.deleteUnackedMessagesForQueue(con, this.name);
                }
                catch (SQLException sqle) {
                    JMSException jmse = new JMSException(resource.getString("queueimpl.error_cleaning_database"));
                    com.sun.jms.service.DestinationImpl.logger.warning(sqle);
                    jmse.setLinkedException(sqle);
                    throw jmse;
                }
            }
            Object var5_2 = null;
            DBManager.getInstance().closeDBConnection(con);
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            DBManager.getInstance().closeDBConnection(con);
            throw throwable;
        }
    }

    boolean hasConsumers() {
        LinkedList linkedList = this.waitingSynchronousConsumers;
        synchronized (linkedList) {
            if (this.waitingSynchronousConsumers.size() != 0) {
                boolean bl2 = true;
                return bl2;
            }
        }
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            Iterator consumerIter = ((AbstractList)this.consumers).iterator();
            while (consumerIter.hasNext()) {
                ConsumerImpl consumer = (ConsumerImpl)consumerIter.next();
                if (!consumer.presendToClient()) continue;
                boolean bl3 = true;
                return bl3;
            }
        }
        return false;
    }

    void registerWaitForSynchronousReceive(MessageConsumerImpl consumer) throws JMSException {
        com.sun.jms.service.DestinationImpl.logger.finest("");
        LinkedList linkedList = this.waitingSynchronousConsumers;
        synchronized (linkedList) {
            this.waitingSynchronousConsumers.add(consumer);
        }
    }

    void deregisterWaitForSynchronousReceive(MessageConsumerImpl consumer) {
        com.sun.jms.service.DestinationImpl.logger.finest("");
        LinkedList linkedList = this.waitingSynchronousConsumers;
        synchronized (linkedList) {
            this.waitingSynchronousConsumers.remove(consumer);
        }
    }

    public void printDebugInfo() {
        com.sun.jms.service.DestinationImpl.logger.debugInfo("DestinationType: Queue");
        super.printDebugInfo();
        com.sun.jms.service.DestinationImpl.logger.debugInfo("Number of Blocked synchronous consumers: " + this.waitingSynchronousConsumers.size());
    }
}

