/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.MessageImpl;
import com.sun.jms.service.ConnectionImpl;
import com.sun.jms.service.ConsumerImpl;
import com.sun.jms.service.DestinationImpl;
import com.sun.jms.service.SessionImpl;
import java.util.List;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;

public abstract class MessageConsumerImpl
extends ConsumerImpl {
    SessionImpl parent;
    private boolean beingClosed = false;

    MessageConsumerImpl(DestinationImpl dest, SessionImpl parent, int id, String selectPattern) throws InvalidSelectorException, JMSException {
        super(dest, id, selectPattern);
        this.parent = parent;
        if (parent != null) {
            parent.addConsumer(this);
        }
    }

    void setDestination(DestinationImpl dest) throws JMSException {
        if (this.dest != null) {
            if (ConsumerImpl.logger.isLogging(7)) {
                ConsumerImpl.logger.finest("MessageConsumer already has a dest: " + this.dest + ", deregistering it and re-registering this MC with: " + dest);
            }
            dest.deregister(this);
        }
        this.dest = dest;
        dest.register(this);
    }

    public void close(boolean removeFromParent) throws JMSException {
        if (this.beingClosed) {
            if (ConsumerImpl.logger.isLogging(7)) {
                ConsumerImpl.logger.finest("id " + this.id + " already being closed. Returning");
            }
            return;
        }
        this.beingClosed = true;
        if (ConsumerImpl.logger.isLogging(6)) {
            ConsumerImpl.logger.finer("id " + this.id);
        }
        if (!this.isDurableSubscriber()) {
            this.dest.deregister(this);
        }
        if (removeFromParent && this.parent != null) {
            this.parent.removeConsumer(this.getId());
        }
        this.performCloseActions();
        if (this.parent != null) {
            this.parent = null;
        }
        this.beingClosed = false;
    }

    protected void performCloseActions() throws JMSException {
    }

    public MessageImpl cloneForDeliveryToClient(MessageImpl msg) throws JMSException {
        return this.cloneForDeliveryToClient(this.parent, msg);
    }

    public synchronized void sendMessage(MessageImpl msg) throws JMSException {
        if (this.beingClosed) {
            return;
        }
        ConsumerImpl.logger.finer(msg.toString());
        this.sendMessageInternal(msg);
    }

    protected void sendMessageInternal(MessageImpl msg) throws JMSException {
        if (this.beingClosed) {
            return;
        }
        MessageImpl newMsg = this.cloneForDeliveryToClient(msg);
        this.parent.sendMessage(newMsg);
    }

    public SessionImpl getSession() {
        return this.parent;
    }

    synchronized void getUnAckedMessages(List unAckedMessages, boolean clearUnAcked) throws JMSException {
        this.parent.getUnAckedMessages(unAckedMessages, this.id, clearUnAcked);
    }

    public String getClientID() {
        ConnectionImpl connection = this.parent.getConnection();
        return connection.getClientID();
    }

    public ConnectionImpl getConnection() {
        return this.parent.getConnection();
    }

    MessageImpl receive(long timeout) throws JMSException {
        return null;
    }

    public abstract boolean presendToClient();

    public abstract boolean awaitingSynchronousReceive();

    public abstract void deliverSynchronousMessage(MessageImpl var1);

    public boolean isConnectionConsumer() {
        return false;
    }

    public boolean isStopped() {
        return this.parent == null || this.parent.isStopped();
    }
}

