/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.MessageImpl;
import com.sun.jms.service.Consumer;
import com.sun.jms.service.ConsumerImpl;
import com.sun.jms.service.DBManager;
import com.sun.jms.service.DestinationImpl;
import com.sun.jms.service.Subscription;
import com.sun.jms.service.TopicSubscriberImpl;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;

public abstract class DurableSubscription {
    Subscription subscription = null;
    Consumer consumer = null;
    static HashMap nameToSubscriberMap = new HashMap(11);
    public static final String DB_TABLE_NAME = "durable_subscriber";
    public static final String DB_SELECTOR_FIELD = "selector";
    public static final String DB_NOLOCAL_FIELD = "no_local";
    public static final String CREATE_DURABLE_SUBSCRIBER_TABLE_STMT = "CREATE TABLE durable_subscriber ( client_id VARCHAR(256) NOT NULL, subscription_name VARCHAR(256) NOT NULL, selector VARCHAR(256), dest_name VARCHAR(256) NOT NULL, no_local BOOLEAN, PRIMARY KEY ( client_id, subscription_name )  ) ";
    public static final String DEBUG_STMT = "SELECT * FROM durable_subscriber";
    static Logger logger = Log.getLogger(1);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");

    public DurableSubscription(Consumer consumer, Subscription subscription) {
        this.consumer = consumer;
        this.subscription = subscription;
    }

    /*
     * Loose catch block
     */
    public void initialize() throws JMSException {
        block24: {
            if (this.consumer.isDurableSubscriber() && this.consumer.isActive()) {
                SQLException e10222;
                ResultSet rs;
                Connection connection;
                block22: {
                    block21: {
                        boolean needToPersist = false;
                        connection = null;
                        rs = null;
                        connection = DBManager.getInstance().getDBConnection();
                        rs = this.loadDurableSubscriberForSubscription(connection, this.consumer.getClientID(), this.subscription.getSubscriptionName());
                        if (rs != null && rs.next()) {
                            String destName = rs.getString("dest_name");
                            if (!destName.equals(this.consumer.getDestination().getName())) {
                                DurableSubscription.deleteDurableSubscription(connection, this.consumer.getClientID(), this.subscription.getSubscriptionName());
                                needToPersist = true;
                            }
                        } else {
                            needToPersist = true;
                        }
                        if (!needToPersist) break block21;
                        this.storeDurableSubscription(connection);
                    }
                    Object var6_6 = null;
                    if (rs == null) break block22;
                    try {
                        rs.close();
                    }
                    catch (SQLException e10222) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e10222) {}
                }
                break block24;
                {
                    catch (SQLException e11) {
                        SQLException e10222;
                        logger.warning(e11);
                        Object var6_7 = null;
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException e10222) {
                                // empty catch block
                            }
                        }
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (SQLException e10222) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                    SQLException e10222;
                    Object var6_8 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e10222) {
                            // empty catch block
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e10222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    public String getGlobalSubscriptionName() {
        return DurableSubscription.getGlobalSubscriptionName(this.consumer.getClientID(), this.subscription.getSubscriptionName());
    }

    static String getGlobalSubscriptionName(String clientID, String subscriptionName) {
        return clientID + "." + subscriptionName;
    }

    static ConsumerImpl getDurableSubscriber(String clientID, String subscriptionName) {
        if (logger.isLogging(7)) {
            logger.finest("Looking for DS: " + DurableSubscription.getGlobalSubscriptionName(clientID, subscriptionName));
        }
        ConsumerImpl subscriber = (ConsumerImpl)nameToSubscriberMap.get(DurableSubscription.getGlobalSubscriptionName(clientID, subscriptionName));
        return subscriber;
    }

    protected void sendLoggedMessages() throws JMSException {
        if (logger.isLogging(6)) {
            logger.finer("sending missed messages");
        }
        Collection unackedMessages = this.subscription.loadUnackedMessages();
        Iterator unackedMessagesIter = unackedMessages.iterator();
        while (unackedMessagesIter.hasNext()) {
            MessageImpl msg = (MessageImpl)unackedMessagesIter.next();
            msg.receivedByServer();
            this.consumer.sendLoggedMessage(msg);
        }
    }

    abstract void deactivate();

    /*
     * Loose catch block
     */
    static Collection loadDurableSubscribersForDestination(DestinationImpl dest) {
        ArrayList<TopicSubscriberImpl> durableSubscribers;
        block28: {
            SQLException e102222;
            ResultSet rs;
            Statement stmt;
            Connection connection;
            String destName;
            block26: {
                durableSubscribers = new ArrayList<TopicSubscriberImpl>();
                destName = null;
                connection = null;
                stmt = null;
                rs = null;
                connection = DBManager.getInstance().getDBConnection();
                connection.setAutoCommit(true);
                stmt = connection.createStatement();
                destName = dest.getName();
                String stmtStr = "SELECT * FROM durable_subscriber WHERE dest_name = '" + destName + "'";
                if (logger.isLogging(6)) {
                    logger.finer("\tDATABASE EVENT: " + stmtStr);
                }
                rs = DBManager.executeQuery(stmt, stmtStr);
                while (rs.next()) {
                    String clientID = rs.getString("client_id");
                    String subscriptionName = rs.getString("subscription_name");
                    String selectorPattern = rs.getString(DB_SELECTOR_FIELD);
                    boolean noLocal = rs.getBoolean(DB_NOLOCAL_FIELD);
                    TopicSubscriberImpl durableSubscriber = new TopicSubscriberImpl(dest, clientID, selectorPattern, subscriptionName, noLocal);
                    durableSubscriber.setDestination(dest);
                    durableSubscribers.add(durableSubscriber);
                }
                Object var13_14 = null;
                if (rs == null) break block26;
                try {
                    rs.close();
                }
                catch (SQLException e102222) {
                    logger.warning(e102222);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e102222) {
                    logger.warning(e102222);
                }
            }
            DBManager.getInstance().closeDBConnection(connection);
            {
                break block28;
                catch (SQLException e11) {
                    SQLException e102222;
                    if (logger.isLogging(2)) {
                        logger.warning(MessageFormat.format(resource.getString("durablesubscription.error_loading_durable_subscription_for_destination"), destName, e11.getMessage()));
                        logger.warning(e11);
                    }
                    Object var13_15 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e102222) {
                            logger.warning(e102222);
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e102222) {
                            logger.warning(e102222);
                        }
                    }
                    DBManager.getInstance().closeDBConnection(connection);
                    break block28;
                }
                catch (JMSException je) {
                    SQLException e102222;
                    if (logger.isLogging(2)) {
                        logger.warning(MessageFormat.format(resource.getString("durablesubscription.error_loading_durable_subscription_for_destination"), destName, je.getMessage()));
                        logger.warning(je);
                    }
                    Object var13_16 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e102222) {
                            logger.warning(e102222);
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e102222) {
                            logger.warning(e102222);
                        }
                    }
                    DBManager.getInstance().closeDBConnection(connection);
                }
            }
            catch (Throwable throwable) {
                SQLException e102222;
                Object var13_17 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e102222) {
                        logger.warning(e102222);
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e102222) {
                        logger.warning(e102222);
                    }
                }
                DBManager.getInstance().closeDBConnection(connection);
                throw throwable;
            }
        }
        return durableSubscribers;
    }

    ResultSet loadDurableSubscriberForSubscription(Connection connection, String clientID, String subscriptionName) {
        ResultSet rs;
        block3: {
            rs = null;
            if (logger.isLogging(6)) {
                logger.finer("\tDATABASE EVENT: attempting load of consumer " + DurableSubscription.getGlobalSubscriptionName(clientID, subscriptionName) + " from the db");
            }
            String stmtStr = null;
            try {
                Statement stmt = connection.createStatement();
                stmtStr = "SELECT * FROM durable_subscriber WHERE client_id = '" + clientID + "' AND " + "subscription_name" + " = '" + subscriptionName + "'";
                logger.finer(stmtStr);
                rs = DBManager.executeQuery(stmt, stmtStr);
            }
            catch (SQLException e10) {
                if (!logger.isLogging(2)) break block3;
                logger.warning(MessageFormat.format(resource.getString("durablesubscription.error_loading_durable_subscribers_from_database"), e10.getMessage()));
                logger.warning(e10);
            }
        }
        return rs;
    }

    static void createTable(Connection connection) throws SQLException {
        Statement stmt = connection.createStatement();
        stmt.execute(CREATE_DURABLE_SUBSCRIBER_TABLE_STMT);
        if (logger.isLogging(6)) {
            logger.finer("\tCreated table: durable_subscriber");
        }
    }

    void deleteDurableSubscription(String clientID, DestinationImpl dest) throws JMSException {
        String subscriptionName = this.subscription.getSubscriptionName();
        if (this.consumer.isActive()) {
            throw new JMSException(MessageFormat.format(resource.getString("durablesubscription.error_unsubscribing_durable_subscription"), DurableSubscription.getGlobalSubscriptionName(clientID, subscriptionName)));
        }
        dest.deregister((ConsumerImpl)this.consumer);
        Connection con = null;
        try {
            try {
                con = DBManager.getInstance().getDBConnection();
                DurableSubscription.deleteDurableSubscription(con, this.consumer.getClientID(), this.subscription.getSubscriptionName());
            }
            catch (SQLException sqle) {
                logger.warning(sqle);
                Object var7_6 = null;
                DBManager.getInstance().closeDBConnection(con);
            }
            Object var7_5 = null;
            DBManager.getInstance().closeDBConnection(con);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            DBManager.getInstance().closeDBConnection(con);
            throw throwable;
        }
    }

    static void deleteDurableSubscription(Connection connection, String clientID, String subscriptionName) throws JMSException {
        if (logger.isLogging(6)) {
            logger.finer("\tDATABASE EVENT: removing consumer " + DurableSubscription.getGlobalSubscriptionName(clientID, subscriptionName) + " from the db");
        }
        try {
            String stmtStr = "DELETE FROM durable_subscriber WHERE client_id = '" + clientID + "' AND " + "subscription_name" + " = '" + subscriptionName + "'";
            logger.finer(stmtStr);
            DBManager.executeUpdate(connection, stmtStr);
        }
        catch (SQLException e10) {
            if (logger.isLogging(2)) {
                logger.warning(MessageFormat.format(resource.getString("durablesubscription.error_deleting_durable_subscription_from_database"), e10.getMessage()));
                logger.warning(e10);
            }
            JMSException jmse = new JMSException(MessageFormat.format(resource.getString("durablesubscription.error_deleting_durable_subscription_from_database"), e10.getMessage()));
            jmse.setLinkedException(e10);
            throw jmse;
        }
        nameToSubscriberMap.remove(DurableSubscription.getGlobalSubscriptionName(clientID, subscriptionName));
    }

    /*
     * Loose catch block
     */
    void storeDurableSubscription(Connection connection) throws SQLException {
        block16: {
            if (logger.isLogging(6)) {
                logger.finer("\tDATABASE EVENT: storing consumer " + this.getGlobalSubscriptionName() + " in db");
            }
            Statement stmt = null;
            Object stmtStr = null;
            PreparedStatement pstmt = null;
            String INSERT_DURABLE_SUBSCRIPTION_STMT = "INSERT INTO durable_subscriber VALUES ( ?, ?, ?, ?, ?)";
            pstmt = connection.prepareStatement("INSERT INTO durable_subscriber VALUES ( ?, ?, ?, ?, ?)");
            pstmt.setString(1, this.consumer.getClientID());
            pstmt.setString(2, this.subscription.getSubscriptionName());
            pstmt.setString(3, this.consumer.getSelectPattern());
            pstmt.setString(4, this.consumer.getDestination().getName());
            pstmt.setBoolean(5, this.consumer.getNoLocal());
            pstmt.execute();
            Object var8_7 = null;
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                break block16;
            }
            catch (SQLException e10) {
                logger.warning(e10);
            }
            break block16;
            {
                catch (JMSException jmse) {
                    logger.warning(jmse);
                    Object var8_8 = null;
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        break block16;
                    }
                    catch (SQLException e10) {
                        logger.warning(e10);
                    }
                    break block16;
                }
                catch (SQLException e11) {
                    logger.warning(e11);
                    throw e11;
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e10) {
                    logger.warning(e10);
                }
                throw throwable;
            }
        }
    }

    public static void printDurableSubscribers(String topicName) {
        Iterator iter = nameToSubscriberMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ConsumerImpl ds2 = (ConsumerImpl)entry.getValue();
            if (!topicName.equals(ds2.getDestination().getName())) continue;
            logger.debugInfo((ds2.isActive() ? "Active " : "Non-Active ") + "Durable subscription  " + (String)entry.getKey() + " for Topic " + ds2.getDestination().getName() + " with selector " + ds2.selector.getPattern());
        }
    }

    public static void printDebugInfo() {
        logger.debugInfo("Number of Durable Subscribers: " + nameToSubscriberMap.size());
        Iterator iter = nameToSubscriberMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ConsumerImpl ds2 = (ConsumerImpl)entry.getValue();
            String activeMode = ds2.isActive() ? "Active " : "Non-Active ";
            logger.debugInfo(activeMode + " Durable subscription " + (String)entry.getKey() + " for Topic " + ds2.getDestination().getName() + " with selector " + ds2.selector.getPattern());
        }
    }

    /*
     * Loose catch block
     */
    public static void printDatabaseDebugInfo() {
        block20: {
            SQLException sqle2222;
            ResultSet rs;
            Statement stmt;
            Connection conn;
            block18: {
                conn = null;
                stmt = null;
                rs = null;
                conn = DBManager.getInstance().getDBConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery(DEBUG_STMT);
                while (rs.next()) {
                    logger.debugInfo("\tclient id: " + rs.getString("client_id") + "\tsub. name: " + rs.getString("subscription_name") + "\tselector: " + rs.getString(DB_SELECTOR_FIELD) + "\tdest: " + rs.getString("dest_name"));
                }
                Object var5_3 = null;
                if (rs == null) break block18;
                try {
                    rs.close();
                }
                catch (SQLException sqle2222) {
                    logger.warning("Caught : " + sqle2222 + " while closing result set");
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sqle2222) {
                    logger.warning("Caught : " + sqle2222 + " while closing sql stmt");
                }
            }
            DBManager.getInstance().closeDBConnection(conn);
            {
                break block20;
                catch (SQLException sqle) {
                    SQLException sqle2222;
                    logger.warning("Error dumping message table: " + sqle.toString());
                    Object var5_4 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sqle2222) {
                            logger.warning("Caught : " + sqle2222 + " while closing result set");
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sqle2222) {
                            logger.warning("Caught : " + sqle2222 + " while closing sql stmt");
                        }
                    }
                    DBManager.getInstance().closeDBConnection(conn);
                }
            }
            catch (Throwable throwable) {
                SQLException sqle2222;
                Object var5_5 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sqle2222) {
                        logger.warning("Caught : " + sqle2222 + " while closing result set");
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqle2222) {
                        logger.warning("Caught : " + sqle2222 + " while closing sql stmt");
                    }
                }
                DBManager.getInstance().closeDBConnection(conn);
                throw throwable;
            }
        }
    }
}

