/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.MessageImpl;
import com.sun.jms.TextMessageImpl;
import com.sun.jms.service.ConsumerImpl;
import com.sun.jms.service.DBManager;
import com.sun.jms.service.InitialServiceContext;
import com.sun.jms.service.JMSServiceImpl;
import com.sun.jms.service.MessageConsumerImpl;
import com.sun.jms.service.SystemMessage;
import com.sun.jms.service.selector.JMSSelector;
import com.sun.jms.util.JMSProperties;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import com.sun.jms.util.Statistician;
import com.sun.jms.util.Statistics;
import com.sun.jms.util.Waiter;
import com.sun.jms.util.WaiterManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;

public abstract class DestinationImpl
implements Destination {
    public static final Logger logger = Log.getLogger(1);
    public static final Logger stoplogger = Log.getLogger(7);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");
    String name;
    boolean isTemporary = false;
    ArrayList messageBuffer = new ArrayList();
    private ArrayList incomingMessages = new ArrayList();
    ArrayList consumers = new ArrayList();
    int highWaterMark = 0;
    boolean beingClosed = false;
    Waiter messageBufferWaiter;
    private Statistician msgStatistician = new Statistician();
    private int maxMessages = -1;
    private int maxBytes = -1;
    private int currMessages = 0;
    private int currBytes = 0;
    private volatile boolean processingMessageBuffer = false;
    public static final String DB_TABLE_NAME = "destination";
    public static final String DB_DESTNAME_FIELD = "dest_name";
    public static final String DB_DESTTYPE_FIELD = "dest_type";
    public static final String DB_MAXMSGS_FIELD = "max_messages";
    public static final String DB_MAXBYTES_FIELD = "max_bytes";
    public static final String CREATE_DESTINATION_TABLE_STMT = "CREATE TABLE destination ( dest_name VARCHAR(256)  PRIMARY KEY NOT NULL, dest_type INT NOT NULL, max_messages INT, max_bytes INT )";
    public static final String DB_NAME_INDEX = "name_index";
    public static final String CREATE_NAME_INDEX_STMT = "CREATE INDEX name_index ON destination ( dest_name )";
    public static final String DEBUG_STMT = "SELECT * FROM destination";
    Hashtable transIndex = new Hashtable();

    protected AbstractList getConsumers() {
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            AbstractList abstractList = (AbstractList)this.consumers.clone();
            return abstractList;
        }
    }

    DestinationImpl(String name) {
        this(name, false);
    }

    protected DestinationImpl(String name, boolean isTemporary) {
        this(name, isTemporary, true);
    }

    protected DestinationImpl(String name, boolean isTemporary, boolean persistenceRequired) {
        this.name = name;
        this.isTemporary = isTemporary;
        if (!isTemporary) {
            if (persistenceRequired) {
                Connection con = null;
                try {
                    try {
                        con = DBManager.getInstance().getDBConnection();
                        this.store(con);
                    }
                    catch (SQLException sqle) {
                        logger.severe(sqle);
                        Object var7_6 = null;
                        DBManager.getInstance().closeDBConnection(con);
                    }
                    Object var7_5 = null;
                    DBManager.getInstance().closeDBConnection(con);
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    DBManager.getInstance().closeDBConnection(con);
                    throw throwable;
                }
            }
            InitialServiceContext.getInstance().bindDestination(this.getDestinationWrapper());
        }
        this.messageBufferWaiter = new Waiter(JMSServiceImpl.serviceThreadGroup, new WaiterManager(){

            public void activityDetected() {
                DestinationImpl.this.processMessageBuffer(null);
            }
        }, "jms.service Destination.messageBufferWaiter." + this.getName(), JMSProperties.getInstance().getWaiterTimeoutInterval());
        this.msgStatistician.start();
    }

    public void close() {
        if (this.beingClosed) {
            if (stoplogger.isLogging(7)) {
                stoplogger.finest(this.name + " is already being closed. Returning");
            }
            return;
        }
        this.beingClosed = true;
        stoplogger.entering(null);
        try {
            MessageImpl stopMsg;
            MessageImpl messageImpl = stopMsg = SystemMessage.createStopRequestMessage();
            synchronized (messageImpl) {
                this.addMessage(stopMsg);
                if (stoplogger.isLogging(7)) {
                    stoplogger.finest(this.name + " waiting for close notify");
                }
                SystemMessage.waitForWakeup(stopMsg);
            }
        }
        catch (JMSException e10) {
            stoplogger.warning(e10);
        }
        stoplogger.exiting(null);
    }

    private void performClose() {
        stoplogger.entering(null);
        if (!this.isTemporary) {
            InitialServiceContext.getInstance().unbindDestination(this.getDestinationWrapper());
        }
        stoplogger.exiting(null);
    }

    public void delete() throws JMSException {
        Connection con = null;
        if (this.isTemporary && this.hasRegisteredConsumers()) {
            throw new JMSException(resource.getString("destinationimpl.temporary_destination_has_consumers"));
        }
        this.close();
        try {
            block8: {
                try {
                    ArrayList arrayList = this.messageBuffer;
                    synchronized (arrayList) {
                        this.clearMessages(this.messageBuffer);
                    }
                    if (this.isTemporary) break block8;
                    con = DBManager.getInstance().getDBConnection();
                    this.remove(con);
                    MessageImpl.removeAll(con, this.getName());
                }
                catch (SQLException sqle) {
                    JMSException jmse = new JMSException(resource.getString("destinationimpl.error_cleaning_database"));
                    jmse.setLinkedException(sqle);
                    throw jmse;
                }
            }
            Object var5_6 = null;
            DBManager.getInstance().closeDBConnection(con);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            DBManager.getInstance().closeDBConnection(con);
            throw throwable;
        }
    }

    void register(ConsumerImpl consumer) throws JMSException {
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            this.consumers.add(consumer);
        }
        if (logger.isLogging(7)) {
            logger.finest("consumers.size(): " + this.consumers.size());
        }
    }

    void deregister(ConsumerImpl consumer) {
        ArrayList arrayList = this.consumers;
        synchronized (arrayList) {
            ((AbstractCollection)this.consumers).remove(consumer);
        }
        if (logger.isLogging(7)) {
            logger.finer("consumers size: " + this.consumers.size() + ", messageBuffer size: " + this.messageBuffer.size());
        }
    }

    abstract void registerWaitForSynchronousReceive(MessageConsumerImpl var1) throws JMSException;

    abstract void deregisterWaitForSynchronousReceive(MessageConsumerImpl var1);

    public String getName() {
        return this.name;
    }

    public String toString() {
        String str = this.getClass().getName() + ": name = '" + this.name + "'";
        return str;
    }

    public abstract boolean isQueue();

    boolean hasConsumers() {
        if (logger.isLogging(7)) {
            logger.finest("consumers size: " + this.consumers.size());
        }
        boolean hasConsumers = false;
        if (this.consumers != null && this.consumers.size() > 0) {
            hasConsumers = true;
            Iterator cIter = ((AbstractList)this.consumers).iterator();
            while (cIter.hasNext()) {
                ConsumerImpl c10 = (ConsumerImpl)cIter.next();
                if (!logger.isLogging(7)) continue;
                logger.finest("consumer.getId:" + c10.getId());
            }
        }
        return hasConsumers;
    }

    private boolean hasRegisteredConsumers() {
        if (logger.isLogging(7)) {
            logger.finest("registered consumers size: " + this.consumers.size());
        }
        return this.consumers != null && this.consumers.size() > 0;
    }

    private void updateHighWaterMark() {
        int msgCount = this.messageBuffer.size();
        if (msgCount > this.highWaterMark) {
            this.highWaterMark = msgCount;
        }
    }

    public int getBufferedMessageCount() {
        return this.messageBuffer.size();
    }

    public int getHighWaterMark() {
        return this.highWaterMark;
    }

    public String[] getMessageIds(String selector) throws JMSException {
        ArrayList idBuffer;
        Waiter waiter = this.messageBufferWaiter;
        synchronized (waiter) {
            idBuffer = (ArrayList)this.messageBuffer.clone();
        }
        try {
            ArrayList<String> ids = new ArrayList<String>(idBuffer.size());
            TextMessageImpl tempMsg = new TextMessageImpl();
            JMSSelector msgSelector = new JMSSelector(selector, tempMsg);
            int count = idBuffer.size();
            int i2 = 0;
            while (i2 < count) {
                MessageImpl msg = (MessageImpl)idBuffer.get(i2);
                if (msgSelector.match(msg)) {
                    ids.add(msg.getJMSMessageID());
                }
                ++i2;
            }
            count = ids.size();
            String[] tmp = new String[count];
            int i3 = 0;
            while (i3 < count) {
                tmp[i3] = (String)ids.get(i3);
                ++i3;
            }
            return tmp;
        }
        catch (Exception e10) {
            throw new JMSException(e10.toString());
        }
    }

    private ArrayList getTransBuffer(String transID) {
        ArrayList transBuffer = (ArrayList)this.transIndex.get(transID);
        if (transBuffer == null) {
            transBuffer = new ArrayList();
            this.transIndex.put(transID, transBuffer);
        }
        return transBuffer;
    }

    void prepareToSend(String transID, MessageImpl msg) {
        ArrayList transBuffer = this.getTransBuffer(transID);
        transBuffer.add(msg);
        if (logger.isLogging(7)) {
            logger.finest("total msg in Destination: " + this.messageBuffer.size());
        }
    }

    synchronized void undoPrepareToSend(String transactionID) {
        this.clearMessages(this.getTransBuffer(transactionID));
        this.transIndex.remove(transactionID);
    }

    private void clearMessages(Collection messages) {
        if (messages == null) {
            return;
        }
        Iterator msgIter = messages.iterator();
        MessageImpl msg = null;
        JMSServiceImpl service = JMSServiceImpl.getInstance();
        while (msgIter.hasNext()) {
            msg = (MessageImpl)msgIter.next();
            try {
                service.removeMessage(msg);
            }
            catch (JMSException e10) {
                // empty catch block
            }
            msgIter.remove();
        }
    }

    void sendingCommit(String transID) {
        ArrayList transBuffer = this.getTransBuffer(transID);
        this.addMessages(transBuffer);
        this.transIndex.remove(transID);
        if (logger.isLogging(7)) {
            logger.finest("transid=" + transID + " total msg in Destination: " + this.messageBuffer.size());
        }
    }

    protected void addMessages(Collection msgs) {
        ArrayList arrayList = this.incomingMessages;
        synchronized (arrayList) {
            this.incomingMessages.addAll(msgs);
        }
        if (!this.processingMessageBuffer) {
            this.messageBufferWaiter.wakeup();
        }
    }

    private void addMessageInternal(MessageImpl msg) {
        logger.finest(msg.toString());
        Waiter waiter = this.messageBufferWaiter;
        synchronized (waiter) {
            if (SystemMessage.isStopMessage(msg)) {
                this.messageBuffer.add(0, msg);
            } else {
                int i2;
                block9: {
                    i2 = 0;
                    try {
                        Comparator comp = MessageImpl.PriorityComparator.getInstance();
                        i2 = 0;
                        while (i2 < this.messageBuffer.size()) {
                            if (comp.compare(this.messageBuffer.get(i2), msg) > 0) {
                                ++i2;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e10) {
                        if (!logger.isLogging(3)) break block9;
                        logger.info("Message compare failure. " + e10.toString());
                    }
                }
                this.messageBuffer.add(i2, msg);
                this.updateHighWaterMark();
                this.incrementMessageCount();
            }
        }
    }

    void addMessage(MessageImpl msg) {
        ArrayList arrayList = this.incomingMessages;
        synchronized (arrayList) {
            this.incomingMessages.add(msg);
        }
        if (!this.processingMessageBuffer) {
            this.messageBufferWaiter.wakeup();
        }
    }

    abstract boolean sendMessageToConsumers(MessageImpl var1) throws JMSException;

    private boolean processStopMessage() {
        MessageImpl msg;
        boolean stopMsgProcessed = false;
        int msgCount = this.messageBuffer.size();
        if (msgCount > 0 && SystemMessage.isStopMessage(msg = (MessageImpl)this.messageBuffer.get(0))) {
            this.messageBufferWaiter.stopRunning();
            this.performClose();
            MessageImpl messageImpl = msg;
            synchronized (messageImpl) {
                SystemMessage.wakeup(msg);
            }
            stopMsgProcessed = true;
        }
        return stopMsgProcessed;
    }

    protected boolean okToProcessMessageBuffer() {
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MessageImpl processMessageBuffer(MessageConsumerImpl synchMsgConsumer) {
        block20: {
            block21: {
                this.processingMessageBuffer = true;
                try {
                    messageBufferProcessedOnce = false;
                    block10: while (true) {
                        var3_3 = this.incomingMessages;
                        synchronized (var3_3) {
                            if (this.incomingMessages.isEmpty() && messageBufferProcessedOnce) {
                                break block20;
                            }
                            iter = this.incomingMessages.iterator();
                            while (true) {
                                if (!iter.hasNext()) {
                                    // MONITOREXIT @DISABLED, blocks:[0, 18, 4, 10, 11] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
                                    messageBufferProcessedOnce = true;
                                    v0 = synchronousMessageReceive = synchMsgConsumer != null;
                                }
                                this.addMessageInternal((MessageImpl)iter.next());
                                iter.remove();
                            }
                        }
                        if (DestinationImpl.logger.isLogging(6)) {
                            if (!synchronousMessageReceive) {
                                DestinationImpl.logger.finer(this.getName() + " got a message");
                            } else {
                                DestinationImpl.logger.finer(this.getName() + " check for synchronous Message Consumer " + synchMsgConsumer.toString());
                            }
                        }
                        if (this.processStopMessage() || !this.okToProcessMessageBuffer() && !synchronousMessageReceive) continue;
                        msgIter = this.messageBuffer.iterator();
                        while (true) {
                            if (msgIter.hasNext()) ** break;
                            continue block10;
                            msg = (MessageImpl)msgIter.next();
                            try {
                                if (msg.hasExpired()) {
                                    msgIter.remove();
                                    this.decrementMessageCount();
                                    JMSServiceImpl.getInstance().removeMessage(msg);
                                    continue;
                                }
                                if (synchMsgConsumer == null) {
                                    if (!this.sendMessageToConsumers(msg)) continue;
                                    msgIter.remove();
                                    this.decrementMessageCount();
                                    continue;
                                }
                                if (!synchMsgConsumer.selectorMatch(msg)) continue;
                                msgIter.remove();
                                this.decrementMessageCount();
                                var7_9 = msg;
                                var9_10 = null;
                                this.processingMessageBuffer = false;
                                var10_13 = this.incomingMessages;
                                break block21;
                            }
                            catch (JMSException e) {
                                if (!DestinationImpl.logger.isLogging(5)) continue;
                                DestinationImpl.logger.fine("Could not send message " + msg + " to consumer of " + msg.getDestinationName() + " because: " + e.toString());
                                continue;
                            }
                            break;
                        }
                        break;
                    }
                }
                catch (Throwable var8_16) {
                    var9_12 = null;
                    this.processingMessageBuffer = false;
                    var10_15 = this.incomingMessages;
                    synchronized (var10_15) {
                        if (this.incomingMessages.isEmpty() != false) throw var8_16;
                        this.wakeup();
                        throw var8_16;
                    }
                }
            }
            synchronized (var10_13) {
                if (this.incomingMessages.isEmpty() != false) return var7_9;
                this.wakeup();
                return var7_9;
            }
        }
        var9_11 = null;
        this.processingMessageBuffer = false;
        var10_14 = this.incomingMessages;
        synchronized (var10_14) {
            if (this.incomingMessages.isEmpty() != false) return null;
            this.wakeup();
            return null;
        }
    }

    MessageImpl receiveNoWait(MessageConsumerImpl synchronousMessageConsumer) {
        Waiter waiter = this.messageBufferWaiter;
        synchronized (waiter) {
            MessageImpl messageImpl = this.processMessageBuffer(synchronousMessageConsumer);
            return messageImpl;
        }
    }

    void getUnAckedMessages(List unAckedMessages, boolean clearUnAcked) {
        unAckedMessages.clear();
        Iterator consumerIter = ((AbstractList)this.consumers).iterator();
        while (consumerIter.hasNext()) {
            MessageConsumerImpl consumer = (MessageConsumerImpl)consumerIter.next();
            try {
                consumer.getUnAckedMessages(unAckedMessages, clearUnAcked);
            }
            catch (JMSException e10) {
                if (!logger.isLogging(3)) continue;
                logger.info(e10);
            }
        }
    }

    void redeliverMessages(Collection messagesToRedeliver) throws JMSException {
        Iterator iter = messagesToRedeliver.iterator();
        while (iter.hasNext()) {
            MessageImpl msg = (MessageImpl)iter.next();
            msg.setJMSRedelivered(true);
            logger.finest(msg.toString());
        }
        this.addMessages(messagesToRedeliver);
    }

    void redeliverMessage(MessageImpl msg) throws JMSException {
        msg.setJMSRedelivered(true);
        this.addMessage(msg);
        if (logger.isLogging(6)) {
            logger.finer("resending msg:" + msg + ",  messageBuffer size: " + this.messageBuffer.size());
        }
    }

    void updateStatistics(MessageImpl msg) {
        try {
            if (!msg.getJMSRedelivered()) {
                long latency = msg.getTimeSinceReceivedByServer();
                this.msgStatistician.addSample(latency);
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public Statistics getStatistics() {
        Statistics stats = this.msgStatistician.getStatistics();
        return stats;
    }

    abstract com.sun.jms.DestinationImpl getDestinationWrapper();

    public static void createTable(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.execute(CREATE_DESTINATION_TABLE_STMT);
        logger.finest(DB_TABLE_NAME);
        stmt.execute(CREATE_NAME_INDEX_STMT);
    }

    public void store(Connection conn) throws SQLException {
        if (logger.isLogging(7)) {
            logger.finest("DATABASE EVENT: removing " + this.name + " from the db");
        }
        int destType = this.isQueue() ? 0 : 1;
        DBManager.executeUpdate(conn, "INSERT INTO destination VALUES ( '" + this.name + "', " + destType + ", " + this.maxMessages + ", " + this.maxBytes + " )");
    }

    public void remove(Connection conn) throws SQLException {
        if (logger.isLogging(7)) {
            logger.finest("DATABASE EVENT: removing " + this.name + " from the db");
        }
        DBManager.executeUpdate(conn, "DELETE FROM destination WHERE dest_name = '" + this.name + "'");
    }

    public void update(Connection conn) throws SQLException {
        if (logger.isLogging(7)) {
            logger.finest("DATABASE EVENT: updating " + this.name + " in the db");
        }
        DBManager.executeUpdate(conn, "UPDATE destination SET max_messages = " + this.maxMessages + ", " + DB_MAXBYTES_FIELD + " = " + this.maxBytes + " WHERE " + DB_DESTNAME_FIELD + " = '" + this.name + "'");
    }

    public abstract boolean hasDurableSubscribers();

    public boolean hasCapacity() {
        if (this.maxMessages == -1 || this.maxBytes == -1) {
            return true;
        }
        return true;
    }

    void incrementMessageCount() {
        ++this.currMessages;
    }

    void incrementMessageCount(int num) {
        this.currMessages += num;
    }

    void decrementMessageCount() {
        --this.currMessages;
    }

    public void updateMaxMessages(int newMax) {
        this.updateMaxMessages(newMax, false);
    }

    public void updateMaxMessages(int newMax, boolean persistenceRequired) {
        Connection con = null;
        this.maxMessages = newMax;
        if (persistenceRequired) {
            try {
                try {
                    con = DBManager.getInstance().getDBConnection();
                    this.update(con);
                }
                catch (SQLException sqle) {
                    if (logger.isLogging(3)) {
                        logger.info(sqle);
                    }
                    Object var6_5 = null;
                    DBManager.getInstance().closeDBConnection(con);
                }
                Object var6_4 = null;
                DBManager.getInstance().closeDBConnection(con);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                DBManager.getInstance().closeDBConnection(con);
                throw throwable;
            }
        }
    }

    public void updateMaxBytes(int newMax) {
        this.updateMaxBytes(newMax, false);
    }

    public void updateMaxBytes(int newMax, boolean persistenceRequired) {
        Connection con = null;
        this.maxBytes = newMax;
        if (persistenceRequired) {
            try {
                try {
                    con = DBManager.getInstance().getDBConnection();
                    this.update(con);
                }
                catch (SQLException sqle) {
                    if (logger.isLogging(3)) {
                        logger.info(sqle);
                    }
                    Object var6_5 = null;
                    DBManager.getInstance().closeDBConnection(con);
                }
                Object var6_4 = null;
                DBManager.getInstance().closeDBConnection(con);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                DBManager.getInstance().closeDBConnection(con);
                throw throwable;
            }
        }
    }

    void wakeup() {
        Waiter waiter = this.messageBufferWaiter;
        synchronized (waiter) {
            this.messageBufferWaiter.wakeup();
        }
    }

    /*
     * Loose catch block
     */
    public static void printDatabaseDebugInfo() {
        block25: {
            SQLException sqle2222;
            ResultSet rs;
            Statement stmt;
            Connection conn;
            block21: {
                conn = null;
                stmt = null;
                rs = null;
                conn = DBManager.getInstance().getDBConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery(DEBUG_STMT);
                while (rs.next()) {
                    logger.debugInfo("type: " + (rs.getInt(DB_DESTTYPE_FIELD) == 0 ? "Queue" : "Topic") + "\tname: " + rs.getString(DB_DESTNAME_FIELD));
                }
                Object var5_3 = null;
                if (rs == null) break block21;
                try {
                    rs.close();
                }
                catch (SQLException sqle2222) {
                    // empty catch block
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sqle2222) {
                    // empty catch block
                }
            }
            if (conn != null) {
                DBManager.getInstance().closeDBConnection(conn);
            }
            break block25;
            {
                catch (SQLException sqle) {
                    SQLException sqle2222;
                    logger.info("Error dumping message table: " + sqle.toString());
                    Object var5_4 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sqle2222) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sqle2222) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        DBManager.getInstance().closeDBConnection(conn);
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException sqle2222;
                Object var5_5 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sqle2222) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqle2222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    DBManager.getInstance().closeDBConnection(conn);
                }
                throw throwable;
            }
        }
    }

    void printDebugInfo() {
        if (this.isTemporary) {
            logger.debugInfo("isTemporary Destination");
        }
        logger.debugInfo("\n\tName: " + this.name + "\n\tNumber of consumers: " + this.consumers.size() + "\n\tNumber of Messages: " + this.messageBuffer.size());
    }
}

