/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import COM.cloudscape.core.BasicDataSource;
import COM.cloudscape.core.DataSourceFactory;
import COM.cloudscape.core.XaDataSource;
import COM.cloudscape.database.JBMSException;
import com.sun.jms.MessageImpl;
import com.sun.jms.service.DestinationImpl;
import com.sun.jms.service.DurableSubscription;
import com.sun.jms.service.Subscription;
import com.sun.jms.util.JMSProperties;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class DBManager {
    public static final int MAX_TIMEOUT_RETRIES = 10;
    public static final String SERVICE_JDBC_DATASOURCE = "com.sun.jms.service.jdbc.datasource";
    public static final String SERVICE_JDBC_DBPATH = "com.sun.jms.service.jdbc.dbpath";
    public static final String SERVICE_JDBC_DBNAME = "com.sun.jms.service.jdbc.dbname";
    String databaseURL = null;
    JMSProperties jmsProps = null;
    BasicDataSource source = null;
    XaDataSource xaSource = null;
    private static final String DATASOURCE_NAME_DEFAULT = "JMS XA DataSource";
    private static DBManager instance = null;
    private static final String SET_PROPERTY = "CALL PropertyInfo.setDatabaseProperty(";
    private static final String GET_PROPERTY = "VALUES PropertyInfo.getDatabaseProperty(";
    private static final String JDBC_PROPERTY_PREFIX = "cloudscape.";
    private static final String[] PROPERTY_NAME = new String[]{"'cloudscape.locks.deadlockTimeout'", "'cloudscape.locks.waitTimeout'", "'cloudscape.locks.monitor'"};
    private static final String[] PROPERTY_VALUE = new String[]{"'5'", "'10'", "'true'"};
    static Logger logger = Log.getLogger(1);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");

    private DBManager() {
        instance = this;
        this.jmsProps = JMSProperties.getInstance();
        this.constructDatabaseURL();
        this.loadDataSources();
        this.initializeDatabaseTables();
    }

    public static DBManager getInstance() {
        if (instance == null) {
            instance = new DBManager();
        }
        return instance;
    }

    /*
     * Loose catch block
     */
    private void setDatabaseProperties(Connection con) {
        block33: {
            SQLException sqe422;
            ResultSet rs;
            Statement stmt;
            block31: {
                stmt = null;
                rs = null;
                stmt = con.createStatement();
                int i2 = 0;
                while (i2 < PROPERTY_NAME.length) {
                    block30: {
                        try {
                            stmt.executeUpdate(SET_PROPERTY + PROPERTY_NAME[i2] + "," + PROPERTY_VALUE[i2] + ")");
                            rs = stmt.executeQuery(GET_PROPERTY + PROPERTY_NAME[i2] + ")");
                            rs.next();
                            if (logger.isLogging(7)) {
                                logger.finest(PROPERTY_NAME[i2] + " set to " + rs.getString(1));
                            }
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (SQLException sqe2) {}
                            }
                        }
                        catch (SQLException sqle) {
                            if (!logger.isLogging(5)) break block30;
                            logger.fine("Failed to execute statement to set or get database property name " + PROPERTY_NAME[i2]);
                        }
                    }
                    ++i2;
                }
                JMSProperties props = JMSProperties.getInstance();
                Iterator JDBCDriverPropsIter = props.getPropertyNamesStartingWith(JDBC_PROPERTY_PREFIX);
                String propertyName = null;
                String propertyValue = null;
                while (JDBCDriverPropsIter.hasNext()) {
                    try {
                        propertyName = (String)JDBCDriverPropsIter.next();
                        propertyValue = "'" + props.getProperty(propertyName) + "'";
                        propertyName = "'" + propertyName + "'";
                        stmt.executeUpdate(SET_PROPERTY + propertyName + "," + propertyValue + ")");
                        rs = stmt.executeQuery(GET_PROPERTY + propertyName + ")");
                        rs.next();
                        if (logger.isLogging(7)) {
                            logger.finest(propertyName + " set to " + rs.getString(1));
                        }
                        if (rs == null) continue;
                        try {
                            rs.close();
                        }
                        catch (SQLException sqe3) {}
                    }
                    catch (SQLException sqle) {
                        if (!logger.isLogging(5)) continue;
                        logger.fine("Failed to execute statement to set or get database property name " + propertyName + " to property value " + propertyValue);
                    }
                }
                Object var11_15 = null;
                if (rs == null) break block31;
                try {
                    rs.close();
                }
                catch (SQLException sqe422) {
                    // empty catch block
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sqe422) {}
            }
            break block33;
            {
                catch (Throwable t2) {
                    SQLException sqe422;
                    logger.warning(resource.getString("dbmanager.failed_to_set_database_properties"));
                    Object var11_16 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sqe422) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sqe422) {}
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException sqe422;
                Object var11_17 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sqe422) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqe422) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    void loadDataSources() {
        block6: {
            try {
                this.source = DataSourceFactory.getDataSource();
                this.source.setDatabaseName(this.getDatabaseURL());
                this.source.setCreateDatabase("create");
                if (logger.isLogging(6)) {
                    logger.finer("Created DataSource");
                }
            }
            catch (Exception e10) {
                this.source = null;
                logger.severe(resource.getString("dbmanager.failed_to_create_datasource"));
                logger.severe(e10);
            }
            try {
                this.xaSource = (XaDataSource)DataSourceFactory.getXADataSource();
                this.xaSource.setDatabaseName(this.getDatabaseURL());
                String sourceName = this.jmsProps.getProperty(SERVICE_JDBC_DATASOURCE, DATASOURCE_NAME_DEFAULT);
                if (logger.isLogging(6)) {
                    logger.finer("Created XADataSource:" + sourceName);
                }
            }
            catch (Exception e11) {
                this.xaSource = null;
                if (!logger.isLogging(1)) break block6;
                logger.severe(resource.getString("dbmanager.failed_to_create_xa_datasource"));
                logger.severe(e11);
            }
        }
    }

    void constructDatabaseURL() {
        this.databaseURL = this.jmsProps.getProperty(SERVICE_JDBC_DBPATH) + this.jmsProps.getProperty(SERVICE_JDBC_DBNAME);
        if (logger.isLogging(5)) {
            logger.fine("dbURL = '" + this.databaseURL + "'");
        }
    }

    public String getDatabaseURL() {
        return this.databaseURL;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void initializeDatabaseTables() {
        Connection conn;
        block31: {
            boolean createTables;
            conn = null;
            if (logger.isLogging(7)) {
                logger.finest("Getting first db connection at " + new Date());
            }
            conn = this.source.getConnection();
            this.setDatabaseProperties(conn);
            if (logger.isLogging(7)) {
                logger.finest("initializing database tables at " + new Date());
            }
            boolean bl2 = createTables = !this.tableExists(conn, "message");
            if (createTables) {
                try {
                    MessageImpl.createTable(conn);
                }
                catch (SQLException sqlex) {
                    logger.severe(sqlex);
                }
            } else if (logger.isLogging(7)) {
                logger.finest("Table already exists: message");
            }
            if (createTables) {
                try {
                    DestinationImpl.createTable(conn);
                }
                catch (SQLException sqlex) {
                    logger.info(sqlex);
                }
            } else if (logger.isLogging(7)) {
                logger.finest("Table already exists: destination");
            }
            if (createTables) {
                try {
                    DurableSubscription.createTable(conn);
                }
                catch (SQLException sqlex) {
                    logger.info(sqlex);
                }
            } else if (logger.isLogging(7)) {
                logger.finest("Table already exists: durable_subscriber");
            }
            if (createTables) {
                try {
                    Subscription.createTable(conn);
                }
                catch (SQLException sqlex) {
                    logger.info(sqlex);
                }
                break block31;
            }
            if (!logger.isLogging(7)) break block31;
            logger.finest("Table already exists: unacked_message");
        }
        Object var5_9 = null;
        if (logger.isLogging(7)) {
            logger.finest("finished initializing database tables at " + new Date());
        }
        if (conn == null) return;
        try {
            conn.close();
            return;
        }
        catch (SQLException e10) {
            logger.info(e10);
        }
        return;
        {
            catch (Exception e11) {
                logger.warning(e11);
                Object var5_10 = null;
                if (logger.isLogging(7)) {
                    logger.finest("finished initializing database tables at " + new Date());
                }
                if (conn == null) return;
                try {
                    conn.close();
                    return;
                }
                catch (SQLException e10) {
                    logger.info(e10);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            if (logger.isLogging(7)) {
                logger.finest("finished initializing database tables at " + new Date());
            }
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException e10) {
                logger.info(e10);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean tableExists(Connection conn, String tableName) throws SQLException {
        boolean exists = false;
        ResultSet tableSet = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            tableSet = dbmd.getTables(null, null, "%", null);
            while (tableSet.next()) {
                if (!tableName.equalsIgnoreCase(tableSet.getString("TABLE_NAME"))) continue;
                exists = true;
                break;
            }
            Object var7_6 = null;
            if (tableSet == null) return exists;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (tableSet == null) throw throwable;
            tableSet.close();
            throw throwable;
        }
        tableSet.close();
        return exists;
    }

    public synchronized Connection getDBConnection() throws SQLException {
        Connection connection = this.source.getConnection();
        connection.setAutoCommit(true);
        return connection;
    }

    public synchronized XAConnection getXADBConnection() throws SQLException {
        XAConnection connection = this.xaSource.getXAConnection();
        return connection;
    }

    public synchronized XAResource getXAResource() throws SQLException {
        return null;
    }

    public synchronized void closeDBConnection(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException sqle) {
            logger.info(sqle);
        }
    }

    public static void shutdown() {
        if (instance != null) {
            if (logger.isLogging(5)) {
                logger.fine("Shutting down database.....");
            }
            instance.cloudscapeShutdown();
        }
    }

    private void cloudscapeShutdown() {
        block4: {
            if (logger.isLogging(5)) {
                logger.fine("***** CloudScape specific shutdown sequence *****");
            }
            try {
                if (this.source != null) {
                    this.source.setShutdownDatabase("shutdown");
                    Connection connection = this.source.getConnection();
                    logger.fine("Database shut down abnormally Expected SQLException not thrown");
                }
            }
            catch (SQLException se) {
                if (!logger.isLogging(5)) break block4;
                logger.fine("Database shut down normally with expected SQLException: " + se.getMessage());
            }
        }
    }

    public static void printDebugInfo() {
        logger.debugInfo("\n\nMessage Table\n=============\n");
        MessageImpl.printDatabaseDebugInfo();
        logger.debugInfo("\n\nUnacked Message Table\n=====================\n");
        Subscription.printDatabaseDebugInfo();
        logger.debugInfo("\n\nDestination Table\n=================\n");
        DestinationImpl.printDatabaseDebugInfo();
        logger.debugInfo("\n\nSubscribers Table\n=================\n");
        DurableSubscription.printDatabaseDebugInfo();
    }

    /*
     * Loose catch block
     */
    public static void printLocksDebugInfo(Connection testConn) {
        block30: {
            SQLException se222;
            ResultSet rs;
            Statement stmt;
            Connection con;
            block28: {
                StringBuffer text = new StringBuffer(2000);
                boolean foundOne = false;
                try {
                    switch (testConn.getTransactionIsolation()) {
                        case 0: {
                            text.append("Isolation level is TRANSACTION_NONE  ");
                            break;
                        }
                        case 1: {
                            text.append("Isolation level is TRANSACTION_READ_UNCOMMITTED,  ");
                            break;
                        }
                        case 2: {
                            text.append("Isolation level is TRANSACTION_READ_COMMITTED,  ");
                            break;
                        }
                        case 4: {
                            text.append("Isolation level is TRANSACTION_REPEATABLE_READ,  ");
                            break;
                        }
                        case 8: {
                            text.append("Isolation level is TRANSACTION_SERIALIZABLE,  ");
                        }
                    }
                    text.append("Auto-commit is " + testConn.getAutoCommit() + "\n");
                }
                catch (SQLException e10) {
                    text.append("Isolation level is UNKNOWN, SQL exception: " + e10.toString() + "\n");
                }
                String SELECT_LOCKS_XID = "SELECT *  FROM NEW LockTable() AS LOCKS, NEW TransactionTable() AS Trans  WHERE Locks.xid = Trans.xid AND  Locks.TABLETYPE = 'T'";
                con = null;
                stmt = null;
                rs = null;
                con = DBManager.getInstance().getDBConnection();
                stmt = con.createStatement();
                rs = stmt.executeQuery("SELECT *  FROM NEW LockTable() AS LOCKS, NEW TransactionTable() AS Trans  WHERE Locks.xid = Trans.xid AND  Locks.TABLETYPE = 'T'");
                text.append("\nXid\tGlobalXid\tMode\tType\tState\tLockName\tTableName");
                while (rs.next()) {
                    foundOne = true;
                    text.append("\n" + rs.getString("XID") + "\t" + rs.getString("GLOBAL_XID") + "\t" + rs.getString("MODE") + "\t" + rs.getString("TYPE") + "\t" + rs.getString("STATE") + "\t" + rs.getString("LOCKNAME") + "\t" + rs.getString("TABLENAME"));
                }
                if (!foundOne) {
                    text.append("\n**** NO LOCKS FOUND ****");
                }
                logger.debugInfo(text.toString());
                Object var9_8 = null;
                if (stmt == null) break block28;
                try {
                    stmt.close();
                }
                catch (SQLException se222) {
                    // empty catch block
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException se222) {
                    // empty catch block
                }
            }
            DBManager.getInstance().closeDBConnection(con);
            {
                break block30;
                catch (SQLException se3) {
                    SQLException se222;
                    logger.info(se3);
                    Object var9_9 = null;
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException se222) {
                            // empty catch block
                        }
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException se222) {
                            // empty catch block
                        }
                    }
                    DBManager.getInstance().closeDBConnection(con);
                }
            }
            catch (Throwable throwable) {
                SQLException se222;
                Object var9_10 = null;
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException se222) {
                        // empty catch block
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException se222) {
                        // empty catch block
                    }
                }
                DBManager.getInstance().closeDBConnection(con);
                throw throwable;
            }
        }
    }

    public static boolean shouldRetry(Connection con, SQLException se) {
        boolean retry = true;
        try {
            JBMSException.checkJBMSException((SQLException)se);
        }
        catch (SQLException see) {
            retry = false;
        }
        return retry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int executeUpdate(Connection con, String stmtStr) throws SQLException {
        int result = 0;
        Statement stmt = con.createStatement();
        try {
            boolean notFinished = true;
            int numtries = 0;
            while (true) {
                block19: {
                    block18: {
                        if (!notFinished) break block18;
                        if (numtries < 10) break block19;
                    }
                    Object var9_10 = null;
                    break;
                }
                if (logger.isLogging(6)) {
                    logger.finer(stmtStr);
                }
                try {
                    result = stmt.executeUpdate(stmtStr);
                    notFinished = false;
                }
                catch (SQLException se) {
                    if (DBManager.shouldRetry(con, se)) {
                        DBManager.printLocksDebugInfo(con);
                        if (logger.isLogging(5)) {
                            logger.fine("retrying. failed " + stmtStr + " due to " + se);
                        }
                        try {
                            Thread.sleep(1000 * (numtries + 1));
                        }
                        catch (InterruptedException e10) {}
                    }
                    if (logger.isLogging(5)) {
                        logger.fine("no retry possible for executeUpdate due to exception " + se + " executing " + stmtStr);
                    }
                    notFinished = false;
                    throw se;
                }
                catch (Throwable t2) {
                    logger.warning(MessageFormat.format(resource.getString("dbmanager.handled_unexpected_exception"), t2.getMessage()));
                    logger.warning(t2);
                }
                ++numtries;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException e11) {
                logger.info(e11);
            }
            throw throwable;
        }
        try {}
        catch (SQLException e11) {
            logger.info(e11);
            return result;
        }
        stmt.close();
        return result;
    }

    static ResultSet executeQuery(Statement stmt, String stmtStr) throws SQLException {
        ResultSet rs = null;
        boolean notFinished = true;
        int numtries = 0;
        while (notFinished && numtries < 10) {
            if (logger.isLogging(7)) {
                logger.finest(stmtStr);
            }
            try {
                rs = stmt.executeQuery(stmtStr);
                notFinished = false;
            }
            catch (SQLException se) {
                if (DBManager.shouldRetry(stmt.getConnection(), se)) {
                    DBManager.printLocksDebugInfo(stmt.getConnection());
                    if (logger.isLogging(5)) {
                        logger.fine("retrying. failed " + stmtStr + " due to " + se);
                    }
                    try {
                        Thread.sleep(1000 * (numtries + 1));
                    }
                    catch (InterruptedException e10) {}
                }
                if (logger.isLogging(5)) {
                    logger.fine("no retry possible for executeQuery due to exception " + se + " executing " + stmtStr);
                }
                notFinished = false;
                throw se;
            }
            catch (Throwable t2) {
                logger.warning(MessageFormat.format(resource.getString("dbmanager.handled_unexpected_exception"), t2.getMessage()));
                logger.warning(t2);
            }
            ++numtries;
        }
        return rs;
    }
}

