/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.client;

import com.sun.jms.client.MessageConsumerImpl;
import com.sun.jms.client.TopicSessionImpl;
import com.sun.jms.util.JmsResourceBundle;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class TopicSubscriberImpl
extends MessageConsumerImpl
implements TopicSubscriber {
    Topic topic = null;
    boolean noLocal = false;
    String subscriptionName = null;
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.client.LocalStrings");

    TopicSubscriberImpl(Topic topic, String messageSelector, String subscriptionName, boolean nl, TopicSessionImpl qSession) {
        super(topic, qSession, messageSelector);
        this.subscriptionName = subscriptionName;
        this.topic = topic;
        this.noLocal = nl;
    }

    public Topic getTopic() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("topicsubscriberimpl.gettopic_on_closed_ts"));
        }
        return this.topic;
    }

    public boolean getNoLocal() throws JMSException {
        if (this.isClosed()) {
            throw new IllegalStateException(resource.getString("topicsubscriberimpl.getnolocal_on_closed_ts"));
        }
        return this.noLocal;
    }

    public void close() throws JMSException {
        super.close();
    }

    public String consumerTypeName() {
        return "TopicSubscriber";
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public boolean getIsDurable() {
        boolean isDurable = false;
        if (this.subscriptionName != null) {
            isDurable = true;
        }
        return isDurable;
    }
}

