/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms;

import java.io.Serializable;
import javax.transaction.xa.Xid;

public class XidImpl
implements Xid,
Serializable {
    private int formatId;
    private byte[] branchQualifier = new byte[64];
    private byte[] globalTxnId = new byte[64];
    private int gtLength;
    private int bqLength;
    public static final int MAXGTXNSIZE = 64;
    public static final int MAXBQUALSIZE = 64;
    public static final int NULL_XID = -1;
    private static final String hextab = "0123456789ABCDEF";

    public XidImpl() {
        this.formatId = -1;
        this.bqLength = 0;
        this.gtLength = 0;
    }

    public XidImpl(Xid xid) {
        this.copy(xid);
    }

    public void copy(Xid xid) {
        if (xid == null || xid.getFormatId() == -1) {
            this.formatId = -1;
            this.bqLength = 0;
            this.gtLength = 0;
            return;
        }
        this.formatId = xid.getFormatId();
        byte[] tmp = xid.getBranchQualifier();
        this.bqLength = tmp.length > 64 ? 64 : tmp.length;
        System.arraycopy(tmp, 0, this.branchQualifier, 0, this.bqLength);
        tmp = xid.getGlobalTransactionId();
        this.gtLength = tmp.length > 64 ? 64 : tmp.length;
        System.arraycopy(tmp, 0, this.globalTxnId, 0, this.gtLength);
    }

    public boolean equals(Object obj) {
        return this.equals((Xid)obj);
    }

    public boolean equals(Xid xid) {
        if (xid == null || this.formatId == -1) {
            return false;
        }
        return this.formatId == xid.getFormatId() && this.isEqualGlobalTxnId(xid.getGlobalTransactionId()) && this.isEqualBranchQualifier(xid.getBranchQualifier());
    }

    public int hashCode() {
        int hash = 0;
        if (this.bqLength >= 2) {
            hash += this.branchQualifier[this.bqLength - 1] << 8;
        }
        if (this.bqLength >= 1) {
            hash += this.branchQualifier[0];
        }
        if (this.gtLength >= 2) {
            hash += this.globalTxnId[this.gtLength - 1] << 24;
        }
        if (this.gtLength >= 1) {
            hash += this.globalTxnId[0] << 16;
        }
        return hash;
    }

    public String toLongString() {
        int value;
        StringBuffer data = new StringBuffer(200);
        data.append("{XID:hash(" + this.hashCode() + ")fmt(" + this.formatId + ")bq(");
        int i2 = 0;
        while (i2 < this.bqLength) {
            value = this.branchQualifier[i2] & 0xFF;
            data.append("0x" + hextab.charAt(value / 16) + hextab.charAt(value & 0xF));
            if (i2 != this.bqLength - 1) {
                data.append(",");
            }
            ++i2;
        }
        data.append(")gt(");
        i2 = 0;
        while (i2 < this.gtLength) {
            value = this.globalTxnId[i2] & 0xFF;
            data.append("0x" + hextab.charAt(value / 16) + hextab.charAt(value & 0xF));
            if (i2 != this.gtLength - 1) {
                data.append(",");
            }
            ++i2;
        }
        data.append(")}");
        return new String(data);
    }

    public String toString() {
        int value;
        StringBuffer data = new StringBuffer(256);
        if (this.formatId == -1) {
            return "NULL_XID";
        }
        int i2 = 0;
        while (i2 < this.bqLength) {
            value = this.branchQualifier[i2] & 0xFF;
            data.append(hextab.charAt(value / 16));
            data.append(hextab.charAt(value & 0xF));
            ++i2;
        }
        i2 = 0;
        while (i2 < this.gtLength) {
            value = this.globalTxnId[i2] & 0xFF;
            data.append(hextab.charAt(value / 16));
            data.append(hextab.charAt(value & 0xF));
            ++i2;
        }
        return new String(data);
    }

    public byte[] getBranchQualifier() {
        byte[] bq2 = new byte[this.bqLength];
        System.arraycopy(this.branchQualifier, 0, bq2, 0, this.bqLength);
        return bq2;
    }

    public void setBranchQualifier(byte[] bq2) {
        this.bqLength = bq2.length > 64 ? 64 : bq2.length;
        System.arraycopy(bq2, 0, this.branchQualifier, 0, this.bqLength);
    }

    public int getFormatId() {
        return this.formatId;
    }

    public void setFormatId(int formatId) {
        this.formatId = formatId;
    }

    public boolean isEqualBranchQualifier(byte[] bq2) {
        if (bq2 == null) {
            return this.bqLength == 0;
        }
        if (bq2.length != this.bqLength) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.bqLength) {
            if (bq2[i2] != this.branchQualifier[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public boolean isEqualGlobalTxnId(byte[] gt) {
        if (gt == null) {
            return this.gtLength == 0;
        }
        if (gt.length != this.gtLength) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.gtLength) {
            if (gt[i2] != this.globalTxnId[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public byte[] getGlobalTransactionId() {
        byte[] gt = new byte[this.gtLength];
        System.arraycopy(this.globalTxnId, 0, gt, 0, this.gtLength);
        return gt;
    }

    public void setGlobalTransactionId(byte[] gt) {
        this.gtLength = gt.length > 64 ? 64 : gt.length;
        System.arraycopy(gt, 0, this.globalTxnId, 0, this.gtLength);
    }
}

