/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms;

import com.sun.jms.BytesMessageImpl;
import com.sun.jms.ClientSession;
import com.sun.jms.DestinationImpl;
import com.sun.jms.MapMessageImpl;
import com.sun.jms.ObjectMessageImpl;
import com.sun.jms.StreamMessageImpl;
import com.sun.jms.TextMessageImpl;
import com.sun.jms.service.DBManager;
import com.sun.jms.util.JMSProperties;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public class MessageImpl
implements Message,
Cloneable,
Serializable {
    public static final Logger logger = Log.getLogger(0);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.LocalStrings");
    private static final int DESTINATIONIDX = 0;
    private static final int DELIVERYMODEIDX = 1;
    private static final int EXPIRATIONIDX = 2;
    private static final int PRIORITYIDX = 3;
    private static final int MESSAGEIDIDX = 4;
    private static final int TIMESTAMPIDX = 5;
    private static final int CORRELATIONIDIDX = 6;
    private static final int REPLYTOIDX = 7;
    private static final int TYPEIDX = 8;
    private static final int MAXIDX = 9;
    private static final int MAX_REDELIVERY_COUNT = MessageImpl.getMaxRedeliveryAttempts();
    Object[] headerProps;
    HashMap applicationProps;
    transient Object[] deliveredHeaderProps;
    transient HashMap deliveredApplicationProps;
    private int internalMessageID;
    private int deliveryCount = 0;
    private transient boolean propsModifiable;
    private transient boolean bodyModifiable;
    private transient boolean modifiedAfterDelivery;
    boolean hasBeenDelivered;
    private transient String factoryID;
    private transient int connectionID;
    private transient int sessionID;
    private transient int consumerID;
    private transient int producerID;
    private transient ClientSession session;
    private transient long timeReceivedByServer = 0L;
    private transient int refCount = 0;
    public static final String DB_TABLE_NAME = "message";
    public static final String DB_MSGID_FIELD = "msg_id";
    public static final String DB_DESTNAME_FIELD = "dest_name";
    public static final String DB_MSGSTATE_FIELD = "msg_state";
    public static final String DB_MSGTXID_FIELD = "msg_txid";
    public static final String DB_MSGOBJ_FIELD = "msg_object";
    public static final String CREATE_MSG_TABLE_STMT = "CREATE TABLE message ( msg_id VARCHAR(256) NOT NULL, dest_name VARCHAR(256) NOT NULL, msg_txid VARCHAR(256), msg_object SERIALIZE( com.sun.jms.MessageImpl ), PRIMARY KEY ( msg_id )  )";
    public static final String DB_ID_INDEX = "id_index";
    public static final String CREATE_ID_INDEX_STMT = "CREATE INDEX id_index ON message ( msg_id )";
    public static final String INSERT_MSG_STMT = "INSERT INTO message VALUES ( ?, ?, ?, ? )";
    public static final String UPDATE_MSG_STATE_STMT = "UPDATE message SET msg_state = ? WHERE msg_id = ?";
    public static final String DELETE_MSG_STMT = "DELETE FROM message WHERE msg_id = ?";
    public static final String DEBUG_STMT = "SELECT msg_id, dest_name, msg_txid, msg_object FROM message";
    public static final long DEFAULT_EXPIRATION = 0L;
    private final int CREATE = 1;
    private final int LOOKUP = 2;
    private final int CLONE = 3;
    private Hashtable emptytable = new Hashtable(1);
    public static final int NOT_A_CLOSE_MSG = 0;
    public static final int NORMAL_CLOSE_MSG = 1;
    public static final int CONTROL_CLOSE_MSG = 2;
    private int closeMessageForServerSession = 0;

    public MessageImpl() {
        this.headerProps = new Object[9];
        try {
            this.setJMSPriority(4);
        }
        catch (JMSException e10) {
            // empty catch block
        }
        try {
            this.clearProperties();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.setBodyModifiable(true);
        this.hasBeenDelivered = false;
        this.modifiedAfterDelivery = true;
    }

    private HashMap getApplicationProps(int mode) {
        if (this.applicationProps == null) {
            switch (mode) {
                case 1: {
                    this.applicationProps = new HashMap(11);
                    return this.applicationProps;
                }
                case 2: 
                case 3: {
                    return null;
                }
            }
        }
        return mode == 3 ? (HashMap)this.applicationProps.clone() : this.applicationProps;
    }

    public MessageImpl(Message msg) throws JMSException {
        this();
        String correlationID = null;
        try {
            correlationID = msg.getJMSCorrelationID();
        }
        catch (JMSException e10) {
            logger.warning(e10);
        }
        this.setJMSCorrelationID(correlationID);
        int deliveryMode = 2;
        try {
            deliveryMode = msg.getJMSDeliveryMode();
        }
        catch (JMSException e11) {
            logger.warning(e11);
        }
        this.setJMSDeliveryMode(deliveryMode);
        Destination destination = null;
        try {
            destination = msg.getJMSDestination();
            destination = DestinationImpl.createNativeDestination(destination);
        }
        catch (JMSException e12) {
            logger.warning(e12);
        }
        this.setJMSDestination(destination);
        long expiration = 0L;
        try {
            expiration = msg.getJMSExpiration();
        }
        catch (JMSException e13) {
            logger.warning(e13);
        }
        this.setJMSExpiration(expiration);
        String msgID = null;
        try {
            msgID = msg.getJMSMessageID();
        }
        catch (JMSException e14) {
            logger.warning(e14);
        }
        this.setJMSMessageID(msgID);
        if (correlationID == null) {
            this.setJMSCorrelationID(msgID);
        }
        int priority = 4;
        try {
            priority = msg.getJMSPriority();
        }
        catch (JMSException e15) {
            logger.warning(e15);
        }
        this.setJMSPriority(priority);
        boolean redelivered = false;
        try {
            redelivered = msg.getJMSRedelivered();
        }
        catch (JMSException e16) {
            logger.warning(e16);
        }
        this.setJMSRedelivered(redelivered);
        Destination replyToDest = null;
        try {
            replyToDest = msg.getJMSReplyTo();
            replyToDest = DestinationImpl.createNativeDestination(replyToDest);
        }
        catch (JMSException e17) {
            logger.warning(e17);
        }
        this.setJMSReplyTo(replyToDest);
        long timeStamp = 0L;
        try {
            timeStamp = msg.getJMSTimestamp();
        }
        catch (JMSException e18) {
            logger.warning(e18);
        }
        this.setJMSTimestamp(timeStamp);
        String jmsType = null;
        try {
            jmsType = msg.getJMSType();
        }
        catch (JMSException e19) {
            logger.warning(e19);
        }
        this.setJMSType(jmsType);
        Enumeration e20 = msg.getPropertyNames();
        while (e20.hasMoreElements()) {
            String propName = (String)e20.nextElement();
            try {
                Object objProp = msg.getObjectProperty(propName);
                this.setObjectProperty(propName, objProp);
            }
            catch (JMSException ex2) {
                logger.warning(ex2);
            }
        }
    }

    public static final MessageImpl createNativeMessage(Message msg) throws JMSException {
        if (!(msg instanceof MessageImpl)) {
            if (msg instanceof TextMessage) {
                msg = new TextMessageImpl((TextMessage)msg);
            } else if (msg instanceof ObjectMessage) {
                msg = new ObjectMessageImpl((ObjectMessage)msg);
            } else if (msg instanceof StreamMessage) {
                msg = new StreamMessageImpl((StreamMessage)msg);
            } else if (msg instanceof MapMessage) {
                msg = new MapMessageImpl((MapMessage)msg);
            } else if (msg instanceof BytesMessage) {
                msg = new BytesMessageImpl((BytesMessage)msg);
            } else if (msg instanceof Message) {
                msg = new MessageImpl(msg);
            } else {
                throw new JMSException(MessageFormat.format(resource.getString("messageimpl.unknown_message_type"), msg.getClass().getName()));
            }
        }
        return (MessageImpl)msg;
    }

    public Object clone() {
        MessageImpl msg = null;
        try {
            msg = (MessageImpl)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        msg.headerProps = (Object[])this.headerProps.clone();
        if (this.arePropertiesModifiable()) {
            msg.applicationProps = this.getApplicationProps(3);
        }
        return msg;
    }

    public MessageImpl getDeliveredMessage() {
        if (this.modifiedAfterDelivery()) {
            MessageImpl m2 = (MessageImpl)this.clone();
            m2.modifiedAfterDelivery = false;
            if (this.deliveredHeaderProps != null) {
                m2.headerProps = (Object[])this.deliveredHeaderProps.clone();
            }
            m2.applicationProps = this.deliveredApplicationProps;
            return m2;
        }
        return this;
    }

    public void setPropertiesModifiable(boolean state) {
        this.propsModifiable = state;
    }

    public boolean arePropertiesModifiable() {
        return this.propsModifiable;
    }

    public String getJMSMessageID() throws JMSException {
        String id = null;
        if (this.headerProps[4] != null) {
            id = (String)this.headerProps[4];
        }
        return id;
    }

    public long getJMSTimestamp() throws JMSException {
        long timestamp = 0L;
        if (this.headerProps[5] != null) {
            timestamp = (Long)this.headerProps[5];
        }
        return timestamp;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        try {
            return this.getJMSCorrelationID().getBytes("ISO8859_1");
        }
        catch (UnsupportedEncodingException e10) {
            JMSException jmse = new JMSException(resource.getString("messageimpl.unsupportedencodingexception"));
            jmse.setLinkedException(e10);
            throw jmse;
        }
    }

    public String getJMSCorrelationID() throws JMSException {
        return (String)this.headerProps[6];
    }

    public Destination getJMSReplyTo() throws JMSException {
        return (Destination)this.headerProps[7];
    }

    public Destination getJMSDestination() throws JMSException {
        return (Destination)this.headerProps[0];
    }

    public int getJMSDeliveryMode() throws JMSException {
        int deliveryMode = 2;
        if (this.headerProps[1] != null) {
            deliveryMode = (Integer)this.headerProps[1];
        }
        return deliveryMode;
    }

    public boolean getJMSRedelivered() throws JMSException {
        boolean redelivered = false;
        if (this.deliveryCount > 0) {
            redelivered = true;
        }
        return redelivered;
    }

    public String getJMSType() throws JMSException {
        return (String)this.headerProps[8];
    }

    public long getJMSExpiration() throws JMSException {
        long expiration = 0L;
        if (this.headerProps[2] != null) {
            expiration = (Long)this.headerProps[2];
        }
        return expiration;
    }

    public int getJMSPriority() throws JMSException {
        int priority = 0;
        if (this.headerProps[3] == null) {
            throw new JMSException(resource.getString("messageimpl.priority_not_set"));
        }
        priority = (Integer)this.headerProps[3];
        return priority;
    }

    public void setJMSMessageID(String id) throws JMSException {
        this.cacheHeaderProps();
        this.headerProps[4] = id;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.cacheHeaderProps();
        this.headerProps[5] = new Long(timestamp);
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        this.cacheHeaderProps();
        this.setJMSCorrelationID(new String(correlationID));
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.cacheHeaderProps();
        this.headerProps[6] = correlationID;
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this.cacheHeaderProps();
        this.headerProps[7] = replyTo;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.cacheHeaderProps();
        this.headerProps[0] = destination;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this.cacheHeaderProps();
        this.headerProps[1] = new Integer(deliveryMode);
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        if (redelivered) {
            if (this.deliveryCount < 1) {
                this.setDeliveryCount(1);
            }
        } else {
            this.setDeliveryCount(0);
        }
    }

    public void setJMSType(String type) throws JMSException {
        this.cacheHeaderProps();
        this.headerProps[8] = type;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.cacheHeaderProps();
        this.headerProps[2] = new Long(expiration);
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.cacheHeaderProps();
        if (priority > 9) {
            priority = 9;
        }
        this.headerProps[3] = new Integer(priority);
    }

    public void clearProperties() throws JMSException {
        this.cacheProperties();
        this.applicationProps = null;
        this.setPropertiesModifiable(true);
    }

    public boolean propertyExists(String name) throws JMSException {
        return this.applicationProps == null ? false : this.getApplicationProps(2).containsKey(name);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        if (this.propertyExists(name)) {
            Object o2 = this.getApplicationProps(2).get(name);
            String className = o2.getClass().getName();
            if (className.equals("java.lang.Boolean")) {
                return (Boolean)o2;
            }
            if (className.equals("java.lang.String")) {
                return Boolean.valueOf((String)o2);
            }
            throw new MessageFormatException(MessageFormat.format(resource.getString("messageimpl.unsupported_conversion_to_boolean"), className));
        }
        return Boolean.valueOf(null);
    }

    public byte getByteProperty(String name) throws JMSException {
        if (this.propertyExists(name)) {
            Object o2 = this.getApplicationProps(2).get(name);
            String className = o2.getClass().getName();
            if (className.equals("java.lang.Byte")) {
                return (Byte)o2;
            }
            if (className.equals("java.lang.String")) {
                return Byte.parseByte((String)o2);
            }
            throw new MessageFormatException(MessageFormat.format(resource.getString("messageimpl.unsupported_conversion_to_byte"), className));
        }
        return Byte.valueOf(null);
    }

    public short getShortProperty(String name) throws JMSException {
        if (this.propertyExists(name)) {
            Object o2 = this.getApplicationProps(2).get(name);
            String className = o2.getClass().getName();
            if (className.equals("java.lang.Short")) {
                return (Short)o2;
            }
            if (className.equals("java.lang.Byte")) {
                return ((Byte)o2).byteValue();
            }
            if (className.equals("java.lang.String")) {
                return Short.parseShort((String)o2);
            }
            throw new MessageFormatException(MessageFormat.format(resource.getString("messageimpl.unsupported_conversion_to_short"), className));
        }
        return Short.valueOf(null);
    }

    public int getIntProperty(String name) throws JMSException {
        if (this.propertyExists(name)) {
            Object o2 = this.getApplicationProps(2).get(name);
            String className = o2.getClass().getName();
            if (className.equals("java.lang.Integer")) {
                return (Integer)o2;
            }
            if (className.equals("java.lang.Short")) {
                return ((Short)o2).intValue();
            }
            if (className.equals("java.lang.Byte")) {
                return ((Byte)o2).intValue();
            }
            if (className.equals("java.lang.String")) {
                return Integer.parseInt((String)o2);
            }
            throw new MessageFormatException(MessageFormat.format(resource.getString("messageimpl.unsupported_conversion_to_integer"), className));
        }
        return Integer.valueOf(null);
    }

    public long getLongProperty(String name) throws JMSException {
        if (this.propertyExists(name)) {
            Object o2 = this.getApplicationProps(2).get(name);
            String className = o2.getClass().getName();
            if (className.equals("java.lang.Long")) {
                return (Long)o2;
            }
            if (className.equals("java.lang.Byte")) {
                return ((Byte)o2).longValue();
            }
            if (className.equals("java.lang.Short")) {
                return ((Short)o2).longValue();
            }
            if (className.equals("java.lang.Integer")) {
                return ((Integer)o2).longValue();
            }
            if (className.equals("java.lang.String")) {
                return Long.parseLong((String)o2);
            }
            throw new MessageFormatException(MessageFormat.format(resource.getString("messageimpl.unsupported_conversion_to_long"), className));
        }
        return Long.valueOf(null);
    }

    public float getFloatProperty(String name) throws JMSException {
        if (this.propertyExists(name)) {
            Object o2 = this.getApplicationProps(2).get(name);
            String className = o2.getClass().getName();
            if (className.equals("java.lang.Float")) {
                return ((Float)o2).floatValue();
            }
            if (className.equals("java.lang.String")) {
                return Float.parseFloat((String)o2);
            }
            throw new MessageFormatException(MessageFormat.format(resource.getString("messageimpl.unsupported_conversion_to_float"), className));
        }
        return Float.valueOf(null).floatValue();
    }

    public double getDoubleProperty(String name) throws JMSException {
        if (this.propertyExists(name)) {
            Object o2 = this.getApplicationProps(2).get(name);
            String className = o2.getClass().getName();
            if (className.equals("java.lang.Double")) {
                return (Double)o2;
            }
            if (className.equals("java.lang.Float")) {
                return ((Float)o2).doubleValue();
            }
            if (className.equals("java.lang.String")) {
                return Double.parseDouble((String)o2);
            }
            throw new MessageFormatException(MessageFormat.format(resource.getString("messageimpl.unsupported_conversion_to_double"), className));
        }
        return Double.valueOf(null);
    }

    public String getStringProperty(String name) throws JMSException {
        if (!this.propertyExists(name)) {
            return null;
        }
        Object o2 = this.getApplicationProps(2).get(name);
        String className = o2.getClass().getName();
        if (className.equals("java.lang.String")) {
            return (String)o2;
        }
        if (className.equals("java.lang.Boolean")) {
            return ((Boolean)o2).toString();
        }
        if (className.equals("java.lang.Byte")) {
            return ((Byte)o2).toString();
        }
        if (className.equals("java.lang.Short")) {
            return ((Short)o2).toString();
        }
        if (className.equals("java.lang.Integer")) {
            return ((Integer)o2).toString();
        }
        if (className.equals("java.lang.Long")) {
            return ((Long)o2).toString();
        }
        if (className.equals("java.lang.Float")) {
            return ((Float)o2).toString();
        }
        if (className.equals("java.lang.Double")) {
            return ((Double)o2).toString();
        }
        throw new MessageFormatException(MessageFormat.format(resource.getString("messageimpl.unsupported_conversion_to_string"), className));
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (!this.propertyExists(name)) {
            return null;
        }
        return this.getApplicationProps(2).get(name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        return this.applicationProps == null ? this.emptytable.keys() : Collections.enumeration(this.getApplicationProps(2).keySet());
    }

    private boolean isPropNameValid(String propName) {
        if (propName.equalsIgnoreCase("NULL") || propName.equalsIgnoreCase("TRUE") || propName.equalsIgnoreCase("FALSE") || propName.equals("NOT") || propName.equals("AND") || propName.equals("OR") || propName.equals("BETWEEN") || propName.equals("LIKE") || propName.equals("IN") || propName.equals("IS")) {
            return false;
        }
        char[] name = propName.toCharArray();
        if (Character.isJavaIdentifierStart(name[0])) {
            int i2 = 1;
            while (i2 < name.length) {
                if (!Character.isJavaIdentifierPart(name[i2])) {
                    return false;
                }
                ++i2;
            }
        } else {
            return false;
        }
        return true;
    }

    private void setProp(String name, Object value) throws JMSException {
        if (this.isPropNameValid(name)) {
            if (!this.arePropertiesModifiable()) {
                throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
            }
        } else {
            throw new JMSException(resource.getString("messageimpl.invalid_property_name"));
        }
        this.getApplicationProps(1).put(name, value);
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.setProp(name, new Boolean(value));
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.setProp(name, new Byte(value));
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.setProp(name, new Short(value));
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.setProp(name, new Integer(value));
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.setProp(name, new Long(value));
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.setProp(name, new Float(value));
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.setProp(name, new Double(value));
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.setProp(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        String className = value.getClass().getName();
        if (!(className.equals("java.lang.Boolean") || className.equals("java.lang.Byte") || className.equals("java.lang.Short") || className.equals("java.lang.Integer") || className.equals("java.lang.Long") || className.equals("java.lang.Float") || className.equals("java.lang.Double") || className.equals("java.lang.String"))) {
            throw new MessageFormatException(resource.getString("messageimpl.unsupported_object_parameter"));
        }
        this.setProp(name, value);
    }

    public void acknowledge() throws JMSException {
        if (this.session == null) {
            logger.fine("Internal Exception; Message.acknowledge() called on a null session.");
        }
        this.session.acknowledge(this);
    }

    public void setSession(ClientSession s2) {
        this.session = s2;
    }

    public ClientSession getSession() {
        return this.session;
    }

    public String toString() {
        String msgID = null;
        String msgInfo = null;
        try {
            msgID = this.getJMSMessageID();
            msgInfo = this.getStringProperty("COM_SUN_JMS_TESTNAME");
            if (msgInfo != null) {
                msgID = msgID + " from test " + msgInfo;
            }
            return msgID;
        }
        catch (JMSException e10) {
            return "(JMSMessageID not set)";
        }
    }

    public void clearBody() throws JMSException {
        this.setBodyModifiable(true);
        this.setModifiedAfterDeliveryTrue();
    }

    public void setFactoryID(String id) {
        this.factoryID = id;
    }

    public void setConnectionID(int id) {
        this.connectionID = id;
    }

    public void setSessionID(int id) {
        this.sessionID = id;
    }

    public void setConsumerID(int id) {
        this.consumerID = id;
    }

    public void setProducerID(int id) {
        this.producerID = id;
    }

    public void setInternalMessageID(int id) {
        this.internalMessageID = id;
    }

    public String getFactoryID() {
        return this.factoryID;
    }

    public int getConnectionID() {
        return this.connectionID;
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public int getConsumerID() {
        return this.consumerID;
    }

    public int getProducerID() {
        return this.producerID;
    }

    public int getInternalMessageID() {
        return this.internalMessageID;
    }

    public static String makeJMSMessageID(String pclientID, int connectionID, int sessionID, int JMSSunMessageID) {
        return "ID:" + pclientID + "." + connectionID + "." + sessionID + "." + JMSSunMessageID;
    }

    public boolean hasExpired() throws JMSException {
        boolean expired = false;
        long expirationTime = this.getJMSExpiration();
        long currentTime = System.currentTimeMillis();
        if (expirationTime > 0L && expirationTime < currentTime) {
            expired = true;
        }
        return expired;
    }

    public void receivedByServer() {
        this.timeReceivedByServer = System.currentTimeMillis();
    }

    public long getTimeSinceReceivedByServer() throws JMSException {
        if (this.timeReceivedByServer == 0L) {
            throw new JMSException(resource.getString("messageimpl.not_received_by_server"));
        }
        long now = System.currentTimeMillis();
        long deltaTime = now - this.timeReceivedByServer;
        return deltaTime;
    }

    public String getDestinationName() {
        DestinationImpl dest = null;
        try {
            dest = (DestinationImpl)this.getJMSDestination();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return dest != null ? dest.getName() : "";
    }

    public String getMessageType() {
        return this.getClass().toString();
    }

    public String getJMSDeliveryModeAsString() throws JMSException {
        int deliveryMode = this.getJMSDeliveryMode();
        String strDeliveryMode = "";
        switch (deliveryMode) {
            case 2: {
                strDeliveryMode = "PERSISTENT";
                break;
            }
            case 1: {
                strDeliveryMode = "NON_PERSISTENT";
                break;
            }
            default: {
                throw new JMSException(MessageFormat.format(resource.getString("messageimpl.invalid_delivery_mode"), new Integer(deliveryMode)));
            }
        }
        return strDeliveryMode;
    }

    public String getJMSExpirationAsString() throws JMSException {
        long expirationTime = this.getJMSExpiration();
        String expirationStr = "Never Expires";
        if (expirationTime != 0L) {
            Date date = new Date(expirationTime);
            expirationStr = DateFormat.getDateTimeInstance().format(date);
        }
        return expirationStr;
    }

    public String getJMSTimestampAsString() throws JMSException {
        long timeStamp = this.getJMSTimestamp();
        Date date = new Date(timeStamp);
        String dateStr = DateFormat.getDateTimeInstance().format(date);
        return dateStr;
    }

    public String getBodyAsString() {
        return "";
    }

    public void resetRefCount() {
        this.refCount = 0;
    }

    public int getRefCount() {
        return this.refCount;
    }

    public void incrementRefCount() {
        ++this.refCount;
    }

    public void decrementRefCount() throws JMSException {
        if (this.refCount == 0) {
            throw new JMSException("MessageImpl#decrementRefCount: refCount already 0");
        }
        --this.refCount;
    }

    public static void createTable(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.execute(CREATE_MSG_TABLE_STMT);
        if (logger.isLogging(7)) {
            logger.finest("Created table: message");
        }
        stmt.execute(CREATE_ID_INDEX_STMT);
        if (logger.isLogging(7)) {
            logger.finest("Created index: id_index");
        }
        stmt.close();
    }

    public void store(Connection conn, PreparedStatement pstmt) throws SQLException {
        String txid;
        if (logger.isLogging(7)) {
            logger.finest("DATABASE EVENT: storing message " + (String)this.headerProps[4]);
        }
        pstmt.setString(1, (String)this.headerProps[4]);
        pstmt.setString(2, this.getDestinationName());
        try {
            txid = this.getStringProperty("JMSXProducerTXID");
            if (txid == null) {
                txid = "none specified";
            }
        }
        catch (JMSException e10) {
            txid = "none specified";
        }
        pstmt.setString(3, txid);
        pstmt.setObject(4, this);
        boolean notFinished = true;
        int numtries = 0;
        while (notFinished && numtries < 10) {
            try {
                pstmt.execute();
                notFinished = false;
            }
            catch (SQLException sqle) {
                if (DBManager.shouldRetry(conn, sqle)) {
                    if (logger.isLogging(7)) {
                        logger.finer(sqle);
                        logger.finest("retrying store of message " + this);
                    }
                    try {
                        Thread.sleep(1000 * (numtries + 1));
                    }
                    catch (InterruptedException e11) {
                        // empty catch block
                    }
                    ++numtries;
                    continue;
                }
                throw sqle;
            }
        }
    }

    public void remove(Connection conn, PreparedStatement pstmt) throws SQLException {
        if (logger.isLogging(7)) {
            logger.finest("DATABASE EVENT: removing message " + (String)this.headerProps[4] + " from db");
        }
        pstmt.setString(1, (String)this.headerProps[4]);
        boolean notFinished = true;
        int numtries = 0;
        while (notFinished && numtries < 10) {
            try {
                pstmt.execute();
                notFinished = false;
            }
            catch (SQLException sqle) {
                if (DBManager.shouldRetry(conn, sqle)) {
                    if (logger.isLogging(7)) {
                        logger.finest("retrying store of message " + this + " due to " + sqle);
                    }
                    try {
                        Thread.sleep(1000 * (numtries + 1));
                    }
                    catch (InterruptedException e10) {
                        // empty catch block
                    }
                    ++numtries;
                    continue;
                }
                throw sqle;
            }
        }
    }

    public static void removeAll(Connection conn, String destName) throws SQLException {
        if (logger.isLogging(7)) {
            logger.finest("DATABASE EVENT: removing all messages for destination " + destName);
        }
        Statement stmt = conn.createStatement();
        stmt.execute("DELETE FROM message WHERE dest_name = '" + destName + "'");
        stmt.close();
    }

    public boolean isPersistent() throws JMSException {
        return this.getJMSDeliveryMode() == 2;
    }

    public static Collection getMessagesForResultSet(ResultSet rs) throws SQLException {
        ArrayList<MessageImpl> messages = new ArrayList<MessageImpl>();
        while (rs != null && rs.next()) {
            MessageImpl message = (MessageImpl)rs.getObject(DB_MSGOBJ_FIELD);
            messages.add(message);
        }
        return messages;
    }

    static int getMaxRedeliveryAttempts() {
        int attempts = 10;
        try {
            String attemptsProp = JMSProperties.getInstance().getProperty("com.sun.jms.service.max_redelivery_attempts");
            if (attemptsProp != null) {
                attempts = Integer.parseInt(attemptsProp);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return attempts;
    }

    public boolean exceedsMaxRedeliveryCount() {
        return this.getDeliveryCount() >= MessageImpl.getMaxRedeliveryAttempts();
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    public void setDeliveryCount(int cnt) {
        this.deliveryCount = cnt;
    }

    public int incrementDeliveryCount() {
        ++this.deliveryCount;
        try {
            this.setJMSRedelivered(true);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return this.deliveryCount;
    }

    /*
     * Loose catch block
     */
    public static void printDatabaseDebugInfo() {
        block29: {
            SQLException sqle2222;
            ResultSet rs;
            Statement stmt;
            Connection conn;
            block25: {
                conn = null;
                stmt = null;
                rs = null;
                conn = DBManager.getInstance().getDBConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery(DEBUG_STMT);
                while (rs.next()) {
                    String str = "\tdestination: " + rs.getString(DB_DESTNAME_FIELD) + "\tmsg_id: " + rs.getString(DB_MSGID_FIELD);
                    String txid = rs.getString(DB_MSGTXID_FIELD);
                    if (txid != null) {
                        str = str + "\ttxid=" + txid;
                    }
                    MessageImpl msg = (MessageImpl)rs.getObject(DB_MSGOBJ_FIELD);
                    String msgInfo = null;
                    try {
                        msgInfo = msg.getStringProperty("COM_SUN_JMS_TESTNAME");
                    }
                    catch (Throwable t2) {
                        // empty catch block
                    }
                    if (msgInfo != null) {
                        str = str + "\tinfo=" + msgInfo;
                    }
                    logger.debugInfo(str);
                }
                Object var9_9 = null;
                if (rs == null) break block25;
                try {
                    rs.close();
                }
                catch (SQLException sqle2222) {
                    // empty catch block
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sqle2222) {
                    // empty catch block
                }
            }
            if (conn != null) {
                DBManager.getInstance().closeDBConnection(conn);
            }
            break block29;
            {
                catch (SQLException sqle) {
                    SQLException sqle2222;
                    logger.warning(sqle);
                    Object var9_10 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sqle2222) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sqle2222) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        DBManager.getInstance().closeDBConnection(conn);
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException sqle2222;
                Object var9_11 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sqle2222) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqle2222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    DBManager.getInstance().closeDBConnection(conn);
                }
                throw throwable;
            }
        }
    }

    public int getCloseMessageForServerSession() {
        return this.closeMessageForServerSession;
    }

    public void setCloseMessageForServerSession(int value) {
        this.closeMessageForServerSession = value;
    }

    public boolean hasQueueDestination() {
        return this.headerProps[0] != null && ((DestinationImpl)this.headerProps[0]).isQueue();
    }

    public boolean hasTopicDestination() {
        return this.headerProps[0] != null && ((DestinationImpl)this.headerProps[0]).isTopic();
    }

    public boolean isBodyModifiable() {
        return this.bodyModifiable;
    }

    protected void setModifiedAfterDeliveryTrue() {
        this.modifiedAfterDelivery = true;
    }

    public boolean modifiedAfterDelivery() {
        return this.modifiedAfterDelivery;
    }

    public void setBodyModifiable(boolean isModifiable) {
        this.bodyModifiable = isModifiable;
    }

    public boolean hasBeenDelivered() {
        return this.hasBeenDelivered;
    }

    public void setDeliveredTrue() {
        this.hasBeenDelivered = true;
    }

    private void cacheProperties() {
        if (this.hasBeenDelivered() && !this.arePropertiesModifiable()) {
            this.deliveredApplicationProps = this.applicationProps;
            this.setModifiedAfterDeliveryTrue();
        }
    }

    private void cacheHeaderProps() {
        if (this.hasBeenDelivered() && this.deliveredHeaderProps == null) {
            this.deliveredHeaderProps = (Object[])this.headerProps.clone();
            this.setModifiedAfterDeliveryTrue();
        }
    }

    public static class PriorityComparator
    implements Comparator {
        private static PriorityComparator comparator = null;

        public static Comparator getInstance() {
            if (comparator == null) {
                comparator = new PriorityComparator();
            }
            return comparator;
        }

        public int compare(Object obj1, Object obj2) throws ClassCastException {
            try {
                if (((MessageImpl)obj1).getJMSPriority() == ((MessageImpl)obj2).getJMSPriority()) {
                    return ((MessageImpl)obj2).getInternalMessageID() - ((MessageImpl)obj1).getInternalMessageID();
                }
                return ((MessageImpl)obj1).getJMSPriority() - ((MessageImpl)obj2).getJMSPriority();
            }
            catch (JMSException e10) {
                throw new ClassCastException(resource.getString("messageimpl.priority_or_internal_id_not_set"));
            }
        }
    }

    public static class MessageIDComparator
    implements Comparator {
        private static MessageIDComparator comparator = null;

        public static Comparator getInstance() {
            if (comparator == null) {
                comparator = new MessageIDComparator();
            }
            return comparator;
        }

        public int compare(Object obj1, Object obj2) {
            return ((MessageImpl)obj1).getInternalMessageID() - ((MessageImpl)obj2).getInternalMessageID();
        }
    }
}

