/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms;

import com.sun.jms.MessageImpl;
import com.sun.jms.util.JmsResourceBundle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

public class BytesMessageImpl
extends MessageImpl
implements BytesMessage,
Serializable {
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("buf", array$B == null ? (array$B = BytesMessageImpl.class$("[B")) : array$B)};
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.LocalStrings");
    transient ByteArrayInputStream bais;
    transient DataInputStream dis;
    byte[] buf;
    transient byte[] deliveredBuf;
    transient ByteArrayOutputStream baos;
    transient DataOutputStream dos;
    static /* synthetic */ Class array$B;

    public BytesMessageImpl() {
        this.init();
    }

    private void init() {
        this.buf = new byte[0];
        this.baos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.baos);
        this.dis = null;
        this.bais = null;
    }

    private DataInputStream getDis() {
        if (this.dis == null) {
            this.bais = new ByteArrayInputStream(this.buf);
            this.dis = new DataInputStream(this.bais);
        }
        return this.dis;
    }

    public BytesMessageImpl(BytesMessage msg) throws JMSException {
        super(msg);
        int numBytesRead;
        this.init();
        msg.reset();
        int bufSize = 128;
        byte[] bytes = new byte[128];
        do {
            numBytesRead = msg.readBytes(bytes, 128);
            this.writeBytes(bytes, 0, numBytesRead);
        } while (numBytesRead >= 128);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.isBodyModifiable()) {
            if (this.dos != null) {
                this.dos.flush();
            }
            if (this.baos != null) {
                this.buf = this.baos.toByteArray();
            }
        }
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.setBodyModifiable(false);
        if (this.buf == null) {
            this.buf = new byte[0];
        }
        this.bais = null;
        this.dis = null;
    }

    public Object clone() {
        BytesMessageImpl msg = (BytesMessageImpl)super.clone();
        if (this.isBodyModifiable()) {
            byte[] cloneBuf = this.baos.toByteArray();
            this.buf = new byte[cloneBuf.length];
            msg.baos = new ByteArrayOutputStream();
            msg.dos = new DataOutputStream(msg.baos);
            if (this.baos != null) {
                try {
                    msg.dos.write(cloneBuf);
                }
                catch (IOException iOException) {}
            }
        } else {
            msg.bais = null;
            msg.dis = null;
        }
        return msg;
    }

    public MessageImpl getDeliveredMessage() {
        try {
            this.reset();
        }
        catch (JMSException e10) {
            MessageImpl.logger.warning(e10);
        }
        if (this.modifiedAfterDelivery()) {
            BytesMessageImpl bm2 = (BytesMessageImpl)super.getDeliveredMessage();
            bm2.buf = this.deliveredBuf;
            return bm2;
        }
        return this;
    }

    public void clearBody() throws JMSException {
        if (this.hasBeenDelivered() && !this.isBodyModifiable()) {
            this.deliveredBuf = this.buf;
        }
        super.clearBody();
        this.init();
    }

    public String toString() {
        return super.toString() + ": contains a ... ";
    }

    public boolean readBoolean() throws JMSException {
        boolean ret = false;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        try {
            ret = this.getDis().readBoolean();
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("bytesmessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public byte readByte() throws JMSException {
        byte ret = 0;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        try {
            ret = this.getDis().readByte();
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("bytesmessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public int readUnsignedByte() throws JMSException {
        int ret = 0;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        try {
            ret = this.getDis().readUnsignedByte();
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("bytesmessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public short readShort() throws JMSException {
        short ret = 0;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        try {
            ret = this.getDis().readShort();
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("bytesmessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public int readUnsignedShort() throws JMSException {
        int ret = 0;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        try {
            ret = this.getDis().readUnsignedShort();
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("bytesmessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public char readChar() throws JMSException {
        char ret = '\u0000';
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        try {
            ret = this.getDis().readChar();
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("bytesmessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public int readInt() throws JMSException {
        int ret = 0;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        try {
            ret = this.getDis().readInt();
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("bytesmessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public long readLong() throws JMSException {
        long ret = 0L;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        try {
            ret = this.getDis().readLong();
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("bytesmessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public float readFloat() throws JMSException {
        float ret = 0.0f;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        try {
            ret = this.getDis().readFloat();
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("bytesmessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public double readDouble() throws JMSException {
        double ret = 0.0;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        try {
            ret = this.getDis().readDouble();
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("bytesmessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public String readUTF() throws JMSException {
        String ret = null;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        try {
            ret = this.getDis().readUTF();
        }
        catch (EOFException e12) {
            throw new MessageEOFException(resource.getString("bytesmessageimpl.end_of_message"));
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public int readBytes(byte[] value) throws JMSException {
        int ret = -1;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        try {
            ret = this.getDis().read(value);
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        int ret = -1;
        if (this.isBodyModifiable()) {
            throw new MessageNotReadableException(resource.getString("messageimpl.write_only"));
        }
        if (length < 0 || length > value.length) {
            throw new IndexOutOfBoundsException();
        }
        try {
            ret = this.getDis().read(value, 0, length);
        }
        catch (IOException e22) {
            JMSException jmsEx = new JMSException(e22.getMessage());
            jmsEx.setLinkedException(e22);
            throw jmsEx;
        }
        return ret;
    }

    public void writeBoolean(boolean writeBoolean) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.writeBoolean(writeBoolean);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeByte(byte value) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.writeByte(value);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeShort(short value) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.writeShort(value);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeChar(char value) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.writeChar(value);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeInt(int value) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.writeInt(value);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeLong(long value) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.writeLong(value);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeFloat(float value) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.writeFloat(value);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeDouble(double value) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.writeDouble(value);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeUTF(String value) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.writeUTF(value);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.write(value);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (!this.isBodyModifiable()) {
            throw new MessageNotWriteableException(resource.getString("messageimpl.read_only"));
        }
        try {
            this.dos.write(value, offset, length);
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof String) {
            this.writeUTF((String)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new MessageFormatException(resource.getString("bytesmessageimpl.invalid_type"));
        }
    }

    public void reset() throws JMSException {
        try {
            if (this.dos != null) {
                this.dos.flush();
            }
        }
        catch (IOException e10) {
            JMSException jmsEx = new JMSException(e10.getMessage());
            jmsEx.setLinkedException(e10);
            throw jmsEx;
        }
        if (this.baos != null) {
            this.buf = this.baos.toByteArray();
            this.baos.reset();
        } else if (this.buf == null) {
            this.buf = new byte[0];
        }
        if (this.dis != null) {
            try {
                this.dis.reset();
            }
            catch (IOException e11) {
                JMSException jmsEx = new JMSException(e11.getMessage());
                jmsEx.setLinkedException(e11);
                throw jmsEx;
            }
        }
        this.setBodyModifiable(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

