/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.ORBManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.CORBA.Tie;
import javax.rmi.PortableRemoteObject;

public final class Utility {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$util$Utility == null ? (class$com$sun$enterprise$util$Utility = Utility.class$("com.sun.enterprise.util.Utility")) : class$com$sun$enterprise$util$Utility);
    private static String CONFIG_DIR = "config";
    static /* synthetic */ Class class$com$sun$enterprise$util$Utility;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$String;

    public static void checkJVMVersion() {
        Properties props = System.getProperties();
        String errmsg = "";
        boolean fatal = false;
        String javaVersion = props.getProperty("java.version");
        if (!javaVersion.startsWith("1.3")) {
            if (javaVersion.startsWith("1.4")) {
                errmsg = errmsg + "Warning: This J2EE SDK release has only been tested on J2SE v1.3\n";
            } else {
                errmsg = errmsg + "Fatal Error: This J2EE SDK release runs only on Java 2 (JDK1.3 or later)\n";
                fatal = true;
            }
        }
        System.err.println(errmsg);
        if (fatal) {
            System.exit(1);
        }
    }

    public static Properties getPropertiesFromFile(String file) throws IOException {
        File j2eedConfigFile = new File(FileUtil.getAbsolutePath(CONFIG_DIR + File.separator + file));
        FileInputStream fis = new FileInputStream(j2eedConfigFile);
        Properties config = new Properties();
        config.load(fis);
        fis.close();
        return config;
    }

    public static String getLocalHost() {
        String hostname = null;
        try {
            InetAddress ia = InetAddress.getLocalHost();
            hostname = ia.getHostName();
        }
        catch (UnknownHostException e10) {
            return "localhost";
        }
        return hostname;
    }

    public static String getLocalAddress() {
        String address = null;
        try {
            InetAddress ia = InetAddress.getLocalHost();
            address = ia.getHostAddress();
        }
        catch (UnknownHostException e10) {
            return "127.0.0.1";
        }
        return address;
    }

    public static void bindObject(String publishedName, Remote remote) throws RemoteException, NamingException {
        Tie servantsTie = ORBManager.exportObject(remote);
        NamingManager namingManager = Switch.getSwitch().getNamingManager();
        namingManager.publishObject(publishedName, (Object)servantsTie, true);
    }

    public static Remote lookupObject(String publishedName, Class anInterface) throws NamingException {
        InitialContext ic = new InitialContext();
        Object objRef = ic.lookup(publishedName);
        return (Remote)PortableRemoteObject.narrow((Object)objRef, (Class)anInterface);
    }

    public static int bytesToInt(byte[] array, int offset) {
        int b12 = array[offset++] << 24 & 0xFF000000;
        int b22 = array[offset++] << 16 & 0xFF0000;
        int b32 = array[offset++] << 8 & 0xFF00;
        int b42 = array[offset++] << 0 & 0xFF;
        return b12 | b22 | b32 | b42;
    }

    public static void intToBytes(int value, byte[] array, int offset) {
        array[offset++] = (byte)(value >>> 24 & 0xFF);
        array[offset++] = (byte)(value >>> 16 & 0xFF);
        array[offset++] = (byte)(value >>> 8 & 0xFF);
        array[offset++] = (byte)(value >>> 0 & 0xFF);
    }

    public static long bytesToLong(byte[] array, int offset) {
        long l1 = (long)Utility.bytesToInt(array, offset) << 32;
        long l2 = (long)Utility.bytesToInt(array, offset + 4) & 0xFFFFFFFFL;
        return l1 | l2;
    }

    public static void longToBytes(long value, byte[] array, int offset) {
        array[offset++] = (byte)(value >>> 56 & 0xFFL);
        array[offset++] = (byte)(value >>> 48 & 0xFFL);
        array[offset++] = (byte)(value >>> 40 & 0xFFL);
        array[offset++] = (byte)(value >>> 32 & 0xFFL);
        array[offset++] = (byte)(value >>> 24 & 0xFFL);
        array[offset++] = (byte)(value >>> 16 & 0xFFL);
        array[offset++] = (byte)(value >>> 8 & 0xFFL);
        array[offset++] = (byte)(value >>> 0 & 0xFFL);
    }

    public static void invokeApplicationMain(Class mainClass, String[] args) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        String err = localStrings.getLocalString("utility.no.main", "", new Object[]{mainClass});
        Method mainMethod = null;
        try {
            mainMethod = mainClass.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Utility.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        }
        catch (NoSuchMethodException msme) {
            System.err.println(err);
            throw new ClassNotFoundException(err);
        }
        int modifiers = mainMethod.getModifiers();
        if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) {
            err = localStrings.getLocalString("utility.main.notpublicorstatic", "The main method is either not public or not static");
            System.err.println(err);
            throw new ClassNotFoundException(err);
        }
        if (!mainMethod.getReturnType().equals(Void.TYPE)) {
            err = localStrings.getLocalString("utility.main.notvoid", "The main method's return type is not void ");
            System.err.println(err);
            throw new ClassNotFoundException(err);
        }
        Object[] params = new Object[]{args};
        mainMethod.invoke(null, params);
    }

    public static void invokeSetMethod(Object obj, String prop, String value) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> cl2 = obj.getClass();
        String setMeth = "set" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
        try {
            Class[] cldef = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Utility.class$("java.lang.String")) : class$java$lang$String};
            Method meth = cl2.getMethod(setMeth, cldef);
            Object[] params = new Object[]{value};
            meth.invoke(obj, params);
            return;
        }
        catch (NoSuchMethodException ex2) {
            try {
                Class[] cldef = new Class[]{Integer.TYPE};
                Method meth = cl2.getMethod(setMeth, cldef);
                Object[] params = new Object[]{Integer.valueOf(value)};
                meth.invoke(obj, params);
                return;
            }
            catch (NoSuchMethodException nsmex) {
                Class[] cldef = new Class[]{Boolean.TYPE};
                Method meth = cl2.getMethod(setMeth, cldef);
                Object[] params = new Object[]{Boolean.valueOf(value)};
                meth.invoke(obj, params);
                return;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

