/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.EjbExternalDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JmsDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.xml.ApplicationClientNode;
import com.sun.enterprise.deployment.xml.ApplicationClientRuntimeDescriptorNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NiceProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.crimson.tree.XmlDocument;

public class ApplicationClientPropertiesFileConverter {
    private static String APPLICATION_CLIENT = "appclient";
    private static String NAME = ".name";
    private static String DESCRIPTION = ".description";
    private static String CALLBACK_HANDLER = ".callbackHandler";
    private static String SMALL_ICON = ".smallIcon";
    private static String LARGE_ICON = ".largeIcon";
    private static String ENVIRONMENT_PROPERTIES = ".#environmentProperties";
    private static String ENVIRONMENT_PROPERTY = "environmentProperty";
    private static String VALUE = ".value";
    private static String TYPE = ".type";
    private static String IS_EJB_REFERENCE = ".isEjbReference";
    private static String EJB_NAME = ".ejbName";
    private static String EJB_LINK = ".ejbLink";
    private static String IS_EJB_LINK = ".isEjbLink";
    private static String EJB_HOME = ".homeInterface";
    private static String EJB_REMOTE = ".remoteInterface";
    private static String IS_RESOURCE_REFERENCE = ".isResourceReference";
    private static String IS_JMS_DESTINATION_REF = ".isJmsDestinationReference";
    private static String IS_RESOURCE_ENV_REF = ".isResourceEnvReference";
    private static String AUTHORIZATION = ".authorization";
    private static String DEFAULT_DB_ACCOUNT = ".defaultDBAccount";
    private static String MAIL_CONFIGURATION = ".mailConfiguration";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$util$ApplicationClientPropertiesFileConverter == null ? (class$com$sun$enterprise$util$ApplicationClientPropertiesFileConverter = ApplicationClientPropertiesFileConverter.class$("com.sun.enterprise.util.ApplicationClientPropertiesFileConverter")) : class$com$sun$enterprise$util$ApplicationClientPropertiesFileConverter);
    static /* synthetic */ Class class$com$sun$enterprise$util$ApplicationClientPropertiesFileConverter;

    public void convert(Properties p2, File xmlFile, File runtimeXmlFile) throws IOException {
        ApplicationClientDescriptor descriptor = new ApplicationClientDescriptor();
        XmlDocument document = null;
        FileWriter out = null;
        descriptor.setName(p2.getProperty(APPLICATION_CLIENT + NAME));
        descriptor.setDescription(p2.getProperty(APPLICATION_CLIENT + DESCRIPTION));
        descriptor.setCallbackHandler(p2.getProperty(APPLICATION_CLIENT + CALLBACK_HANDLER));
        int epCount = Integer.parseInt(p2.getProperty(APPLICATION_CLIENT + ENVIRONMENT_PROPERTIES));
        int i2 = 0;
        while (i2 < epCount) {
            String epName = p2.getProperty(ENVIRONMENT_PROPERTY + i2 + NAME);
            String epValue = p2.getProperty(ENVIRONMENT_PROPERTY + i2 + VALUE);
            if ("true".equals(p2.getProperty(ENVIRONMENT_PROPERTY + i2 + IS_RESOURCE_REFERENCE))) {
                ResourceReferenceDescriptor rr = new ResourceReferenceDescriptor(epName, "", p2.getProperty(ENVIRONMENT_PROPERTY + i2 + TYPE));
                rr.setJndiName(epValue);
                String authorizartion = p2.getProperty(ENVIRONMENT_PROPERTY + i2 + AUTHORIZATION);
                rr.setAuthorization(authorizartion);
                if (ResourceReferenceDescriptor.CONTAINER_AUTHORIZATION.equals(authorizartion)) {
                    StringTokenizer st;
                    if (p2.getProperty(ENVIRONMENT_PROPERTY + i2 + DEFAULT_DB_ACCOUNT) != null) {
                        st = new StringTokenizer(p2.getProperty(ENVIRONMENT_PROPERTY + i2 + DEFAULT_DB_ACCOUNT), ",");
                        ResourcePrincipal rp = new ResourcePrincipal(st.nextToken(), st.nextToken());
                        rr.setResourcePrincipal(rp);
                    }
                    if (p2.getProperty(ENVIRONMENT_PROPERTY + i2 + MAIL_CONFIGURATION) != null) {
                        st = new StringTokenizer(p2.getProperty(ENVIRONMENT_PROPERTY + i2 + MAIL_CONFIGURATION), ",");
                        MailConfiguration mc = new MailConfiguration(st.nextToken(), st.nextToken(), st.nextToken());
                        rr.setMailConfiguration(mc);
                    }
                }
                descriptor.addResourceReferenceDescriptor(rr);
            } else if ("true".equals(p2.getProperty(ENVIRONMENT_PROPERTY + i2 + IS_EJB_REFERENCE))) {
                EjbExternalDescriptor ejb = new EjbExternalDescriptor();
                ejb.setName(p2.getProperty(ENVIRONMENT_PROPERTY + i2 + EJB_NAME));
                ejb.setHomeClassName(p2.getProperty(ENVIRONMENT_PROPERTY + i2 + EJB_HOME));
                ejb.setRemoteClassName(p2.getProperty(ENVIRONMENT_PROPERTY + i2 + EJB_REMOTE));
                ejb.setType(p2.getProperty(ENVIRONMENT_PROPERTY + i2 + TYPE));
                if ("true".equals(p2.getProperty(ENVIRONMENT_PROPERTY + i2 + IS_EJB_LINK))) {
                    System.out.println("Adding internal UNRESOLVED reference ");
                    ejb.setLinkName(p2.getProperty(ENVIRONMENT_PROPERTY + i2 + EJB_LINK));
                }
                EjbReferenceDescriptor erd = new EjbReferenceDescriptor(epName, "", ejb);
                erd.setJndiName(epValue);
                System.out.println("adding ejb reference descriptor " + erd);
                descriptor.addEjbReferenceDescriptor(erd);
            } else if ("true".equals(p2.getProperty(ENVIRONMENT_PROPERTY + i2 + IS_JMS_DESTINATION_REF)) || "true".equals(p2.getProperty(ENVIRONMENT_PROPERTY + i2 + IS_RESOURCE_ENV_REF))) {
                if ("true".equals(p2.getProperty(ENVIRONMENT_PROPERTY + i2 + IS_JMS_DESTINATION_REF))) {
                    System.out.print("Warning : isJmsDestinationReference has been deprecated. ");
                    System.out.println("Please use isResourceEnvReference instead.");
                }
                JmsDestinationReferenceDescriptor jmsDestRefDesc = new JmsDestinationReferenceDescriptor(epName, "", p2.getProperty(ENVIRONMENT_PROPERTY + i2 + TYPE));
                jmsDestRefDesc.setJndiName(epValue);
                descriptor.addJmsDestinationReferenceDescriptor(jmsDestRefDesc);
            } else {
                EnvironmentProperty ep2 = new EnvironmentProperty(epName, epValue, "", p2.getProperty(ENVIRONMENT_PROPERTY + i2 + TYPE));
                descriptor.addEnvironmentProperty(ep2);
            }
            ++i2;
        }
        document = ApplicationClientNode.getDocument(descriptor);
        out = new FileWriter(xmlFile);
        XMLUtils.writeDocument(document, out);
        document = ApplicationClientRuntimeDescriptorNode.getDocument(descriptor);
        out = new FileWriter(runtimeXmlFile);
        XMLUtils.writeDocument(document, out);
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println(localStrings.getLocalString("appclient.prop.converter.usage", ""));
            System.exit(1);
        }
        File propertiesFile = new File(args[0]);
        File xmlFile = new File(args[1]);
        File runtimeXmlFile = new File(args[2]);
        try {
            FileInputStream is = new FileInputStream(propertiesFile);
            NiceProperties acProperties = new NiceProperties();
            acProperties.load(is);
            ApplicationClientPropertiesFileConverter converter = new ApplicationClientPropertiesFileConverter();
            converter.convert(acProperties, xmlFile, runtimeXmlFile);
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

