/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Enumeration;

public class WebResourceType
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor.getResourceReferences().hasMoreElements()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            Enumeration e10 = descriptor.getResourceReferences();
            while (e10.hasMoreElements()) {
                foundIt = false;
                ResourceReferenceDescriptor next = (ResourceReferenceDescriptor)e10.nextElement();
                String resType = next.getType();
                Verifier.debug("servlet resType: " + resType);
                foundIt = resType.equals("javax.sql.DataSource") || resType.equals("javax.jms.QueueConnectionFactory") || resType.equals("javax.jms.TopicConnectionFactory") || resType.equals("javax.mail.Session") || resType.equals("java.net.URL");
                if (foundIt) {
                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "The resource-type [ {0} ] element specifies the Java class type of the data source within web application [ {1} ]", new Object[]{resType, descriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: The resource-type [ {0} ] element does not specify valid Java class type of the data source within web application [ {1} ]", new Object[]{resType, descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no resource-type elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

