/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.ServletDescriptorImpl;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public abstract class ServletIcon
extends WebTest {
    public boolean check(WebBundleDescriptor descriptor, String uriName, Result result, ServletDescriptorImpl servlet) {
        boolean failed = false;
        boolean foundIt = false;
        String servletName = servlet.getClassName();
        if (uriName.length() != 0) {
            try {
                JarFile jar = new JarFile(Verifier.getArchiveFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()));
                ZipEntry ze = jar.getEntry(uriName);
                foundIt = ze != null;
                jar.close();
            }
            catch (FileNotFoundException fnfoundEx) {
                failed = true;
                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".FileNotFoundException", "Error: FileNotFoundException while reading the jar file."));
            }
            catch (IOException ioEx) {
                failed = true;
                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".IOException", "Error: IOException while reading the jar file."));
            }
            if (foundIt) {
                result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Icon file found in the servlet [ {0} ].", new Object[]{servletName}));
            } else {
                failed = true;
                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: Icon file does not exist for the servlet [ {0} ].", new Object[]{servletName}));
            }
        } else {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no icon elements in the servlet [ {0} ]", new Object[]{servletName}));
        }
        return failed;
    }
}

