/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.ServletDescriptorImpl;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;

public class LibDirExists
extends WebTest
implements WebCheck {
    final String servletLibDirPath = "WEB-INF/lib";

    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (!descriptor.getServletDescriptors().isEmpty()) {
            boolean oneFailed = false;
            int na = 0;
            boolean foundIt = false;
            Set servlets = descriptor.getServletDescriptors();
            Iterator itr = servlets.iterator();
            while (itr.hasNext()) {
                foundIt = false;
                ServletDescriptorImpl servlet = (ServletDescriptorImpl)itr.next();
                try {
                    File warfile = new File(System.getProperty("java.io.tmpdir"));
                    warfile = new File(warfile, "wartmp");
                    Archivist.extractJarFile(Verifier.getArchiveFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()), warfile);
                    File warLibDir = new File(warfile, "WEB-INF/lib");
                    if (warLibDir.isDirectory()) {
                        foundIt = true;
                    }
                }
                catch (IOException e10) {
                    if (!oneFailed) {
                        oneFailed = true;
                    }
                    Verifier.debug(e10);
                    result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".IOException", "Error: IOError trying to open [ {0} ], {1}", new Object[]{Verifier.getArchiveFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()), e10.getMessage()}));
                }
                if (foundIt) {
                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Servlet lib dir [ {0} ] resides in WEB-INF/lib directory of [ {1} ].", new Object[]{"WEB-INF/lib", Verifier.getArchiveFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName())}));
                    continue;
                }
                ++na;
                result.addNaDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Servlet lib dir [ {0} ] does not reside in [ {1} ].", new Object[]{"WEB-INF/lib", Verifier.getArchiveFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName())}));
            }
            File wartmp = new File(System.getProperty("java.io.tmpdir"));
            wartmp = new File(wartmp, "wartmp");
            wartmp.delete();
            if (na == descriptor.getServletDescriptors().size()) {
                result.setStatus(3);
            } else if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no servlet components within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

