/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.JspDescriptorImpl;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JspFile
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (!descriptor.getJspDescriptors().isEmpty()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            Set jsps = descriptor.getJspDescriptors();
            Iterator itr = jsps.iterator();
            while (itr.hasNext()) {
                String jspFilename;
                block10: {
                    foundIt = false;
                    JspDescriptorImpl jsp = (JspDescriptorImpl)itr.next();
                    jspFilename = jsp.getJspFileName();
                    try {
                        ZipEntry ze;
                        JarFile jar = new JarFile(Verifier.getArchiveFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()));
                        if (jspFilename.startsWith("/")) {
                            jspFilename = jspFilename.substring(1);
                        }
                        foundIt = (ze = jar.getEntry(jspFilename)) != null;
                        jar.close();
                    }
                    catch (Exception e10) {
                        if (oneFailed) break block10;
                        oneFailed = true;
                    }
                }
                if (foundIt) {
                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Jsp file [ {0} ] contains the full path to Jsp file within web application [ {1} ]", new Object[]{jspFilename, descriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: Jsp file [ {0} ] is not found within [ {1} ] or does not contain the full path to Jsp file within web application [ {2} ]", new Object[]{jspFilename, Verifier.getArchiveFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()), descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no Jsp components within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

