/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class FormLoginPage
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor.getLoginConfiguration() != null) {
            boolean foundIt = false;
            String formLoginPage = descriptor.getLoginConfiguration().getFormLoginPage();
            if (formLoginPage.length() > 0) {
                try {
                    ZipEntry ze;
                    JarFile jar = new JarFile(Verifier.getArchiveFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()));
                    if (formLoginPage.startsWith("/")) {
                        formLoginPage = formLoginPage.substring(1);
                    }
                    foundIt = (ze = jar.getEntry(formLoginPage)) != null;
                    jar.close();
                }
                catch (Exception ex2) {
                    foundIt = false;
                }
                if (foundIt) {
                    result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "The form-login-page [ {0} ] value does define the location in the web application [ {1} ] where the page can be used for login page can be found.", new Object[]{formLoginPage, descriptor.getName()}));
                } else {
                    result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: The form-login-page [ {0} ] value does not define the location in the web application [ {1} ] where the page to be used for the login page can be found.", new Object[]{formLoginPage, descriptor.getName()}));
                }
            } else {
                result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no form-login-page name elements within this web archive [ {0} ]", new Object[]{descriptor.getName()}));
            }
        } else {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no form-login-page name elements within this web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

