/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.ServletFilterDescriptor;
import com.sun.enterprise.deployment.ServletFilterMappingDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.ServletDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;

public class FilterMapping
extends WebTest {
    public Result check(WebBundleDescriptor descriptor) {
        Result result;
        Enumeration filterEnum = descriptor.getServletFilterDescriptors().elements();
        if (filterEnum.hasMoreElements()) {
            boolean oneFailed = false;
            result = this.loadWarFile(descriptor);
            while (filterEnum.hasMoreElements()) {
                ServletFilterDescriptor filter = (ServletFilterDescriptor)filterEnum.nextElement();
                if (this.hasValidMapping(descriptor, filter.getName())) continue;
                result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Filter Mapping for [ {0} ] is incorect", new Object[]{filter.getName()}));
                oneFailed = true;
            }
            if (!oneFailed) {
                result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "All filter mappings are correct"));
            }
        } else {
            result = this.getInitializedResult();
            result.setStatus(3);
            result.notApplicable(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.web.FilterClass.notApplicable", "There are no filter components within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }

    private boolean hasValidMapping(WebBundleDescriptor descriptor, String filterName) {
        boolean valid;
        block4: {
            String targetType;
            String target;
            block5: {
                String filterMapping;
                valid = false;
                if (filterName == null) {
                    return false;
                }
                Enumeration filtermapperEnum = descriptor.getServletFilterMappingDescriptors().elements();
                if (!filtermapperEnum.hasMoreElements()) break block4;
                ServletFilterMappingDescriptor filterMapper = null;
                boolean mappingFound = false;
                while (!(mappingFound = filterName.equals(filterMapping = (filterMapper = (ServletFilterMappingDescriptor)filtermapperEnum.nextElement()).getName())) && filtermapperEnum.hasMoreElements()) {
                }
                if (!mappingFound) break block4;
                target = filterMapper.getTarget();
                targetType = filterMapper.getTargetType();
                if (!targetType.equals("URLPattern")) break block5;
                if (target == null || !target.startsWith("/") && (!target.startsWith("/") || !target.endsWith("/*")) && !target.startsWith("*.")) break block4;
                valid = true;
                break block4;
            }
            if (targetType.equals("Servlet")) {
                Set servlets = descriptor.getServletDescriptors();
                Iterator itr = servlets.iterator();
                while (itr.hasNext()) {
                    ServletDescriptor servlet = (ServletDescriptor)itr.next();
                    String servletName = servlet.getName();
                    if (!target.equals(servletName)) continue;
                    valid = true;
                    break;
                }
            }
        }
        return valid;
    }
}

