/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public abstract class ApplicationIcon
extends WebTest {
    public boolean check(WebBundleDescriptor descriptor, String uriName, Result result) {
        boolean foundIt = false;
        String webappName = descriptor.getName();
        try {
            JarFile jar = new JarFile(Verifier.getArchiveFile(((WebBundleArchivist)descriptor.getArchivist()).getWebJarFile().getName()));
            ZipEntry ze = jar.getEntry(uriName);
            foundIt = ze != null;
            jar.close();
        }
        catch (FileNotFoundException fnfoundEx) {
            result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".FileNotFoundException", "Error: FileNotFoundException while creating the jar file."));
        }
        catch (IOException ioEx) {
            result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".IOException", "Error: IOException while creating the jar file."));
        }
        if (foundIt) {
            result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Icon image file found in the web application [ {0} ].", new Object[]{webappName}));
        } else {
            result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: Icon file does not exist for the web application [ {0} ].", new Object[]{webappName}));
        }
        return foundIt;
    }
}

