/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;

public class HomeInterfaceNoFinderMethodNames
extends EjbTest
implements EjbCheck {
    Result result = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        if (descriptor instanceof EjbSessionDescriptor) {
            boolean foundAtLeastOne = false;
            if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                foundAtLeastOne = this.commonToBothInterfaces(descriptor.getHomeClassName(), (EjbSessionDescriptor)descriptor);
                if (!foundAtLeastOne) {
                    this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug3", "For Home Interface [ {0} ]", new Object[]{descriptor.getHomeClassName()}));
                    this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Valid: no finder methods were found.  Session bean's home interface is not allowed to have any finder methods."));
                    this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                    this.result.setStatus(0);
                } else {
                    this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug3", "For Home Interface [ {0} ] finder method was found. Session bean's home interface is not allowed to have any finder methods.", new Object[]{descriptor.getHomeClassName()}));
                    this.result.setStatus(1);
                }
            }
            if (!foundAtLeastOne && descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                foundAtLeastOne = this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), (EjbSessionDescriptor)descriptor);
                if (!foundAtLeastOne) {
                    this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug3", "For Home Interface [ {0} ]", new Object[]{descriptor.getLocalHomeClassName()}));
                    this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Valid: no finder methods were found.  Session bean's home interface is not allowed to have any finder methods."));
                    this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                    this.result.setStatus(0);
                } else {
                    this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug3", "For Home Interface [ {0} ] finder method was found. Session bean's home interface is not allowed to have any finder methods.", new Object[]{descriptor.getLocalHomeClassName()}));
                    this.result.setStatus(1);
                }
            }
            return this.result;
        }
        this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String home, EjbSessionDescriptor descriptor) {
        boolean foundAtLeastOne = false;
        try {
            Context context = this.getVerifierContext();
            JarClassLoader jcl = context.getClassLoader();
            Class<?> c10 = jcl.loadClass(home);
            Method[] methods = c10.getDeclaredMethods();
            int i2 = 0;
            while (i2 < methods.length) {
                if (methods[i2].getName().startsWith("find")) {
                    if (!foundAtLeastOne) {
                        foundAtLeastOne = true;
                    }
                    this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                    this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Improperly named method [ {0} ] was found. Session bean's home interface is not allowed to have any finder methods.", new Object[]{methods[i2].getName()}));
                    this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                }
                ++i2;
            }
            return foundAtLeastOne;
        }
        catch (ClassNotFoundException e10) {
            Verifier.debug(e10);
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{home, descriptor.getName()}));
            return foundAtLeastOne;
        }
    }
}

