/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.ejbql;

import com.sun.ejb.ejbql.EjbQLDriver;
import com.sun.ejb.ejbql.EjbQLParseException;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.util.Iterator;

public class EjbQLChecker {
    protected static final LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public static boolean checkSyntax(PersistenceDescriptor desc, EjbQLDriver ejbqlDriver, Result result, String ownerClassName) {
        boolean hasError = false;
        String query = null;
        Iterator it = desc.getQueriedMethods().iterator();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            try {
                QueryDescriptor qDesc = desc.getQueryFor(method);
                query = qDesc.getQuery();
                if (!qDesc.getIsEjbQl()) continue;
                ejbqlDriver.parse(desc, method, query);
            }
            catch (EjbQLParseException ex2) {
                if (!hasError) {
                    hasError = true;
                }
                result.addErrorDetails(smh.getLocalString(ownerClassName + ".parseError", "Error: [ {0} ] has parsing error(s)", new Object[]{query}));
                result.addErrorDetails(smh.getLocalString(ownerClassName + ".SAXParseException", "Exception occured : [{0}]", new Object[]{ex2.toString()}));
            }
        }
        return hasError;
    }
}

