/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.createmethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;

public class HomeInterfaceCreateMethodExceptionCreate
extends EjbTest
implements EjbCheck {
    boolean foundAtLeastOneCreate = false;
    Result result = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        boolean oneFailed = false;
        if (descriptor instanceof EjbEntityDescriptor) {
            if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor);
            }
            if (!oneFailed && descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), descriptor);
            }
            if (!this.foundAtLeastOneCreate) {
                this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug3", "For Home Interface [ {0} ]", new Object[]{descriptor.getHomeClassName()}));
                this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", "No create method was found, test not applicable."));
                this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                this.result.setStatus(0);
            } else if (oneFailed) {
                this.result.setStatus(1);
            } else {
                this.result.setStatus(0);
            }
            return this.result;
        }
        this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String home, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        try {
            Context context = this.getVerifierContext();
            JarClassLoader jcl = context.getClassLoader();
            Class<?> c10 = jcl.loadClass(home);
            Method[] methods = c10.getDeclaredMethods();
            boolean throwsCreateException = false;
            int i2 = 0;
            while (i2 < methods.length) {
                throwsCreateException = false;
                if (methods[i2].getName().equals("create")) {
                    if (!this.foundAtLeastOneCreate) {
                        this.foundAtLeastOneCreate = true;
                    }
                    Class<?>[] methodExceptionTypes = methods[i2].getExceptionTypes();
                    int kk = 0;
                    while (kk < methodExceptionTypes.length) {
                        if (methodExceptionTypes[kk].getName().equals("javax.ejb.CreateException")) {
                            throwsCreateException = true;
                            break;
                        }
                        ++kk;
                    }
                    if (throwsCreateException) {
                        this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                        this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "The create method which must throw javax.ejb.CreateException was found."));
                        this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                    } else if (!throwsCreateException) {
                        oneFailed = true;
                        this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                        this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: A create method was found, but did not throw javax.ejb.CreateException."));
                        this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                    }
                }
                ++i2;
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e10) {
            Verifier.debug(e10);
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{home, descriptor.getName()}));
            return oneFailed;
        }
    }
}

