/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class EjbPublicID
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        String[] acceptablePubidLiterals = new String[]{"-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN", "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN"};
        File f2 = Verifier.getJarFile(((EjbBundleArchivist)descriptor.getEjbBundleDescriptor().getArchivist()).getEjbJarFile().getName());
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(f2);
            ZipEntry deploymentEntry = jarFile.getEntry(EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY);
            if (deploymentEntry != null) {
                BufferedReader in = new BufferedReader(new InputStreamReader(jarFile.getInputStream(deploymentEntry)));
                String s2 = in.readLine();
                boolean foundDOCTYPE = false;
                boolean foundPubid = false;
                while (s2 != null) {
                    if (s2.indexOf("DOCTYPE") > -1) {
                        foundDOCTYPE = true;
                    }
                    if (foundDOCTYPE) {
                        int i2 = 0;
                        while (i2 < acceptablePubidLiterals.length) {
                            if (s2.indexOf(acceptablePubidLiterals[i2]) > -1) {
                                foundPubid = true;
                                result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "The deployment descriptor has the proper PubidLiteral: {0}", new Object[]{acceptablePubidLiterals[i2]}));
                            }
                            ++i2;
                        }
                    }
                    if (foundPubid || foundDOCTYPE && s2.endsWith(">")) break;
                    s2 = in.readLine();
                }
                if (!foundDOCTYPE) {
                    result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed1", "Error: No document type declaration found in the deployment descriptor for {0}", new Object[]{descriptor.getName()}));
                } else if (!foundPubid) {
                    result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed2", "Error: The deployment descriptor for {0} does not have an expected PubidLiteral ", new Object[]{descriptor.getName()}));
                }
            }
            jarFile.close();
        }
        catch (IOException e10) {
            result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".IOException", "Error: I/O error trying to open {0}", new Object[]{f2.getAbsolutePath()}));
        }
        return result;
    }
}

