/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;

public class ApplicationExceptionComponentInterfaceMethods
extends EjbTest
implements EjbCheck {
    Result result = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        if (!(descriptor instanceof EjbSessionDescriptor) && !(descriptor instanceof EjbEntityDescriptor)) {
            this.result.notApplicable(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.homeintf.HomeMethodTest.notApplicable1", "Test apply only to session or entity beans."));
            return this.result;
        }
        boolean oneFailed = false;
        if (descriptor.getRemoteClassName() != null) {
            oneFailed = this.commonToBothInterfaces(descriptor.getRemoteClassName(), descriptor);
        }
        if (!oneFailed && descriptor.getLocalClassName() != null) {
            oneFailed = this.commonToBothInterfaces(descriptor.getLocalClassName(), descriptor);
        }
        if (oneFailed) {
            this.result.setStatus(1);
        } else {
            this.result.setStatus(0);
        }
        return this.result;
    }

    private boolean commonToBothInterfaces(String remote, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        try {
            Context context = this.getVerifierContext();
            JarClassLoader jcl = context.getClassLoader();
            Class<?> c10 = jcl.loadClass(remote);
            Method[] methods = c10.getDeclaredMethods();
            boolean validApplicationException = false;
            int i2 = 0;
            while (i2 < methods.length) {
                validApplicationException = false;
                Class[] methodExceptionTypes = methods[i2].getExceptionTypes();
                if (EjbUtils.isValidApplicationException(methodExceptionTypes)) {
                    validApplicationException = true;
                }
                if (validApplicationException) {
                    this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For Remote Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                    this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "The method [ {0} ] throws valid application exceptions in Remote interface [ {1} ]", new Object[]{methods[i2].getName(), remote}));
                    this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                } else if (!validApplicationException) {
                    if (!oneFailed) {
                        oneFailed = true;
                    }
                    this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For Remote Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                    this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: method [ {0} ] does not throw valid application exceptions in Remote interface [ {1} ]", new Object[]{methods[i2].getName(), remote}));
                    this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                }
                ++i2;
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e10) {
            Verifier.debug(e10);
            oneFailed = true;
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Remote interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{remote, descriptor.getName()}));
            return oneFailed;
        }
        catch (Throwable t2) {
            Verifier.debug(t2);
            oneFailed = true;
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedThrowable", "Error: [ {0} ] class encountered [ {1} ]. Cannot access methods of class [ {2} ] within [ {3} ].", new Object[]{remote, t2.toString(), t2.getMessage(), Verifier.getJarFile(((EjbBundleArchivist)descriptor.getEjbBundleDescriptor().getArchivist()).getEjbJarFile().getName()).getName()}));
            return oneFailed;
        }
    }
}

