/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector.managed;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import com.sun.enterprise.util.JarClassLoader;

public abstract class ManagedConnectionFactoryTest
extends ConnectorTest {
    protected Class getManagedConnectionFactoryImpl(ConnectorDescriptor descriptor) throws ClassNotFoundException {
        String className = descriptor.getManagedConnectionFactoryImpl();
        if (className == null) {
            return null;
        }
        Context context = this.getVerifierContext();
        JarClassLoader jcl = context.getClassLoader();
        return jcl.loadClass(className);
    }

    protected Class testManagedConnectionFactoryImpl(ConnectorDescriptor descriptor, Result result) {
        Class mcf = null;
        try {
            mcf = this.getManagedConnectionFactoryImpl(descriptor);
            if (mcf == null) {
                result.failed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.managed.ManagedConnectionFactoryTest.nonimpl", "Error: The resource adapter must implement the javax.resource.spi.ManagedConnectionFactory interface and declare it in the managedconnecttionfactory-class deployment descriptor."));
            }
        }
        catch (ClassNotFoundException cnfe) {
            result.failed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.managed.ManagedConnectionFactoryTest.nonexist", "Error: The class [ {0} ] as defined in the managedconnecttionfactory-class deployment descriptor does not exist", new Object[]{descriptor.getManagedConnectionFactoryImpl()}));
        }
        return mcf;
    }

    protected boolean testImplementationOf(ConnectorDescriptor descriptor, String interfaceName, Result result) {
        Class mcf = this.testManagedConnectionFactoryImpl(descriptor, result);
        if (mcf != null) {
            return VerifierTest.testImplementationOf(mcf, interfaceName, result);
        }
        return false;
    }
}

