/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector.cci;

import com.sun.enterprise.deployment.ConnectorArchivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.cci.ConnectionFactoryTest;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;

public class InteractionSpecJavaBeansCompliance
extends ConnectionFactoryTest
implements ConnectorCheck {
    static /* synthetic */ Class class$java$lang$Object;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result check(ConnectorDescriptor descriptor) {
        boolean oneFailed = false;
        Result result = this.getInitializedResult();
        if (!this.isCCIImplemented(descriptor, result)) {
            result.notApplicable(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.cci.InteractionExistence.notapp", "NotApplicable : The CCI interfaces do not seem to be implemented by this resource adapter"));
            return result;
        }
        File jarFile = Verifier.getJarFile(((ConnectorArchivist)descriptor.getArchivist()).getRarFile().getName());
        Class mcf = this.findImplementorOf(jarFile, "javax.resource.cci.InteractionSpec");
        if (mcf == null) {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: While the CCI interfaces are implemented, the javax.resource.cci.InteractionSpec is not"));
            return result;
        }
        try {
            BeanInfo bi2 = Introspector.getBeanInfo(mcf, class$java$lang$Object == null ? (class$java$lang$Object = InteractionSpecJavaBeansCompliance.class$("java.lang.Object")) : class$java$lang$Object);
            PropertyDescriptor[] properties = bi2.getPropertyDescriptors();
            int i2 = 0;
            while (i2 < properties.length) {
                if (properties[i2].getReadMethod() == null || properties[i2].getWriteMethod() == null) {
                    oneFailed = true;
                    result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: The javax.resource.cci.InteractionSpec implementation [ {0} ] of the property [ {1} ] is not JavaBeans compliant", new Object[]{mcf.getName(), properties[i2].getName()}));
                }
                if (!properties[i2].isConstrained() && !properties[i2].isBound()) {
                    oneFailed = true;
                    result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed2", "Error: The property [ {0} ] of the javax.resource.cci.InteractionSpec implementation [ {1} ] is not bound or constrained", new Object[]{properties[i2].getName(), mcf.getName()}));
                }
                ++i2;
            }
        }
        catch (IntrospectionException ie) {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: The javax.resource.cci.InteractionSpec implementation [ {0} ] is not JavaBeans compliant", new Object[]{mcf.getName()}));
            return result;
        }
        if (!oneFailed) {
            result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "The javax.resource.cci.InteractionSpec implementation is JavaBeans compliant"));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

