/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector.cci;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import com.sun.enterprise.util.JarClassLoader;

public abstract class ConnectionTest
extends ConnectorTest {
    protected Class getConnectionImpl(ConnectorDescriptor descriptor) throws ClassNotFoundException {
        String className = descriptor.getConnectionImpl();
        if (className == null) {
            return null;
        }
        Context context = this.getVerifierContext();
        JarClassLoader jcl = context.getClassLoader();
        return jcl.loadClass(className);
    }

    protected Class testConnectionImpl(ConnectorDescriptor descriptor, Result result) {
        Class mcf = null;
        try {
            mcf = this.getConnectionImpl(descriptor);
            if (mcf == null) {
                result.failed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.cci.ConnectionTest.nonimpl", "Error: The resource adapter must implement the javax.resource.cci.Connection interface and declare it in the connection-impl-class deployment descriptor."));
            }
        }
        catch (ClassNotFoundException cnfe) {
            result.failed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.cci.ConnectionTest.nonexist", "Error: The class [ {0} ] as defined in the connection-impl-class deployment descriptor does not exist", new Object[]{descriptor.getConnectionFactoryImpl()}));
        }
        return mcf;
    }

    protected boolean testImplementationOf(ConnectorDescriptor descriptor, String interfaceName, Result result) {
        Class mcf = this.testConnectionImpl(descriptor, result);
        if (mcf != null) {
            return VerifierTest.testImplementationOf(mcf, interfaceName, result);
        }
        return false;
    }
}

