/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.util.JarClassLoader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public abstract class ConnectorTest
extends VerifierTest
implements VerifierCheck,
ConnectorCheck {
    static /* synthetic */ Class class$java$lang$Object;

    public Result check(Descriptor descriptor) {
        return this.check((ConnectorDescriptor)descriptor);
    }

    public abstract Result check(ConnectorDescriptor var1);

    protected Class findImplementorOf(File jarFile, String interfaceName) {
        try {
            JarFile jar = new JarFile(jarFile);
            Enumeration<JarEntry> enumeration = jar.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry je = enumeration.nextElement();
                if (!je.getName().endsWith(".jar")) continue;
                JarInputStream jis = new JarInputStream(jar.getInputStream(je));
                ZipEntry ze = jis.getNextEntry();
                while (ze != null) {
                    String elementName = ze.getName();
                    if (elementName.endsWith(".class")) {
                        String className = elementName.substring(0, elementName.length() - ".class".length()).replace('/', '.');
                        try {
                            Class<?> c10 = null;
                            Context context = this.getVerifierContext();
                            JarClassLoader jcl = context.getClassLoader();
                            c10 = jcl.loadClass(className);
                            if (VerifierTest.isImplementorOf(c10, interfaceName)) {
                                return c10;
                            }
                        }
                        catch (ClassNotFoundException cnfe) {
                            // empty catch block
                        }
                    }
                    ze = jis.getNextEntry();
                }
            }
        }
        catch (IOException ioe) {
            Verifier.debug(ioe);
        }
        return null;
    }

    protected boolean checkMethodImpl(Class clazz, String methodName, Class[] parmTypes, String methodSignature, Result result) {
        Method m2 = null;
        Class c10 = clazz;
        do {
            try {
                m2 = clazz.getMethod(methodName, parmTypes);
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (SecurityException se) {
                // empty catch block
            }
            c10 = c10.getSuperclass();
        } while (m2 != null && c10 != (class$java$lang$Object == null ? ConnectorTest.class$("java.lang.Object") : class$java$lang$Object));
        if (m2 == null) {
            result.failed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.MethodOverride.failed", "Warning: The class [ {0} ] does not override the method [ {1} ]", new Object[]{clazz.getName(), methodSignature}));
            return false;
        }
        result.passed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.MethodOverride.passed", "The class [ {0} ] overrides the method [ {1} ]", new Object[]{clazz.getName(), methodSignature}));
        return true;
    }

    protected boolean findImplementorOf(File jarFile, String interfaceName, Result result) {
        Class c10 = this.findImplementorOf(jarFile, interfaceName);
        if (c10 != null) {
            result.passed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.findImplementor.passed", "The class [ {0} ] implements the [ {1} ] interface", new Object[]{c10.getName(), interfaceName}));
            return true;
        }
        result.failed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.findImplementor.failed", "Error: There is no implementation of the [ {0} ] provided", new Object[]{interfaceName}));
        return false;
    }

    protected boolean isClassLoadable(String className, Result result) {
        Context context = this.getVerifierContext();
        JarClassLoader jcl = context.getClassLoader();
        try {
            Class<?> c10 = jcl.loadClass(className);
            result.passed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.isClassLoadable.passed", "The class [ {0} ] is contained in the archive file", new Object[]{className}));
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            result.passed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.isClassLoadable.failed", "The class [ {0} ] is not contained in the archive file", new Object[]{className}));
            return true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

