/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector;

import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.xml.ConnectorNode;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.util.Iterator;
import java.util.Set;

public class AuthMechType
extends ConnectorTest
implements ConnectorCheck {
    private static String[] allowedMechs = new String[]{ConnectorNode.DD_BASIC_PASSWORD, ConnectorNode.DD_KERBEROS};

    public Result check(ConnectorDescriptor descriptor) {
        boolean oneFailed = false;
        Result result = this.getInitializedResult();
        Set mechanisms = descriptor.getAuthMechanisms();
        if (mechanisms.isEmpty()) {
            result.passed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.AuthMechType.nonexist", "No authentication mechanism defined for this resource adapater", new Object[]{descriptor.getConnectionFactoryImpl()}));
            return result;
        }
        Iterator mechIterator = mechanisms.iterator();
        while (mechIterator.hasNext()) {
            AuthMechanism am2 = (AuthMechanism)mechIterator.next();
            String authMechType = am2.getAuthMechType();
            boolean allowedMech = false;
            if (authMechType != null) {
                int i2 = 0;
                while (i2 < allowedMechs.length) {
                    if (authMechType.equals(allowedMechs[i2])) {
                        allowedMech = true;
                        break;
                    }
                    ++i2;
                }
            }
            if (allowedMech && authMechType != null) continue;
            oneFailed = true;
            result.failed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.AuthMechType.failed", "Authentication mechanism type [ {0} ] is not allowed", new Object[]{authMechType}));
        }
        if (!oneFailed) {
            result.passed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.AuthMechType.passed", "All defined authentication mechanism types are allowed", new Object[]{descriptor.getConnectionFactoryImpl()}));
        }
        return result;
    }
}

