/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.packager;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ApplicationClientArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.packager.ApplicationAssemblyDescriptor;
import com.sun.enterprise.tools.packager.ComponentPackager;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class Main {
    private static String HELP = "-help";
    private static String PACKAGE_WEB_APP = "-webArchive";
    private static String PACKAGE_EJB_JAR = "-ejbJar";
    private static String PACKAGE_CONNECTOR = "-connector";
    private static String PACKAGE_APPLICATION = "-enterpriseArchive";
    private static String LIBRARY_JARS = "-libraryJars";
    private static String EXTERNAL_DESCRIPTOR_NAMES = "-alternativeDescriptorEntries";
    private static String PACKAGE_APPLICATION_CLIENT = "-applicationClient";
    private static String SET_RUNTIME = "-setRuntime";
    private static String SET_CLIENT_RUNTIME = "-setApplicationClientRuntime";
    private static String CONTENT_FILES = "-contentFiles";
    private static String CLASSPATH = "-classpath";
    private static String CLASS_FILES = "-classFiles";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$packager$Main == null ? (class$com$sun$enterprise$tools$packager$Main = Main.class$("com.sun.enterprise.tools.packager.Main")) : class$com$sun$enterprise$tools$packager$Main);
    static /* synthetic */ Class class$com$sun$enterprise$tools$packager$Main;

    public static void main(String[] args) {
        Utility.checkJVMVersion();
        try {
            if (args.length > 0) {
                String runtimeDDFilename;
                File file;
                Vector<String> fileNames;
                String descriptorFile;
                String files;
                String codebase;
                StringTokenizer st;
                StringTokenizer st2;
                ComponentPackager packager = new ComponentPackager();
                if (args[0].equals(PACKAGE_WEB_APP)) {
                    String servletClasspath = null;
                    Vector<String> contentFiles = null;
                    Vector<String> classFiles = null;
                    int parseIndex = 0;
                    if (args[1].equals(CLASSPATH)) {
                        servletClasspath = args[2];
                        parseIndex = 2;
                        if (args[3].equals(CLASS_FILES)) {
                            classFiles = new Vector<String>();
                            String classFileList = args[4];
                            st2 = new StringTokenizer(classFileList, ":");
                            while (st2.hasMoreTokens()) {
                                classFiles.addElement(st2.nextToken());
                            }
                            parseIndex = 4;
                        }
                    }
                    String contentRoot = args[parseIndex + 1];
                    if (args[parseIndex + 2].equals(CONTENT_FILES)) {
                        String contentFilenames = args[parseIndex + 3];
                        st = new StringTokenizer(contentFilenames, ":");
                        contentFiles = new Vector<String>();
                        while (st.hasMoreTokens()) {
                            contentFiles.add(st.nextToken());
                        }
                        parseIndex += 2;
                    }
                    String descriptorFilename = args[parseIndex + 2];
                    String warFile = args[parseIndex + 3];
                    try {
                        packager.packageWebArchive(servletClasspath, classFiles, new Vector(), contentRoot, contentFiles, descriptorFilename, warFile);
                    }
                    catch (Exception e10) {
                        packager.handlePackagingException(e10);
                        System.exit(1);
                    }
                    System.exit(0);
                }
                if (args[0].equals(PACKAGE_EJB_JAR)) {
                    codebase = args[1];
                    files = args[2];
                    descriptorFile = args[3];
                    String jarFile = args[4];
                    fileNames = new Vector<String>();
                    st2 = new StringTokenizer(files, ":");
                    while (st2.hasMoreTokens()) {
                        fileNames.addElement(st2.nextToken());
                    }
                    try {
                        packager.packageEjbArchive(codebase, fileNames, descriptorFile, jarFile);
                    }
                    catch (Exception e11) {
                        packager.handlePackagingException(e11);
                        System.exit(1);
                    }
                    System.exit(0);
                }
                if (args[0].equals(PACKAGE_CONNECTOR)) {
                    if (args.length != 5) {
                        Main.help();
                    }
                    codebase = args[1];
                    files = args[2];
                    descriptorFile = args[3];
                    String jarFile = args[4];
                    fileNames = new Vector();
                    st2 = new StringTokenizer(files, ":");
                    while (st2.hasMoreTokens()) {
                        fileNames.addElement(st2.nextToken());
                    }
                    try {
                        packager.packageConnectorArchive(codebase, fileNames, descriptorFile, jarFile);
                    }
                    catch (Exception e12) {
                        packager.handlePackagingException(e12);
                        System.exit(1);
                    }
                    System.exit(0);
                }
                if (args[0].equals(PACKAGE_APPLICATION_CLIENT)) {
                    codebase = args[1];
                    files = args[2];
                    String mainClassName = args[3];
                    String descriptorFile2 = args[4];
                    String jarFile = args[5];
                    Vector<String> fileNames2 = new Vector<String>();
                    st = new StringTokenizer(files, ":");
                    while (st.hasMoreTokens()) {
                        fileNames2.addElement(st.nextToken());
                    }
                    try {
                        packager.packageApplicationClient(codebase, fileNames2, mainClassName, descriptorFile2, jarFile);
                    }
                    catch (Exception e13) {
                        packager.handlePackagingException(e13);
                        System.exit(1);
                    }
                    System.exit(0);
                }
                if (args[0].equals(PACKAGE_APPLICATION)) {
                    String jarNames = args[1];
                    Vector<String> jarFilenames = new Vector<String>();
                    String[] list = FileUtil.parseFileList(jarNames);
                    int i2 = 0;
                    while (i2 < list.length) {
                        jarFilenames.add(list[i2]);
                        ++i2;
                    }
                    int parseIndex = 0;
                    Vector<String> eDDNames = new Vector<String>();
                    if (args[2].equals(EXTERNAL_DESCRIPTOR_NAMES)) {
                        parseIndex = 2;
                        String eDDNamesString = args[3];
                        if (eDDNamesString.startsWith(":")) {
                            eDDNames.addElement("");
                        }
                        StringTokenizer st3 = new StringTokenizer(eDDNamesString, ":");
                        while (st3.hasMoreTokens()) {
                            String eDDName = st3.nextToken();
                            eDDNames.addElement(eDDName);
                        }
                        if (eDDNamesString.endsWith(":")) {
                            eDDNames.addElement("");
                        }
                    } else {
                        Enumeration e14 = jarFilenames.elements();
                        while (e14.hasMoreElements()) {
                            e14.nextElement();
                            eDDNames.addElement("");
                        }
                    }
                    ApplicationAssemblyDescriptor aad = new ApplicationAssemblyDescriptor();
                    aad.addJarFilenames(jarFilenames);
                    Vector<String> libJars = new Vector<String>();
                    if (args[2].equals(LIBRARY_JARS)) {
                        String libraryJarsString = args[(parseIndex += 2) + 1];
                        StringTokenizer st4 = new StringTokenizer(libraryJarsString, ":");
                        while (st4.hasMoreTokens()) {
                            String libJarString = st4.nextToken();
                            libJars.addElement(libJarString);
                        }
                    }
                    if (jarFilenames.size() > eDDNames.size()) {
                        System.out.println(localStrings.getLocalString("main.filename.extension.name.mismatch", "File Name extension mismatch"));
                        System.exit(1);
                    }
                    int i3 = 0;
                    while (i3 < jarFilenames.size()) {
                        aad.setExternalDDFilenameFor((String)jarFilenames.elementAt(i3), (String)eDDNames.elementAt(i3));
                        ++i3;
                    }
                    String appName = args[2 + parseIndex];
                    String appJarName = args[3 + parseIndex];
                    try {
                        packager.assembleApplication(aad, libJars, appName, appJarName);
                    }
                    catch (Exception e15) {
                        packager.handlePackagingException(e15);
                        System.exit(1);
                    }
                    return;
                }
                if (args[0].equals(SET_RUNTIME)) {
                    file = new File(args[1]);
                    runtimeDDFilename = args[2];
                    File outputFile = null;
                    if (args.length > 3) {
                        if (!args[3].equals("-o")) {
                            Main.help();
                        }
                        if (args.length != 5) {
                            Main.help();
                        }
                        outputFile = new File(args[4]);
                    }
                    try {
                        Descriptor descriptor;
                        if (ApplicationClientArchivist.isApplicationClientJar(file)) {
                            descriptor = ApplicationClientArchivist.open(file);
                            packager.setClientRuntimeDeploymentInfo((ApplicationClientDescriptor)descriptor, new File(runtimeDDFilename), outputFile);
                        } else if (ApplicationArchivist.isApplication(file)) {
                            descriptor = ApplicationArchivist.open(file);
                            packager.setRuntimeDeploymentInfo((Application)descriptor, new File(runtimeDDFilename), outputFile);
                        } else {
                            String msg = localStrings.getLocalString("componentpackager.msg001", file + " must be an application client jar file or an application archive", new String[]{file.toString()});
                            System.out.println(msg);
                        }
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        System.exit(1);
                    }
                    catch (Throwable t2) {
                        t2.printStackTrace();
                        System.exit(1);
                    }
                    System.exit(0);
                }
                if (args[0].equals(SET_CLIENT_RUNTIME)) {
                    file = new File(args[1]);
                    runtimeDDFilename = args[2];
                    String appClientName = args[3];
                    try {
                        if (ApplicationArchivist.isApplication(file)) {
                            Application descriptor = ApplicationArchivist.open(file);
                            packager.setClientRuntimeDeploymentInfo(descriptor, new File(runtimeDDFilename), appClientName);
                        } else if (ApplicationArchivist.isApplication(file)) {
                            Application descriptor = ApplicationArchivist.open(file);
                            packager.setRuntimeDeploymentInfo(descriptor, new File(runtimeDDFilename));
                        } else {
                            String msg = localStrings.getLocalString("componentpackager.msg001", file + " must be an application client jar file or an application archive", new String[]{file.toString()});
                            System.out.println(msg);
                        }
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        System.exit(1);
                    }
                    catch (Throwable t3) {
                        t3.printStackTrace();
                        System.exit(1);
                    }
                    System.exit(0);
                }
            }
            Main.help();
        }
        catch (ArrayIndexOutOfBoundsException aeoobe) {
            String msg = localStrings.getLocalString("componentpackager.msg002", "Packaging Syntax error.");
            System.out.println(msg);
            Main.help();
        }
    }

    static Set parseLibJars(String libJarString) {
        HashSet<String> libJars = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(libJarString, "+");
        while (st.hasMoreTokens()) {
            libJars.add(st.nextToken());
        }
        return libJars;
    }

    public static void help() {
        String msg = localStrings.getLocalString("componentpackager.msg003", "J2EE Packaging Tool version 1.3", new String[]{"1.3"});
        System.out.println(msg);
        System.out.println(localStrings.getLocalString("componentpackager.options", "Options:"));
        System.out.println("    " + PACKAGE_EJB_JAR + " <root-directory> <file-list> <ejb-dd> <ejb-jar>");
        System.out.println("    " + PACKAGE_WEB_APP + " [-classpath <root-directory> [" + CLASS_FILES + " <file-list>]] <content-root> [" + CONTENT_FILES + " <file-list>] <web-dd> <web-war>");
        System.out.println("    " + PACKAGE_APPLICATION_CLIENT + " <root-directory> <file-list> <main-class> <appclient-dd> <appclient-jar>");
        System.out.println("    " + PACKAGE_APPLICATION + " <file-only-list> [" + EXTERNAL_DESCRIPTOR_NAMES + " <file-only-list>] [" + LIBRARY_JARS + " <file-list>] <app-name> <app-ear>");
        System.out.println("    " + PACKAGE_CONNECTOR + " <root-directory> <file-list> <connector-dd> <connector-rar>");
        System.out.println("    " + SET_RUNTIME + " <app-ear>|<appclient-jar> <runtime.xml> [-o <output-file>]");
        System.out.println("");
        System.out.println(localStrings.getLocalString("componentpackager.msg007", "Remarks:"));
        System.out.print("    ");
        System.out.println(localStrings.getLocalString("componentpackager.msg004", "    <file-list> is a list of files or directories separated by colons :"));
        System.out.print("    ");
        System.out.println(localStrings.getLocalString("componentpackager.msg005", "    <file-only-list> is a list of files separated by colons :"));
        System.out.println("");
        System.out.println(localStrings.getLocalString("componentpackager.msg006", "Examples:"));
        System.out.println("    -ejbJar classes packageA:packageB/Class1.class ejb-jar.xml ejb.jar");
        System.out.println("    -webArchive -classpath classes packageA:packageB/class1.class contentRoot -contentFiles login.jsp:MyApplet.class:images web.xml web.war");
        System.out.println("    -applicationClient classes packageA:packageB/Class1.class packageA.Main appclient.xml appclient.jar");
        System.out.println("    -enterpriseArchive web.war:ejb.jar:adapter.rar -libraryJars util.jar appName app.ear");
        System.out.println("    -connector classes packageA:packageB/Class1.class ra.xml adapter.rar");
        System.exit(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

