/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.packager;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ApplicationClientArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectorArchivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.xml.ApplicationClientRuntimeDescriptorNode;
import com.sun.enterprise.deployment.xml.ApplicationNode;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.RuntimeDescriptorNode;
import com.sun.enterprise.tools.packager.ApplicationAssemblyDescriptor;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class ComponentPackager {
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$packager$ComponentPackager == null ? (class$com$sun$enterprise$tools$packager$ComponentPackager = ComponentPackager.class$("com.sun.enterprise.tools.packager.ComponentPackager")) : class$com$sun$enterprise$tools$packager$ComponentPackager);
    static /* synthetic */ Class class$com$sun$enterprise$tools$packager$ComponentPackager;

    public void handlePackagingException(Exception exception) {
        System.out.println(localStrings.getLocalString("componentpackager.msg008", "Exception during packaging: "));
        if (exception instanceof ParseException) {
            ParseException pe = (ParseException)exception;
            if (pe.getSAXException() != null) {
                String exMsg = pe.getSAXException().getMessage();
                System.out.println(localStrings.getLocalString("componentpackager.msg009", "Error parsing XML: " + exMsg, new String[]{exMsg}));
            } else {
                System.out.println(pe.getMessage());
            }
            pe.printStackTrace();
        } else if (exception instanceof ContentTransformationException) {
            ContentTransformationException cte = (ContentTransformationException)exception;
            System.out.println(localStrings.getLocalString("componentpackager.msg010", "Error interpreting XML: " + cte.getMessage(), new String[]{cte.getMessage()}));
            System.out.println(cte.getXml());
            cte.printStackTrace();
        } else if (exception instanceof IOException) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        } else {
            System.out.println(localStrings.getLocalString("componentpackager.msg011", "Unknown packaging error"));
            exception.printStackTrace();
        }
    }

    private Vector recursiveGetFiles(String baseDir, Vector fileList) throws IOException {
        Vector<String> allFiles = new Vector<String>();
        int size = fileList.size();
        int i2 = 0;
        while (i2 < size) {
            String fileName = (String)fileList.elementAt(i2);
            File file = new File(baseDir, fileName);
            if (!file.exists()) {
                throw new FileNotFoundException(file.toString());
            }
            if (file.isDirectory()) {
                Set filesUnder = FileUtil.getAllFilesUnder(new File(baseDir, fileName), null);
                Iterator iter = filesUnder.iterator();
                while (iter.hasNext()) {
                    File file1 = (File)iter.next();
                    if (file1.getPath().endsWith(".java")) continue;
                    allFiles.addElement(fileName + File.separator + file1.getPath());
                }
            } else {
                allFiles.addElement(fileName);
            }
            ++i2;
        }
        return allFiles;
    }

    private void deleteDestinationFile(File destination) throws IOException {
        boolean result;
        if (destination.exists() && !(result = destination.delete())) {
            throw new IOException(localStrings.getLocalString("componentpackager.msg014", "Error deleting file: " + destination.toString(), new String[]{destination.toString()}));
        }
    }

    public void packageWebArchive(String servletClasspath, Vector classFiles, Vector libraryFiles, String contentRoot, Vector contentFiles, String descriptorFilename, String destinationFile) throws Exception {
        Vector allClassFiles = null;
        if (classFiles != null) {
            allClassFiles = this.recursiveGetFiles(servletClasspath, classFiles);
            int size = allClassFiles.size();
            int i2 = 0;
            while (i2 < size) {
                String file = (String)allClassFiles.elementAt(i2);
                allClassFiles.setElementAt(new File(file), i2);
                ++i2;
            }
        }
        Vector allContentFiles = null;
        if (contentFiles != null) {
            allContentFiles = this.recursiveGetFiles(contentRoot, contentFiles);
            int size = allContentFiles.size();
            int i3 = 0;
            while (i3 < size) {
                String file = (String)allContentFiles.elementAt(i3);
                allContentFiles.setElementAt(new File(file), i3);
                ++i3;
            }
        }
        this.deleteDestinationFile(new File(destinationFile));
        WebBundleArchivist.createPackage(servletClasspath, allClassFiles, libraryFiles, contentRoot, allContentFiles, descriptorFilename, destinationFile);
    }

    public void packageEjbArchive(String baseDirectory, Vector filesToAdd, String descriptorFilename, String destinationFile) throws Exception {
        Vector allFiles = this.recursiveGetFiles(baseDirectory, filesToAdd);
        FileContentsDescriptor fcd = new FileContentsDescriptor(baseDirectory, allFiles);
        File descriptorFile = new File(descriptorFilename);
        File destination = new File(destinationFile);
        this.deleteDestinationFile(destination);
        EjbBundleArchivist.createPackage(fcd, descriptorFile, destination);
    }

    public void packageConnectorArchive(String baseDirectory, Vector filesToAdd, String descriptorFilename, String destinationFile) throws Exception {
        Vector allFiles = this.recursiveGetFiles(baseDirectory, filesToAdd);
        FileContentsDescriptor fcd = new FileContentsDescriptor(baseDirectory, allFiles);
        File descriptorFile = new File(descriptorFilename);
        File destination = new File(destinationFile);
        this.deleteDestinationFile(destination);
        ConnectorArchivist.createPackage(fcd, descriptorFile, destination);
    }

    public void packageApplicationClient(String baseDirectory, Vector filesToAdd, String mainClassName, String descriptorFilename, String destinationFilename) throws Exception {
        Vector allFiles = this.recursiveGetFiles(baseDirectory, filesToAdd);
        FileContentsDescriptor fcd = new FileContentsDescriptor(baseDirectory, allFiles);
        File descriptorFile = new File(descriptorFilename);
        File destination = new File(destinationFilename);
        this.deleteDestinationFile(destination);
        ApplicationClientArchivist.createPackage(fcd, mainClassName, descriptorFile, destination);
    }

    private String relativize(String base, String longer) {
        String nBase = base.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        String nLonger = longer.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        if (nLonger.startsWith(nBase)) {
            return nLonger.substring(nBase.length(), nLonger.length());
        }
        return nLonger;
    }

    public static String getEjbBundleFilename(String applicationFilename) {
        return applicationFilename + ".ejbBundle.xml";
    }

    public static String getRuntimeDescriptorFilename(String applicationFilename) {
        return applicationFilename + ".runtime.xml";
    }

    public void packageEjbs(String baseDirectory, Vector filesToAdd, String descriptorFilename, String jarFile, String optionalEjbBundleFilename, String optionalRuntimeFilename) throws Exception {
        String ejbDescriptorFilename = "";
        String runtimeDescriptorFilename = "";
        ejbDescriptorFilename = "".equals(optionalEjbBundleFilename) ? ComponentPackager.getEjbBundleFilename(descriptorFilename) : optionalEjbBundleFilename;
        runtimeDescriptorFilename = "".equals(optionalRuntimeFilename) ? ComponentPackager.getRuntimeDescriptorFilename(descriptorFilename) : optionalRuntimeFilename;
        System.out.println("Package the ejbs specified in " + ejbDescriptorFilename);
        System.out.println(" using the application descriptor in " + descriptorFilename);
        System.out.println(" and the runtime descriptor in " + runtimeDescriptorFilename);
        System.out.println("All files relative to " + baseDirectory);
        File applicationDescriptorFile = new File(baseDirectory, descriptorFilename);
        FileInputStream fis = new FileInputStream(applicationDescriptorFile);
        ApplicationNode applicationNode = ApplicationNode.read(fis);
        Application application = applicationNode.getApplication(null);
        String applicationName = application.getName();
        File ejbJarFile = new File("ejb-jar-" + System.currentTimeMillis() + new File(jarFile).getName());
        Vector<String> allFiles = new Vector<String>();
        Enumeration e10 = filesToAdd.elements();
        while (e10.hasMoreElements()) {
            String nextFile = (String)e10.nextElement();
            File nextRealFileOrDir = new File(baseDirectory, nextFile);
            if (nextRealFileOrDir.isDirectory()) {
                Iterator itr = FileUtil.getAllFilesUnder(nextRealFileOrDir, null).iterator();
                while (itr.hasNext()) {
                    File next = null;
                    next = nextFile.equals(".") ? (File)itr.next() : new File(nextFile, ((File)itr.next()).toString());
                    allFiles.addElement(next.toString());
                }
                continue;
            }
            allFiles.addElement(nextFile);
        }
        FileContentsDescriptor fcd = new FileContentsDescriptor(baseDirectory, allFiles);
        File descriptorFile = new File(baseDirectory, ejbDescriptorFilename);
        EjbBundleArchivist.createPackage(fcd, descriptorFile, ejbJarFile);
        ApplicationAssemblyDescriptor ejbJars = new ApplicationAssemblyDescriptor();
        ejbJars.addJarFilename(ejbJarFile.getAbsolutePath());
        this.assembleApplication(ejbJars, new Vector(), applicationName, jarFile);
        Application assembledApplication = ApplicationArchivist.open(new File(jarFile));
        fis = new FileInputStream(new File(baseDirectory, runtimeDescriptorFilename));
        RuntimeDescriptorNode rdn = RuntimeDescriptorNode.read(fis);
        rdn.updateRuntimeInformation(assembledApplication);
        ejbJarFile.delete();
        ApplicationArchivist appArchivist = assembledApplication.getApplicationArchivist();
        appArchivist.save(appArchivist.getApplicationFile(), true);
    }

    public void assembleApplication(ApplicationAssemblyDescriptor assemblyDescriptor, Vector libJars, String applicationName, String destinationFile) throws Exception {
        Vector allLibJars = this.recursiveGetFiles(".", libJars);
        int i2 = 0;
        while (i2 < allLibJars.size()) {
            String fileName = (String)allLibJars.elementAt(i2);
            assemblyDescriptor.addLibraryJarFilename(fileName);
            ++i2;
        }
        Application a = new Application(applicationName, new File(destinationFile));
        this.deleteDestinationFile(new File(destinationFile));
        a.getApplicationArchivist().save(a.getApplicationArchivist().getApplicationFile(), true);
        Iterator itr = assemblyDescriptor.getJarFilenames().iterator();
        while (itr.hasNext()) {
            Iterator mcs;
            String nextJarFilename = (String)itr.next();
            File nextJarFile = new File(nextJarFilename);
            String nextExternalDescriptorUri = assemblyDescriptor.getExternalDDFilenameFor(nextJarFilename);
            if (EjbBundleArchivist.isEjbBundle(nextJarFile)) {
                EjbBundleDescriptor bundleDescriptor = a.getApplicationArchivist().addEjbJar(nextJarFile, nextExternalDescriptorUri);
                if (!assemblyDescriptor.getLibraryJarFilenames().isEmpty()) {
                    mcs = assemblyDescriptor.getLibraryJarFilenames().iterator();
                    while (mcs.hasNext()) {
                        bundleDescriptor.getArchivist().addManfiestClasspath(ApplicationAssemblyDescriptor.getLibraryJarEntryNameFrom((String)mcs.next()));
                    }
                }
            }
            if (WebBundleArchivist.isWebBundle(nextJarFile)) {
                a.getApplicationArchivist().addWebJar(nextJarFile, nextExternalDescriptorUri);
            }
            if (ApplicationClientArchivist.isApplicationClientJar(nextJarFile)) {
                ApplicationClientDescriptor clientDescriptor = a.getApplicationArchivist().addApplicationClientJar(nextJarFile, new HashSet(), nextExternalDescriptorUri);
                if (!assemblyDescriptor.getLibraryJarFilenames().isEmpty()) {
                    mcs = assemblyDescriptor.getLibraryJarFilenames().iterator();
                    while (mcs.hasNext()) {
                        clientDescriptor.getArchivist().addManfiestClasspath(ApplicationAssemblyDescriptor.getLibraryJarEntryNameFrom((String)mcs.next()));
                    }
                }
            }
            if (ConnectorArchivist.isConnector(nextJarFile)) {
                ConnectorDescriptor connectorDescriptor = a.getApplicationArchivist().addRar(nextJarFile, new HashSet(), nextExternalDescriptorUri);
                if (!assemblyDescriptor.getLibraryJarFilenames().isEmpty()) {
                    mcs = assemblyDescriptor.getLibraryJarFilenames().iterator();
                    while (mcs.hasNext()) {
                        connectorDescriptor.getArchivist().addManfiestClasspath(ApplicationAssemblyDescriptor.getLibraryJarEntryNameFrom((String)mcs.next()));
                    }
                }
            }
            if (!ApplicationArchivist.isApplication(nextJarFile)) continue;
            a.getApplicationArchivist().addApplicationJar(nextJarFile);
        }
        if (!assemblyDescriptor.getLibraryJarFilenames().isEmpty()) {
            a.getApplicationArchivist().addFiles(assemblyDescriptor.getLibraryJarFilenameToEntryNameMap(), a.getApplicationArchivist().getApplicationFile());
        }
        a.getApplicationArchivist().save(a.getApplicationArchivist().getApplicationFile(), false);
        System.out.println(localStrings.getLocalString("componentpackager.msg012", "Creation of application in " + destinationFile + " is complete", new String[]{destinationFile}));
    }

    public void setRuntimeDeploymentInfo(Application application, File runtimeDeploymentInfo) throws Exception {
        this.setRuntimeDeploymentInfo(application, runtimeDeploymentInfo, null);
    }

    public void setRuntimeDeploymentInfo(Application application, File runtimeDeploymentInfo, File outputFile) throws Exception {
        FileInputStream fis = new FileInputStream(runtimeDeploymentInfo);
        RuntimeDescriptorNode node = RuntimeDescriptorNode.read(fis);
        node.updateRuntimeInformation(application);
        if (outputFile == null) {
            outputFile = application.getApplicationArchivist().getApplicationFile();
        }
        application.getApplicationArchivist().save(outputFile, true);
        System.out.println(localStrings.getLocalString("componentpackager.msg013", "Set runtime done"));
    }

    public void setClientRuntimeDeploymentInfo(ApplicationClientDescriptor descriptor, File runtimeDeploymentInfo) throws Exception {
        this.setClientRuntimeDeploymentInfo(descriptor, runtimeDeploymentInfo, (File)null);
    }

    public void setClientRuntimeDeploymentInfo(ApplicationClientDescriptor descriptor, File runtimeDeploymentInfo, File outputFile) throws Exception {
        FileInputStream fis = new FileInputStream(runtimeDeploymentInfo);
        ApplicationClientRuntimeDescriptorNode node = ApplicationClientRuntimeDescriptorNode.read(fis);
        node.updateRuntimeInformation(descriptor);
        if (outputFile == null) {
            outputFile = new File(descriptor.getArchivist().getArchiveUri());
        }
        ((ApplicationClientArchivist)descriptor.getArchivist()).save(outputFile, true);
        System.out.println(localStrings.getLocalString("componentpackager.msg013", "Set runtime done"));
    }

    public void setClientRuntimeDeploymentInfo(Application descriptor, File runtimeDeploymentInfo, String applicationClientName) throws Exception {
        this.setClientRuntimeDeploymentInfo(descriptor, runtimeDeploymentInfo, applicationClientName, null);
    }

    public void setClientRuntimeDeploymentInfo(Application descriptor, File runtimeDeploymentInfo, String applicationClientName, File outputFile) throws Exception {
        FileInputStream fis = new FileInputStream(runtimeDeploymentInfo);
        ApplicationClientRuntimeDescriptorNode node = ApplicationClientRuntimeDescriptorNode.read(fis);
        ApplicationClientDescriptor acd = descriptor.getApplicationClientByName(applicationClientName);
        node.updateRuntimeInformation(acd);
        if (outputFile == null) {
            outputFile = descriptor.getApplicationArchivist().getApplicationFile();
        }
        descriptor.getApplicationArchivist().save(outputFile, true);
        System.out.println("Set runtime on client within application  done");
    }

    public String toString() {
        return "ComponentPackager";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

