/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.packager;

import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

class ApplicationAssemblyDescriptor {
    private Hashtable jarToInfoMap = new Hashtable();
    private Vector libraryJars = new Vector();

    ApplicationAssemblyDescriptor() {
    }

    void addJarFilename(String filename) {
        this.jarToInfoMap.put(filename, "");
    }

    void addJarFilenames(Vector v2) {
        Enumeration e10 = v2.elements();
        while (e10.hasMoreElements()) {
            this.addJarFilename((String)e10.nextElement());
        }
    }

    void setExternalDDFilenameFor(String filename, String externalDDFilename) {
        this.jarToInfoMap.put(filename, externalDDFilename);
    }

    void addLibraryJarFilename(String libraryJarFilename) {
        this.libraryJars.addElement(libraryJarFilename);
    }

    Set getJarFilenames() {
        HashSet filenames = new HashSet();
        Enumeration e10 = this.jarToInfoMap.keys();
        while (e10.hasMoreElements()) {
            filenames.add(e10.nextElement());
        }
        return filenames;
    }

    Hashtable getLibraryJarFilenameToEntryNameMap() {
        Hashtable<String, File> all = new Hashtable<String, File>();
        Iterator itr = this.getLibraryJarFilenames().iterator();
        while (itr.hasNext()) {
            String filename = (String)itr.next();
            all.put(ApplicationAssemblyDescriptor.getLibraryJarEntryNameFrom(filename), new File(filename));
        }
        return all;
    }

    String getExternalDDFilenameFor(String jarFilename) {
        return (String)this.jarToInfoMap.get(jarFilename);
    }

    Set getLibraryJarFilenames() {
        return new HashSet(this.libraryJars);
    }

    public static String getLibraryJarEntryNameFrom(String filename) {
        return "library/" + new File(filename).getName();
    }

    public String toString() {
        return this.jarToInfoMap.toString() + this.libraryJars.toString();
    }
}

