/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.JTextField;

public class UITitledTextField
extends UITitledBox {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$utils$UITitledTextField == null ? (class$com$sun$enterprise$tools$deployment$ui$utils$UITitledTextField = UITitledTextField.class$("com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField")) : class$com$sun$enterprise$tools$deployment$ui$utils$UITitledTextField);
    private static String BROWSE = localStrings.getLocalString("ui.uititledtextfield.browserbutton", "Browse...");
    private static String REQUIRED_ENTRY_TITLE = localStrings.getLocalString("ui.uititledtextfield.requiredentrytitle", "Non-Blank Entry Required");
    private static String REQUIRED_ENTRY = localStrings.getLocalString("ui.uititledtextfield.requiredentry", "This textfield requires a non-blank entry.");
    private static final String DEFAULT_NONBLANK_TEXT = "?";
    private JTextField textField = this.createPrivateTextField();
    private JButton browserButton = null;
    private String lastAvailableText = null;
    private String lastEnabledText = null;
    private int text_updateComponent_recurse = 0;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$utils$UITitledTextField;

    public UITitledTextField(String title, boolean showBorder) {
        super(title, showBorder);
        this.add((Component)this.textField, this.getGBConstraints());
        this.textField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                UITitledTextField.this.updateComponent();
            }
        });
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                UITitledTextField.this.updateComponent();
            }
        });
        this.textField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent ke) {
                JRootPane root;
                JButton btn;
                if (ke.getKeyChar() == '\n' && (btn = (root = UITitledTextField.this.getRootPane()).getDefaultButton()) != null) {
                    EventQueue.invokeLater(new UIActionDispatcher((Object)btn, "doClick"));
                }
            }
        });
    }

    public UITitledTextField(String title) {
        this(title, false);
    }

    protected JTextField createPrivateTextField() {
        return new PrivateTextField();
    }

    protected GridBagConstraints getDefaultGBConstraints(GridBagConstraints c10) {
        c10 = super.getDefaultGBConstraints(c10);
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        if (this.hasTitle() && !this.hasVisibleBorder() && !this.hasLabeledTitle()) {
            c10.insets.left += 3;
        }
        c10.fill = 2;
        c10.anchor = 11;
        return c10;
    }

    public void setBrowserButton(JButton button) {
        if (this.browserButton == null) {
            this.browserButton = button;
            GridBagConstraints c10 = (GridBagConstraints)this.getGBConstraints().clone();
            c10.weightx = 0.0;
            c10.gridx = -1;
            c10.gridy = 0;
            c10.insets.left = 3;
            c10.fill = 0;
            this.setGBConstraints(this.browserButton, c10);
            this.add(this.browserButton);
        }
    }

    public void setBrowserActionListener(ActionListener listener) {
        if (this.browserButton == null) {
            JButton button = new JButton(BROWSE);
            button.setMargin(new Insets(0, 3, 0, 3));
            Dimension bsize = new Dimension(button.getPreferredSize().width, this.textField.getPreferredSize().height);
            button.setPreferredSize(bsize);
            button.setMaximumSize(bsize);
            button.addActionListener(listener);
            this.setBrowserButton(button);
        }
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void setReadOnly(boolean state) {
        this.textField.setEnabled(!state && this.isEnabled());
        super.setReadOnly(state);
    }

    public void updateComponent() {
        boolean isValid;
        if (this.text_updateComponent_recurse > 0) {
            return;
        }
        ++this.text_updateComponent_recurse;
        boolean bl2 = isValid = this.validateOnUpdate ? this._performValidation() : true;
        if (isValid && (this.lastAvailableText == null || !this.getText().equals(this.lastAvailableText))) {
            this.lastAvailableText = this.getText();
            super.updateComponent();
        }
        --this.text_updateComponent_recurse;
    }

    public UITitledBox.Validator getNonBlankEntryValidator() {
        return new UITitledBox.Validator(){

            public boolean performValidation(UITitledBox b10) {
                return UITitledTextField._validateNonBlank(b10);
            }
        };
    }

    private static boolean _validateNonBlank(UITitledBox b10) {
        UITitledTextField tf = (UITitledTextField)b10;
        if (tf.getText().equals("")) {
            String title = tf.getTitle();
            if (title == null || title.equals("")) {
                title = REQUIRED_ENTRY_TITLE;
            }
            UIOptionPane.showErrorDialog(tf.getTextField(), REQUIRED_ENTRY, title);
            tf.setText(tf.lastAvailableText != null ? tf.lastAvailableText : DEFAULT_NONBLANK_TEXT);
            return false;
        }
        return true;
    }

    public void setEnabled(boolean state) {
        this.textField.setEnabled(state && !this.isReadOnly());
        if (this.browserButton != null) {
            this.browserButton.setEnabled(state);
        }
        super.setEnabled(state);
        if (this.clearWhenDisabled) {
            if (!this.isEnabled() && this.lastEnabledText == null) {
                this.lastEnabledText = this.getText();
                this._setText("");
            } else if (this.isEnabled() && this.lastEnabledText != null) {
                this._setText(this.lastEnabledText);
                this.lastEnabledText = null;
            }
        }
    }

    public String getText() {
        return this.textField.getText().trim();
    }

    public void setText(String text) {
        if (this.clearWhenDisabled) {
            if (!this.isEnabled()) {
                this.lastEnabledText = text;
            } else {
                this._setText(text);
            }
        } else {
            this._setText(text);
        }
    }

    protected void _setText(String text) {
        if (text == null) {
            text = "";
        }
        this.textField.setText(text);
        this.lastAvailableText = !text.equals("") ? text : null;
    }

    /*
     * Unable to fully structure code
     */
    public int getIntValue(int defaultValue) {
        num = this.getText();
        try {
            return Integer.parseInt(this.getText());
        }
        catch (NumberFormatException nfe) {
            if (num.equals("")) {
                return defaultValue;
            }
            len = num.length();
            p = num.charAt(0) == '-' ? 1 : 0;
            ** while (p < len && Character.isDigit((char)num.charAt((int)p)))
        }
lbl-1000:
        // 1 sources

        {
            ++p;
            continue;
        }
lbl12:
        // 1 sources

        try {
            return Integer.parseInt(num.substring(0, p));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public void setIntValue(int val) {
        this.setText(String.valueOf(val));
    }

    public String toString() {
        return this.textField.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PrivateTextField
    extends JTextField {
        private Color savedBackground = this.getBackground();

        public PrivateTextField() {
            this.setDisabledTextColor(UITitledBox.DisabledTextColor);
            if (UITitledBox.DefaultTextBorder != null) {
                this.setBorder(UITitledBox.DefaultTextBorder);
            }
            Insets textMargin = this.getMargin();
            if (textMargin.left < 3) {
                textMargin.left = 3;
                this.setMargin(textMargin);
            }
        }

        public void setEnabled(boolean state) {
            super.setEnabled(state);
            this.setBackground(state ? this.savedBackground : UITitledBox.DisabledBackgroundColor);
        }
    }
}

