/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import javax.swing.text.JTextComponent;

public class UITitledComboBox
extends UITitledBox {
    public static final String LAST_ADDED_ITEM = "*LastAddedItem*";
    private static final boolean SHOW_WIDE_POPUPS = false;
    protected Object lastEnabledSelection = null;
    private JComboBox comboBox = null;
    private ComboBoxModel comboModel = null;
    private Color comboBoxBackground = null;
    protected boolean usingComboBox = false;
    protected Object lastAddedItem = null;
    protected Hashtable selectionEnabler = null;
    protected boolean showSelectionAsToolTip = false;
    protected boolean showWidePopups = false;
    private static boolean didResetComboBoxColors = false;

    public UITitledComboBox(String title, boolean showBorder, boolean initCombo) {
        super(title, showBorder);
        if (initCombo) {
            this.initComboBox();
        }
    }

    public UITitledComboBox(String title, boolean showBorder) {
        this(title, showBorder, true);
    }

    public UITitledComboBox(String title) {
        this(title, false, true);
    }

    public UITitledComboBox() {
        this(null, false, true);
    }

    protected JComboBox createPrivateComboBox() {
        return new PrivateComboBox(this);
    }

    private void initComboBox() {
        this.usingComboBox = true;
        this.comboBox = this.createPrivateComboBox();
        this.comboBoxBackground = this.comboBox.getBackground();
        this.comboBox.setEditable(false);
        this.setGBConstraints(this.comboBox);
        this.add(this.comboBox);
        this.comboBox.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe2) {
                UITitledComboBox.this._updateComponent(false);
            }
        });
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                UITitledComboBox.this._updateComponent(true);
            }
        });
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    private void _updateComponent(boolean actionEvent) {
        this._resetSelectionToolTip();
        super.updateComponent();
    }

    public boolean isEditable() {
        return this.comboBox.isEditable();
    }

    public void setEditable(boolean state) {
        this.comboBox.setEditable(state);
        this._resetSelectionToolTip();
    }

    public int getIndexOf(Object obj) {
        ComboBoxModel model = this.getModel();
        if (model instanceof DefaultComboBoxModel) {
            return ((DefaultComboBoxModel)model).getIndexOf(obj);
        }
        UIUtils.debugImplementationError("'getModel()' is not an instanceof 'DefaultComboBoxModel'");
        return -1;
    }

    public boolean containsItem(Object obj) {
        return this.getIndexOf(obj) >= 0;
    }

    public void addItem(Object obj) {
        if (obj == null) {
            return;
        }
        Object addObj = obj instanceof JRadioButton ? ((JRadioButton)obj).getText() : obj;
        ComboBoxModel model = this.getModel();
        if (model != null) {
            if (model instanceof MutableComboBoxModel) {
                boolean wasEnabled = this._disableUpdate();
                ((MutableComboBoxModel)model).addElement(obj);
                this._enableUpdate(wasEnabled);
            } else {
                UIUtils.printImplementationError("Unable to add item");
            }
        } else {
            boolean wasEnabled = this._disableUpdate();
            this.comboBox.addItem(addObj);
            this._enableUpdate(wasEnabled);
        }
        this.lastAddedItem = addObj;
    }

    public void addItem(Object obj, int mnemonic) {
        this.addItem(obj);
    }

    public void removeItem(Object obj) {
        if (obj == null) {
            return;
        }
        Object delObj = obj instanceof JRadioButton ? ((JRadioButton)obj).getText() : obj;
        ComboBoxModel model = this.getModel();
        if (model != null) {
            if (model instanceof MutableComboBoxModel) {
                boolean wasEnabled = this._disableUpdate();
                ((MutableComboBoxModel)model).removeElement(obj);
                this._enableUpdate(wasEnabled);
            } else {
                UIUtils.printImplementationError("Unable to remove item");
            }
        } else {
            boolean wasEnabled = this._disableUpdate();
            this.comboBox.removeItem(delObj);
            this._enableUpdate(wasEnabled);
        }
        if (this.lastAddedItem != null && this.lastAddedItem.equals(delObj)) {
            this.lastAddedItem = null;
        }
    }

    public ComboBoxModel getModel() {
        ComboBoxModel model = this.comboModel != null ? this.comboModel : this.comboBox.getModel();
        return model;
    }

    public void clearModel() {
        this.setModel((ComboBoxModel)null);
    }

    public void setModel(ComboBoxModel model) {
        if (model == null) {
            model = new DefaultComboBoxModel<String>();
        }
        Object sel = this.clearWhenDisabled && !this.isEnabled() ? this.lastEnabledSelection : this.getSelectedItem();
        int modelSize = model.getSize();
        int selIndex = -1;
        int i2 = 0;
        while (i2 < modelSize) {
            Object item = model.getElementAt(i2);
            if (item == null) {
                if (model instanceof DefaultComboBoxModel) {
                    UIUtils.debugImplementationError("Replacing 'null' element found at index " + i2);
                    model.removeElementAt(i2);
                    model.insertElementAt("", i2);
                } else {
                    UIUtils.debugImplementationError("'null' element found at index " + i2);
                }
            } else if (item.equals(sel)) {
                selIndex = i2;
            }
            ++i2;
        }
        boolean wasEnabled = this._disableUpdate();
        this.comboModel = model;
        this.comboBox.setModel(this.comboModel);
        this._enableUpdate(wasEnabled);
        if (this.clearWhenDisabled && !this.isEnabled()) {
            this.lastEnabledSelection = selIndex >= 0 ? sel : (modelSize > 0 ? this.getItemAt(0) : null);
            this._setSelectedIndex(-1);
        } else if (selIndex >= 0) {
            this._setSelectedIndex(selIndex);
        } else if (modelSize > 0) {
            this._setSelectedIndex(0);
        } else {
            this._setSelectedIndex(-1);
        }
    }

    public void setModel(DefaultComboBoxModel model) {
        this.setModel((ComboBoxModel)model);
    }

    public void setModel(Object[] items) {
        DefaultComboBoxModel<Object> model = items != null ? new DefaultComboBoxModel<Object>(items) : null;
        this.setModel((ComboBoxModel)model);
    }

    public void setModel(Vector items) {
        DefaultComboBoxModel model = items != null ? new DefaultComboBoxModel(items) : null;
        this.setModel((ComboBoxModel)model);
    }

    public void setModel(Collection items) {
        DefaultComboBoxModel model = null;
        if (items != null) {
            Vector v2 = new Vector();
            Iterator i2 = items.iterator();
            while (i2.hasNext()) {
                v2.add(i2.next());
            }
            model = new DefaultComboBoxModel(v2);
        }
        this.setModel((ComboBoxModel)model);
    }

    public int getItemCount() {
        return this.comboBox.getItemCount();
    }

    public Object getItemAt(int ndx) {
        return this.comboBox.getItemAt(ndx);
    }

    public void setShowSelectionAsToolTip(boolean state) {
        this.showSelectionAsToolTip = state;
    }

    public boolean getShowSelectionAsToolTip() {
        return this.showSelectionAsToolTip;
    }

    private void _resetSelectionToolTip() {
        if (this.showSelectionAsToolTip) {
            String tt = this.isEditable() ? null : this._getSelectedString();
            this.comboBox.setToolTipText(tt);
        }
    }

    public void setShowWidePopups(boolean state) {
        this.showWidePopups = state;
        this.comboBox.updateUI();
    }

    public boolean getShowWidePopups() {
        return this.showWidePopups;
    }

    public void clearSelection() {
        this.lastEnabledSelection = null;
        this._setSelectedIndex(-1);
    }

    public void setSelectedItem(Object item) {
        if (this.clearWhenDisabled && !this.isEnabled()) {
            this.lastEnabledSelection = item;
            this._setSelectedIndex(-1);
        } else if (item == null) {
            this._setSelectedIndex(-1);
        } else {
            this._setSelectedItem(item);
        }
    }

    private void _setSelectedItem(Object item) {
        boolean wasEnabled = this._disableUpdate();
        this.comboBox.setSelectedItem(item);
        this._resetSelectionToolTip();
        this._enableComponentsForSelection();
        this._enableUpdate(wasEnabled);
    }

    public Object getSelectedItem() {
        if (this.clearWhenDisabled && !this.isEnabled()) {
            UIUtils.debugImplementationError("Getting selected item when disabled?");
            return this.lastEnabledSelection;
        }
        return this.comboBox.getSelectedItem();
    }

    private String _getSelectedString() {
        Object sel = this.getSelectedItem();
        return sel == null ? null : sel.toString();
    }

    public Object[] getSelectedObjects() {
        return this.comboBox.getSelectedObjects();
    }

    public void setSelectedIndex(int index) {
        if (this.clearWhenDisabled && !this.isEnabled()) {
            this.lastEnabledSelection = index >= 0 ? this.comboBox.getItemAt(index) : null;
            this._setSelectedIndex(-1);
        } else {
            this._setSelectedIndex(index);
        }
    }

    private void _setSelectedIndex(int index) {
        JTextField tf;
        boolean wasEnabled = this._disableUpdate();
        this.comboBox.setSelectedIndex(index);
        if (index < 0 && this.isEditable() && (tf = this.getEditorTextField()) != null) {
            tf.setText("");
        }
        this._resetSelectionToolTip();
        this._enableComponentsForSelection();
        this._enableUpdate(wasEnabled);
    }

    public int getSelectedIndex() {
        return this.comboBox.getSelectedIndex();
    }

    public boolean isSelectedItem(Object item) {
        Object selObj = this.getSelectedItem();
        return selObj != null && item.equals(selObj);
    }

    private boolean _disableUpdate() {
        this.setUpdateReason("SetSelect");
        boolean wasEnabled = this.isUpdateEnabled;
        this.isUpdateEnabled = false;
        return wasEnabled;
    }

    private void _enableUpdate(boolean wasEnabled) {
        this.isUpdateEnabled = wasEnabled;
        this.setUpdateReason(null);
    }

    public JTextField getEditorTextField() {
        if (this.isEditable()) {
            ComboBoxEditor editor = this.comboBox.getEditor();
            Component comp = editor.getEditorComponent();
            if (comp instanceof JTextField) {
                return (JTextField)comp;
            }
            UIUtils.printImplementationError("Editor component is not a JTextField");
        }
        return null;
    }

    public String getText() {
        if (this.clearWhenDisabled && !this.isEnabled()) {
            UIUtils.debugImplementationError("Getting selected item when disabled?");
            return this.lastEnabledSelection != null ? this.lastEnabledSelection.toString() : "";
        }
        if (this.isEditable()) {
            String text;
            JTextField tf = this.getEditorTextField();
            String string = text = tf != null ? tf.getText() : "";
            if (UIUtils.debugMode()) {
                String selText;
                Object sel = this.getSelectedItem();
                String string2 = selText = sel != null ? sel.toString() : "";
                if (!text.equals(selText)) {
                    UIUtils.debugPrintln("text(" + text + ") != selection(" + selText + ")");
                }
            }
            return text;
        }
        Object sel = this.getSelectedItem();
        return sel == null ? "" : sel.toString();
    }

    public void setText(String text) {
        if (this.clearWhenDisabled && !this.isEnabled()) {
            this.lastEnabledSelection = text;
            this._setSelectedIndex(-1);
        } else if (this.isEditable()) {
            this._setSelectedItem(text);
        } else if (text == null) {
            this._setSelectedIndex(-1);
        } else {
            this._setSelectedItem(text);
        }
    }

    public void setIntValue(int val) {
        this.setText(String.valueOf(val));
    }

    /*
     * Unable to fully structure code
     */
    public int getIntValue(int defaultValue) {
        num = this.getText();
        try {
            return Integer.parseInt(this.getText());
        }
        catch (NumberFormatException nfe) {
            if (num.equals("")) {
                return defaultValue;
            }
            len = num.length();
            p = num.charAt(0) == '-' ? 1 : 0;
            ** while (p < len && Character.isDigit((char)num.charAt((int)p)))
        }
lbl-1000:
        // 1 sources

        {
            ++p;
            continue;
        }
lbl12:
        // 1 sources

        try {
            return Integer.parseInt(num.substring(0, p));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public void addItemListener(ItemListener listener) {
        this.comboBox.addItemListener(listener);
    }

    public void removeItemListener(ItemListener listener) {
        this.comboBox.removeItemListener(listener);
    }

    public void setReadOnly(boolean state) {
        this.comboBox.setEnabled(this.isEnabled() && !state);
        super.setReadOnly(state);
    }

    protected void _setReadOnly(boolean state) {
        super.setReadOnly(state);
    }

    public void setEnabled(boolean state) {
        boolean oldState = this.isEnabled();
        if (this.clearWhenDisabled) {
            if (!state && oldState) {
                if (this.lastEnabledSelection == null) {
                    this.lastEnabledSelection = this.isEditable() ? this.getText() : this.getSelectedItem();
                }
                this._setSelectedIndex(-1);
            } else if (state && !oldState && this.lastEnabledSelection != null) {
                this._setSelectedItem(this.lastEnabledSelection);
                this.lastEnabledSelection = null;
            }
        }
        this.comboBox.setEnabled(state && !this.isReadOnly());
        super.setEnabled(state);
    }

    protected void _setEnabled(boolean state) {
        super.setEnabled(state);
    }

    protected void setChildEnabled(Component child, boolean state) {
        child.setEnabled(state ? this._canEnableChild(child) : false);
    }

    protected boolean _canEnableChild(Component comp) {
        if (this.selectionEnabler == null) {
            return true;
        }
        Object val = this.selectionEnabler.get(comp);
        if (val == null) {
            return true;
        }
        Object selItem = this.getSelectedItem();
        if (selItem == null) {
            return false;
        }
        return val.equals(selItem);
    }

    public void addSelectionEnabledComponent(Component comp, Object selItem) {
        Object item;
        if (this.selectionEnabler == null) {
            this.selectionEnabler = new Hashtable();
        }
        Object object = item = selItem == null || selItem.equals(LAST_ADDED_ITEM) ? this.lastAddedItem : selItem;
        if (item != null) {
            this.selectionEnabler.put(comp, item);
            comp.setEnabled(this.isSelectedItem(item));
        } else {
            UIUtils.printImplementationError("Attempting to add 'null' item");
        }
    }

    protected void _enableComponentsForSelection() {
        if (this.selectionEnabler == null) {
            return;
        }
        Object selItem = this.getSelectedItem();
        Enumeration keys = this.selectionEnabler.keys();
        while (keys.hasMoreElements()) {
            Component comp = (Component)keys.nextElement();
            Object val = this.selectionEnabler.get(comp);
            comp.setEnabled(val.equals(selItem));
        }
    }

    public String toString() {
        return this.comboBox.toString();
    }

    private static class PrivateComboBoxUI
    extends MetalComboBoxUI {
        private PrivateComboBoxUI() {
        }

        public static ComponentUI createUI(JComponent c10) {
            return new PrivateComboBoxUI();
        }

        protected ComboPopup createPopup() {
            PrivateComboPopup pu = new PrivateComboPopup(this.comboBox);
            ((JPopupMenu)pu).getAccessibleContext().setAccessibleParent(this.comboBox);
            return pu;
        }

        public void setPopupVisible(JComboBox c10, boolean v2) {
            super.setPopupVisible(c10, v2);
        }

        private class PrivateComboPopup
        extends MetalComboBoxUI.MetalComboPopup {
            PrivateComboBox pcb = null;

            public PrivateComboPopup(JComboBox combo) {
                super(PrivateComboBoxUI.this, combo);
                this.pcb = (PrivateComboBox)combo;
            }

            public void show() {
                ++this.pcb.showingPopup;
                super.show();
                --this.pcb.showingPopup;
            }
        }
    }

    private class PrivateComboBox
    extends JComboBox
    implements ItemListener {
        private Color savedBackground = null;
        private Color savedEditorBackground = null;
        private UITitledComboBox titledComboBox = null;
        public int showingPopup = 0;

        public PrivateComboBox(UITitledComboBox tcb) {
            if (!didResetComboBoxColors) {
                Color c10 = UIManager.getColor("ComboBox.disabledForeground");
                if (!c10.equals(UITitledBox.DisabledTextColor)) {
                    UIManager.put("ComboBox.disabledForeground", UITitledBox.DisabledTextColor);
                }
                didResetComboBoxColors = true;
            }
            this.savedBackground = this.getBackground();
            this.titledComboBox = tcb;
            this.addItemListener(this);
        }

        public void updateUI() {
            boolean swp;
            boolean bl2 = swp = this.titledComboBox == null ? false : this.titledComboBox.getShowWidePopups();
            if (swp) {
                this.setUI(PrivateComboBoxUI.createUI(this));
            } else {
                super.updateUI();
            }
        }

        public Dimension getSize() {
            if (this.showingPopup > 0) {
                Dimension d10 = new Dimension(super.getSize());
                d10.width = Math.max(d10.width, this.getPreferredPopupWidth());
                return d10;
            }
            return super.getSize();
        }

        public void setEnabled(boolean state) {
            Component c10;
            super.setEnabled(state);
            this.setBackground(state ? this.savedBackground : UITitledBox.DisabledBackgroundColor);
            if (this.isEditable() && this.getEditor() != null && (c10 = this.getEditor().getEditorComponent()) instanceof JTextComponent) {
                JTextComponent tc = (JTextComponent)c10;
                if (this.savedEditorBackground == null) {
                    this.savedEditorBackground = tc.getBackground();
                }
                tc.setBackground(state ? this.savedEditorBackground : UITitledBox.DisabledBackgroundColor);
            }
        }

        public void itemStateChanged(ItemEvent ie) {
            if (ie.getStateChange() == 1) {
                UITitledComboBox.this._enableComponentsForSelection();
            }
        }

        public int getPreferredPopupWidth() {
            JList list = this.getJList();
            if (list != null) {
                ListCellRenderer rend = list.getCellRenderer();
                ComboBoxModel model = this.getModel();
                int rows = this.getModel().getSize();
                int width = 0;
                int r2 = 0;
                while (r2 < rows) {
                    Object item = model.getElementAt(r2);
                    Component c10 = rend.getListCellRendererComponent(list, item, r2, false, false);
                    width = Math.max(width, c10.getPreferredSize().width);
                    ++r2;
                }
                return width;
            }
            return -1;
        }

        private JList getJList() {
            Accessible a = this.getUI().getAccessibleChild(this, 0);
            return a instanceof ComboPopup ? ((ComboPopup)((Object)a)).getList() : null;
        }

        public void setUpdateReason(String reason) {
            UITitledComboBox.this.setUpdateReason(reason);
        }
    }
}

