/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledList;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class UITitledCheckBoxList
extends UITitledList {
    private Object selectedCheckBoxData = null;
    private boolean selectedCheckBoxState = false;

    public UITitledCheckBoxList(String title, boolean showBorder) {
        super(title, showBorder);
        super.setListView(this.createDefaultListView());
    }

    protected JList createDefaultListView() {
        JList list = super.createDefaultListView();
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e10) {
                JList srcList = (JList)e10.getSource();
                int row = srcList.locationToIndex(e10.getPoint());
                if (row >= 0) {
                    ListJCheckBox cb2 = (ListJCheckBox)srcList.getModel().getElementAt(row);
                    boolean toggle = !cb2.isSelected();
                    cb2.setSelected(toggle);
                    UITitledCheckBoxList.this.selectedCheckBoxState = toggle;
                    UITitledCheckBoxList.this.selectedCheckBoxData = cb2.getData();
                    UITitledCheckBoxList.this.updateComponent(UITitledCheckBoxList.this);
                    srcList.repaint();
                }
            }
        });
        list.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return (ListJCheckBox)value;
            }
        });
        return list;
    }

    public Object getSelectedCheckBoxData() {
        return this.selectedCheckBoxData;
    }

    public boolean getSelectedCheckBoxState() {
        return this.selectedCheckBoxState;
    }

    public void setListView(JList list) {
        UIUtils.printImplementationError("This method should not be invoked");
        if (this.getView() == null) {
            super.setListView(this.createDefaultListView());
        }
    }

    private DefaultListModel getDefaultListModel() {
        return (DefaultListModel)this.getListView().getModel();
    }

    public void setToolTipText(String toolTip) {
        this.getListView().setToolTipText(toolTip);
    }

    public void clearList() {
        this.getDefaultListModel().clear();
    }

    public void addCheckBoxData(String title, boolean state, Object data) {
        ListJCheckBox cb2 = new ListJCheckBox(title, data, state);
        this.getDefaultListModel().addElement(cb2);
    }

    private static class ListJCheckBox
    extends JPanel {
        private static Color background = Color.white;
        private static Color foreground = Color.black;
        private Object data = null;
        private JCheckBox checkBox = new JCheckBox();

        private ListJCheckBox() {
            super(new GridBagLayout());
            GridBagConstraints c10 = new GridBagConstraints();
            this.setOpaque(true);
            this.setBackground(background);
            this.checkBox = new JCheckBox();
            this.checkBox.setOpaque(true);
            this.checkBox.setBackground(background);
            this.checkBox.setForeground(foreground);
            c10.weightx = 0.5;
            c10.weighty = 0.0;
            c10.gridx = 0;
            c10.gridy = 0;
            c10.gridwidth = 1;
            c10.gridheight = 1;
            c10.insets = new Insets(0, 5, 0, 0);
            c10.fill = 2;
            c10.anchor = 17;
            this.add((Component)this.checkBox, c10);
        }

        public ListJCheckBox(String title, Object data, boolean state) {
            this();
            this.data = data;
            this.checkBox.setText(title);
            this.checkBox.setSelected(state);
        }

        public boolean isSelected() {
            return this.checkBox.isSelected();
        }

        public void setSelected(boolean state) {
            this.checkBox.setSelected(state);
        }

        public Object getData() {
            return this.data;
        }
    }
}

