/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIActionDispatcher;
import com.sun.enterprise.tools.deployment.ui.utils.UIComponentUpdateHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class UITitledBox
extends JPanel {
    public static final Color DisabledBackgroundColor = Color.lightGray;
    public static final Color EnabledBackgroundColor = Color.white;
    public static final Color DisabledTextColor = Color.darkGray;
    public static final Border DefaultTextBorder = null;
    private static Color defaultTitleColor = new TitledBorder("x").getTitleColor();
    public static final String UPDATE_REASON_UNKNOWN = "unknown";
    public static final String UPDATE_REASON_SET_SELECTION = "SetSelect";
    public static final String UPDATE_REASON_ENABLED = "Enabled";
    private static boolean suspendAllUpdates = false;
    private GridBagLayout gbLayout = null;
    private GridBagConstraints gbConst = null;
    private boolean hasTitle = false;
    private boolean hasVisibleBorder = false;
    private boolean hasLabeledTitle = true;
    protected boolean isReadOnly = false;
    protected boolean isEnabled = true;
    protected boolean clearWhenDisabled = false;
    protected boolean setEnableOnChildren = true;
    private Border border = null;
    private Color titleColor = null;
    private JPanel container = null;
    private _TitleLabel titleLabel = null;
    protected Vector updateHandlers = new Vector();
    protected boolean isUpdateEnabled = true;
    private String updateReason = "unknown";
    protected Dimension maxPreferredSize = null;
    protected Dimension minSize = null;
    protected String actionCommand = null;
    protected Vector validatorList = null;
    protected boolean validateOnUpdate = false;
    private int _TitleGridBagLayout_adjusting = 0;
    private int _getPreferredSize = 0;
    private JPopupMenu popupMenu = null;
    private int box_updateComponent_recurse = 0;
    private Object updateEventSource = null;
    private Runnable clearLastValidation = null;
    private int lastValidation = -1;

    public void setSuspendAllUpdates(boolean state) {
        suspendAllUpdates = state;
    }

    public UITitledBox(String title, boolean showBorder) {
        if (showBorder && title == null) {
            title = "";
        }
        if (title != null) {
            this.hasTitle = true;
            this.hasVisibleBorder = showBorder;
            if (showBorder) {
                this.border = new _TitleBorder(title);
                this.titleColor = ((_TitleBorder)this.border).getTitleColor();
            } else {
                this.titleLabel = new _TitleLabel(title);
                JPanel box = new JPanel();
                GridBagConstraints c10 = new GridBagConstraints();
                super.setLayout(new _TitleGridBagLayout());
                c10.weightx = 0.0;
                c10.weighty = 0.0;
                c10.gridx = 0;
                c10.gridy = -1;
                c10.insets = new Insets(0, 1, 0, 0);
                c10.fill = 0;
                c10.anchor = 18;
                this.add((Component)this.titleLabel, c10);
                c10.weightx = 0.5;
                c10.weighty = 0.5;
                c10.fill = 1;
                c10.anchor = 10;
                this.add((Component)box, c10);
                this.container = box;
                this.border = new EmptyBorder(0, 0, 0, 0);
                this.titleColor = this.titleLabel.getForeground();
            }
        } else {
            this.border = new EmptyBorder(0, 0, 0, 0);
            this.titleColor = null;
        }
        this.setBorder(this.border);
        this.setLayout(this.getGBLayout());
        this.getGBConstraints();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent ce2) {
                UITitledBox.this.componentResized(ce2);
            }
        });
    }

    public boolean hasTitle() {
        return this.hasTitle;
    }

    public boolean hasVisibleBorder() {
        return this.hasVisibleBorder;
    }

    public boolean hasLabeledTitle() {
        return this.hasLabeledTitle;
    }

    public void setLayout(LayoutManager mgr) {
        if (this.container != null) {
            this.container.setLayout(mgr);
        } else {
            super.setLayout(mgr);
        }
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp == null) {
            UIUtils.printImplementationError("Attempting to add 'null' component");
            return;
        }
        if (this.setEnableOnChildren && comp instanceof UITitledBox) {
            comp.setEnabled(this.isEnabled());
        }
        if (this.container != null) {
            if (comp instanceof JTabbedPane) {
                try {
                    this.container.add(comp, constraints, index);
                }
                catch (Throwable t2) {
                    // empty catch block
                }
                this.container.remove(comp);
            }
            this.container.add(comp, constraints, index);
        } else {
            if (comp instanceof JTabbedPane) {
                try {
                    super.addImpl(comp, constraints, index);
                }
                catch (Throwable t3) {
                    // empty catch block
                }
                super.remove(comp);
            }
            super.addImpl(comp, constraints, index);
        }
    }

    public void setMaximumPreferredSize(Dimension d10) {
        this.maxPreferredSize = d10;
    }

    public Dimension getPreferredSize() {
        ++this._getPreferredSize;
        Dimension ps = super.getPreferredSize();
        if (this.maxPreferredSize != null) {
            if (this.maxPreferredSize.width > 0 && ps.width > this.maxPreferredSize.width) {
                ps.width = this.maxPreferredSize.width;
            }
            if (this.maxPreferredSize.height > 0 && ps.height > this.maxPreferredSize.height) {
                ps.height = this.maxPreferredSize.height;
            }
        }
        --this._getPreferredSize;
        return ps;
    }

    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            return super.getMinimumSize();
        }
        Dimension r2 = new Dimension(this.minSize);
        if (r2.width < 0 || r2.height < 0) {
            Dimension p2 = super.getPreferredSize();
            Dimension m2 = super.getMinimumSize();
            if (r2.width < 0) {
                int n2 = r2.width = m2.width > p2.width ? m2.width : p2.width;
            }
            if (r2.height < 0) {
                r2.height = m2.height > p2.height ? m2.height : p2.height;
            }
        }
        return r2;
    }

    public void setMinimumSize(Dimension d10) {
        this.minSize = new Dimension(d10);
    }

    public void setMinimumWidth(int width) {
        if (this.minSize == null) {
            this.minSize = new Dimension(width, -1);
        } else {
            this.minSize.width = width;
        }
    }

    public void setMinimumHeight(int height) {
        if (this.minSize == null) {
            this.minSize = new Dimension(-1, height);
        } else {
            this.minSize.height = height;
        }
    }

    public void setPreferredWidth(int width) {
        UITitledBox.setPreferredSize(this, width, -1);
    }

    public void setPreferredHeight(int height) {
        UITitledBox.setPreferredSize(this, -1, height);
    }

    public static void setPreferredSize(JComponent c10, int w2, int h2) {
        Dimension d10 = c10.getPreferredSize();
        if (w2 >= 0) {
            d10.width = w2;
        }
        if (h2 >= 0) {
            d10.height = h2;
        }
        c10.setPreferredSize(d10);
    }

    protected GridBagConstraints getDefaultGBConstraints(GridBagConstraints c10) {
        if (c10 == null) {
            c10 = new GridBagConstraints();
        }
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = -1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 0, 0, 0);
        c10.fill = 1;
        c10.anchor = 10;
        return c10;
    }

    public GridBagConstraints getGBConstraints() {
        if (this.gbConst == null) {
            this.gbConst = this.getDefaultGBConstraints(null);
        }
        return this.gbConst;
    }

    public GridBagConstraints getGBConstraintsCopy() {
        return (GridBagConstraints)this.getGBConstraints().clone();
    }

    public GridBagLayout getGBLayout() {
        if (this.gbLayout == null) {
            this.gbLayout = new _TitleGridBagLayout();
        }
        return this.gbLayout;
    }

    public void setGBConstraints(Component comp, GridBagConstraints constaints) {
        this.getGBLayout().setConstraints(comp, constaints);
    }

    public void setGBConstraints(Component comp) {
        this.setGBConstraints(comp, this.getGBConstraints());
    }

    public void addWithGBConstraints(Component comp) {
        this.add(comp, this.getGBConstraints());
    }

    protected Border getTextBorder() {
        int borderType = 0;
        switch (borderType) {
            case 1: {
                return BorderFactory.createLoweredBevelBorder();
            }
            case 2: {
                return BorderFactory.createBevelBorder(1, Color.gray, Color.lightGray, Color.gray, Color.darkGray);
            }
        }
        return null;
    }

    public boolean isEditable() {
        return !this.isReadOnly();
    }

    public void setEditable(boolean state) {
        this.setReadOnly(!state);
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean state) {
        this.isReadOnly = state;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean state) {
        if (this.isEnabled != state) {
            Color tc;
            this.isEnabled = state;
            Color color = tc = state ? this.titleColor : Color.gray;
            if (this.titleLabel != null) {
                this.titleLabel.setForeground(tc);
                this.titleLabel.setEnabled(state);
                this.repaint();
            } else if (this.border != null && this.border instanceof TitledBorder) {
                ((TitledBorder)this.border).setTitleColor(tc);
                this.repaint();
            }
            if (this.setEnableOnChildren) {
                this.setChildrenEnabled(state);
            }
        }
    }

    protected void setChildrenEnabled(boolean state) {
        Component[] c10 = this.getComponents();
        int i2 = 0;
        while (i2 < c10.length) {
            if (c10[i2] instanceof UITitledBox) {
                this.setChildEnabled(c10[i2], state);
            }
            ++i2;
        }
    }

    protected void setChildEnabled(Component child, boolean state) {
        child.setEnabled(state);
    }

    public void setClearWhenDisabled(boolean state) {
        this.clearWhenDisabled = state;
        if (!this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    public String getTitle() {
        if (this.titleLabel != null) {
            return this.titleLabel.getText();
        }
        if (this.border != null && this.border instanceof TitledBorder) {
            return ((TitledBorder)this.border).getTitle();
        }
        return null;
    }

    public void setTitle(String title) {
        if (this.hasTitle) {
            if (this.titleLabel != null) {
                this.titleLabel.setText(title);
            } else if (this.border != null && this.border instanceof TitledBorder) {
                ((TitledBorder)this.border).setTitle(title);
                this.repaint();
            }
        } else {
            UIUtils.printImplementationError("UITitledBox.setTitle", "This box has no provision for a title");
        }
    }

    public void componentResized(ComponentEvent ce2) {
    }

    public void setPopupMenu(JPopupMenu pmenu) {
        if (this.popupMenu == null) {
            this.popupMenu = pmenu;
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e10) {
                    if (e10.isPopupTrigger()) {
                        UITitledBox.this.popupMenu.show(e10.getComponent(), e10.getX(), e10.getY());
                    }
                }

                public void mouseReleased(MouseEvent e10) {
                    if (e10.isPopupTrigger()) {
                        UITitledBox.this.popupMenu.show(e10.getComponent(), e10.getX(), e10.getY());
                    }
                }
            });
        } else {
            UIUtils.printImplementationError("Only one popup menu is allowed");
        }
    }

    protected void setUpdateReason(String reason) {
        this.updateReason = reason != null ? reason : UPDATE_REASON_UNKNOWN;
    }

    public String getUpdateReason() {
        return this.updateReason;
    }

    public boolean isUnknownSelectionUpdate() {
        return this.getUpdateReason().equals(UPDATE_REASON_UNKNOWN);
    }

    public boolean isSetSelectionUpdate() {
        return this.getUpdateReason().equals(UPDATE_REASON_SET_SELECTION);
    }

    public void addActionListener(ActionListener target) {
        this.addUpdateHandler(target);
    }

    public void addUpdateHandler(ActionListener target) {
        this.updateHandlers.add(target);
    }

    public void addUpdateHandler(UIComponentUpdateHandler target) {
        this.updateHandlers.add(target);
    }

    public void addUpdateHandler(Object target, String methName) {
        Method method = null;
        Object[] args = null;
        try {
            args = new Object[]{this};
            method = UIActionDispatcher.getTargetMethod(target, methName, args);
        }
        catch (Throwable x2) {
            method = null;
        }
        if (method == null) {
            try {
                args = new Object[]{};
                method = UIActionDispatcher.getTargetMethod(target, methName, null);
            }
            catch (Throwable x3) {
                UIActionDispatcher.printInvocationError(x3, target, methName, new Class[0], "Method not found");
                return;
            }
        }
        this.updateHandlers.add(new UIActionDispatcher(target, method, args));
    }

    public void removeActionListener(ActionListener target) {
        this.removeUpdateHandler(target);
    }

    public void removeUpdateHandler(ActionListener target) {
        this.updateHandlers.remove(target);
    }

    public void removeUpdateHandler(UIComponentUpdateHandler target) {
        this.updateHandlers.remove(target);
    }

    public void removeAllUpdateHandlers() {
        this.updateHandlers.removeAllElements();
    }

    protected void updateComponent(Object source) {
        boolean isValid;
        if (this.box_updateComponent_recurse > 0) {
            return;
        }
        ++this.box_updateComponent_recurse;
        boolean bl2 = isValid = this.validateOnUpdate ? this._performValidation() : true;
        if (isValid && this.isUpdateEnabled && !suspendAllUpdates) {
            this.updateEventSource = source;
            ActionEvent actionEvent = new ActionEvent(this, 1001, this.getActionCommand());
            Enumeration e10 = this.updateHandlers.elements();
            while (e10.hasMoreElements()) {
                Object target = e10.nextElement();
                if (target instanceof UIComponentUpdateHandler) {
                    ((UIComponentUpdateHandler)target).updateComponent(this);
                    continue;
                }
                if (target instanceof UIActionDispatcher) {
                    ((UIActionDispatcher)target).invoke();
                    continue;
                }
                if (target instanceof ActionListener) {
                    ((ActionListener)target).actionPerformed(actionEvent);
                    continue;
                }
                UIUtils.printImplementationError("UITitledBox.updateComponent", "Unsupported target object: " + target.getClass().getName());
            }
        }
        --this.box_updateComponent_recurse;
    }

    protected void updateComponent() {
        this.updateComponent(null);
    }

    public Object getUpdateEventSource() {
        return this.updateEventSource;
    }

    public void addValidator(Validator v2) {
        if (this.validatorList == null) {
            this.validatorList = new Vector();
        }
        if (!this.validatorList.contains(v2)) {
            this.validatorList.add(v2);
        }
    }

    public void removeValidator(Validator v2) {
        this.validatorList.remove(v2);
    }

    public void setValidateOnUpdate(boolean f2) {
        this.validateOnUpdate = f2;
    }

    public boolean performValidation() {
        boolean isValid = true;
        if (this.validatorList != null) {
            Enumeration e10 = this.validatorList.elements();
            while (e10.hasMoreElements()) {
                Validator v2 = (Validator)e10.nextElement();
                if (v2.performValidation(this)) continue;
                isValid = false;
                break;
            }
        }
        return isValid;
    }

    protected boolean _performValidation() {
        if (this.lastValidation < 0) {
            int n2 = this.lastValidation = this.performValidation() ? 1 : 0;
            if (this.clearLastValidation == null) {
                this.clearLastValidation = new Runnable(){

                    public void run() {
                        UITitledBox.this.lastValidation = -1;
                    }
                };
            }
            EventQueue.invokeLater(this.clearLastValidation);
        }
        return this.lastValidation == 1;
    }

    public void setKeyAction(ActionListener al2, String cmd, KeyStroke ks) {
        this.getInputMap(1).put(ks, cmd);
        Action action = al2 instanceof Action ? (Action)al2 : new ActionWrapper(cmd, al2);
        this.getActionMap().put(cmd, action);
    }

    public void setEnterKeyAction(ActionListener al2) {
        KeyStroke ks = KeyStroke.getKeyStroke("ENTER");
        this.setKeyAction(al2, "VK_ENTER", ks);
    }

    public void setActionCommand(String cmd) {
        this.actionCommand = cmd;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void addXStretchy(GridBagConstraints gbc) {
        GridBagConstraints c10 = gbc != null ? (GridBagConstraints)gbc.clone() : this.getGBConstraintsCopy();
        c10.weightx = 0.5;
        c10.gridx = 0;
        c10.gridwidth = 1;
        c10.insets = new Insets(0, 0, 0, 0);
        c10.fill = 2;
        c10.anchor = 13;
        this.add((Component)new JPanel(), c10);
    }

    private class ActionWrapper
    extends AbstractAction {
        private ActionListener listener = null;

        public ActionWrapper(String cmd, ActionListener al2) {
            super(cmd);
            this.listener = al2;
        }

        public void actionPerformed(ActionEvent ae2) {
            this.listener.actionPerformed(ae2);
        }
    }

    private class _TitleBorder
    extends TitledBorder {
        public _TitleBorder(String title) {
            super(title);
        }

        public Insets getBorderInsets(Component c10) {
            return this.getBorderInsets(c10, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component c10, Insets bn2) {
            Insets insets = super.getBorderInsets(c10, bn2);
            insets.left += 3;
            insets.right += 3;
            insets.bottom += 3;
            return insets;
        }

        public Dimension getMinimumSize(Component c10) {
            Dimension d10 = super.getMinimumSize(c10);
            return d10;
        }
    }

    private class _TitleLabel
    extends JLabel {
        public _TitleLabel(String title) {
            super(title);
        }

        public Dimension getPreferredSize() {
            Dimension d10 = super.getPreferredSize();
            if (UITitledBox.this._TitleGridBagLayout_adjusting > 0) {
                d10.width = 1;
            }
            return d10;
        }

        public Dimension getMinimumSize() {
            Dimension d10 = super.getMinimumSize();
            if (UITitledBox.this._TitleGridBagLayout_adjusting > 0) {
                d10.width = 1;
            }
            return d10;
        }
    }

    private class _TitleGridBagLayout
    extends GridBagLayout {
        private _TitleGridBagLayout() {
        }

        public Dimension preferredLayoutSize(Container p2) {
            UITitledBox.this._TitleGridBagLayout_adjusting++;
            Dimension d10 = super.preferredLayoutSize(p2);
            UITitledBox.this._TitleGridBagLayout_adjusting--;
            return d10;
        }

        public Dimension minimumLayoutSize(Container p2) {
            UITitledBox.this._TitleGridBagLayout_adjusting++;
            Dimension d10 = super.minimumLayoutSize(p2);
            UITitledBox.this._TitleGridBagLayout_adjusting--;
            return d10;
        }
    }

    public static interface Validator {
        public boolean performValidation(UITitledBox var1);
    }
}

