/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.DeployToolActions;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.help.BadIDException;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;

public class UIHelpButton
extends UIButton {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$utils$UIHelpButton == null ? (class$com$sun$enterprise$tools$deployment$ui$utils$UIHelpButton = UIHelpButton.class$("com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton")) : class$com$sun$enterprise$tools$deployment$ui$utils$UIHelpButton);
    private static String HELP_TITLE = localStrings.getLocalString("ui.uihelpbutton.button_title", "Help...");
    private static String NULL_HELP = localStrings.getLocalString("ui.uihelpbutton.null_help", "Help has not been enabled for this button.");
    private String helpID = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$utils$UIHelpButton;

    private static String NO_HELP(String v0) {
        return localStrings.getLocalString("ui.uihelpbutton.no_help", "No help available at this time.\n[help-id ''{0}'']", new Object[]{v0});
    }

    private static String ERROR_HELP(String v0) {
        return localStrings.getLocalString("ui.uihelpbutton.error_getting_help", "Unable to obtain help at this time.\n[help-id ''{0}'']", new Object[]{v0});
    }

    public UIHelpButton() {
        super(HELP_TITLE, "help", null);
        this.setMnemonic('H');
    }

    public UIHelpButton(String helpID) {
        this();
        this.setHelpID(helpID);
    }

    public UIHelpButton(Component helpComp) {
        this(CSH.getHelpIDString((Component)helpComp));
    }

    public void setHelpID(String helpID) {
        if (helpID != null && !helpID.equals("")) {
            this.helpID = helpID;
            DeployToolActions.enableHelpOnButton(this, this.helpID);
            this.setEnabled(true);
        } else {
            this.helpID = null;
            this.setEnabled(false);
        }
    }

    public void setHelpID(Component helpComp) {
        this.setHelpID(CSH.getHelpIDString((Component)helpComp));
    }

    protected void fireActionPerformed(ActionEvent ae2) {
        if (this.helpID == null) {
            UIOptionPane.showWarningDialog(this, NULL_HELP);
            return;
        }
        try {
            HelpSet hs = this.getHelpBroker().getHelpSet();
            if (!hs.getCombinedMap().isValidID(this.helpID, hs)) {
                UIUtils.println("Help-ID '" + this.helpID + "' was not found.");
                UIOptionPane.showWarningDialog(this, UIHelpButton.NO_HELP(this.helpID));
                return;
            }
        }
        catch (Throwable t2) {
            UIUtils.printException("Error looking up help-id '" + this.helpID + "'.", t2);
            UIOptionPane.showWarningDialog(this, UIHelpButton.ERROR_HELP(this.helpID));
            return;
        }
        try {
            super.fireActionPerformed(ae2);
        }
        catch (BadIDException bie) {
            UIUtils.debugPrintln("[" + this.helpID + "] Help exception: " + bie.toString());
            UIOptionPane.showWarningDialog(this, UIHelpButton.NO_HELP(this.helpID));
        }
    }

    private HelpBroker getHelpBroker() {
        return DeployToolActions.getMainHelpBroker();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

