/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class UIClassPackage {
    private static final int MAGIC_NUMBER = -889275714;
    private int thisNameNdx = -1;
    private int suprNameNdx = -1;
    private String packageName = null;
    private String className = null;
    private String superclassName = null;
    private ConstantPoolItem[] constantPool = null;
    private static final int CONST_Undefined = 0;
    private static final int CONST_Asciz = 1;
    private static final int CONST_Unicode = 2;
    private static final int CONST_Integer = 3;
    private static final int CONST_Float = 4;
    private static final int CONST_Long = 5;
    private static final int CONST_Double = 6;
    private static final int CONST_Class = 7;
    private static final int CONST_String = 8;
    private static final int CONST_Fieldref = 9;
    private static final int CONST_Methodref = 10;
    private static final int CONST_InterfaceMethodref = 11;
    private static final int CONST_NameandType = 12;

    public UIClassPackage(String classFileName) throws IOException, InvalidClassFileException {
        this._parseClassFile(new File(classFileName));
    }

    public UIClassPackage(File classFile) throws IOException, InvalidClassFileException {
        this._parseClassFile(classFile);
    }

    private void _parseClassFile(File classFile) throws IOException, InvalidClassFileException {
        DataInputStream dis = new DataInputStream(new FileInputStream(classFile));
        if (dis.readInt() != -889275714) {
            throw new InvalidClassFileException();
        }
        short majorVers = dis.readShort();
        short minorVers = dis.readShort();
        this.constantPool = this.decodeConstantPool(dis);
        short accessFlags = dis.readShort();
        this.thisNameNdx = dis.readShort() & 0xFFFF;
        if (this.thisNameNdx < 1 || this.thisNameNdx >= this.constantPool.length) {
            throw new InvalidClassFileException();
        }
        this.suprNameNdx = dis.readShort() & 0xFFFF;
        if (this.suprNameNdx < 1 || this.suprNameNdx >= this.constantPool.length) {
            throw new InvalidClassFileException();
        }
        dis.close();
    }

    public String getPackageName() {
        if (this.packageName == null) {
            String cn2 = this.getClassName();
            int dot = cn2.lastIndexOf(46);
            this.packageName = dot >= 0 ? cn2.substring(0, dot) : "";
        }
        return this.packageName;
    }

    public String getClassName() {
        if (this.className == null) {
            this.className = this.getConstantPoolEntry(this.thisNameNdx).toString().replace('/', '.');
        }
        return this.className;
    }

    public String getSuperclassName() {
        if (this.superclassName == null) {
            this.superclassName = this.getConstantPoolEntry(this.suprNameNdx).toString().replace('/', '.');
        }
        return this.superclassName;
    }

    private ConstantPoolItem getConstantPoolEntry(int ndx) {
        return ndx <= 0 || ndx >= this.constantPool.length ? this.constantPool[0] : this.constantPool[ndx];
    }

    private ConstantPoolItem[] decodeConstantPool(DataInputStream cfs) throws IOException {
        int cnt = cfs.readShort() & 0xFFFF;
        ConstantPoolItem[] _constantPool = new ConstantPoolItem[cnt];
        _constantPool[0] = new ConstantPoolItem();
        int n2 = 1;
        while (n2 < cnt) {
            _constantPool[n2] = new ConstantPoolItem(cfs);
            if (_constantPool[n2].poolType() == 5 || _constantPool[n2].poolType() == 6) {
                ++n2;
            }
            ++n2;
        }
        return _constantPool;
    }

    public static void main(String[] argv) {
        try {
            UIClassPackage cp2 = new UIClassPackage(argv[0]);
            System.out.println("Class      = " + cp2.getClassName());
            System.out.println("Superclass = " + cp2.getSuperclassName());
            System.out.println("Package    = " + cp2.getPackageName());
        }
        catch (Exception x2) {
            System.err.println("Exception: " + x2.toString());
            x2.printStackTrace();
        }
    }

    private class ConstantPoolItem {
        private Object _objValue = null;
        private int[] _index = new int[]{-1, -1};
        private int _poolType = 0;

        public ConstantPoolItem() {
        }

        public ConstantPoolItem(DataInputStream inStream) throws IOException {
            this.decodeStream(inStream);
        }

        private void decodeStream(DataInputStream cps) throws IOException {
            this._poolType = cps.readByte();
            switch (this._poolType) {
                case 1: 
                case 2: {
                    int len = cps.readShort() & 0xFFFF;
                    byte[] strBytes = new byte[len];
                    int i2 = 0;
                    while (i2 < len) {
                        strBytes[i2] = cps.readByte();
                        ++i2;
                    }
                    this._objValue = new String(strBytes);
                    break;
                }
                case 3: {
                    this._objValue = new Integer(cps.readInt());
                    break;
                }
                case 4: {
                    this._objValue = new Float(cps.readFloat());
                    break;
                }
                case 5: {
                    this._objValue = new Float(cps.readLong());
                    break;
                }
                case 6: {
                    this._objValue = new Double(cps.readDouble());
                    break;
                }
                case 7: {
                    this._index[0] = cps.readShort() & 0xFFFF;
                    break;
                }
                case 8: {
                    this._index[0] = cps.readShort() & 0xFFFF;
                    break;
                }
                case 9: {
                    this._index[0] = cps.readShort() & 0xFFFF;
                    this._index[1] = cps.readShort() & 0xFFFF;
                    break;
                }
                case 10: {
                    this._index[0] = cps.readShort() & 0xFFFF;
                    this._index[1] = cps.readShort() & 0xFFFF;
                    break;
                }
                case 11: {
                    this._index[0] = cps.readShort() & 0xFFFF;
                    this._index[1] = cps.readShort() & 0xFFFF;
                    break;
                }
                case 12: {
                    this._index[0] = cps.readShort() & 0xFFFF;
                    this._index[1] = cps.readShort() & 0xFFFF;
                    break;
                }
            }
        }

        public int poolType() {
            return this._poolType;
        }

        public Object toValue() {
            Object val = "?Unknown?";
            switch (this._poolType) {
                case 0: {
                    val = "**UNDEFINED**";
                    break;
                }
                case 1: {
                    val = this._objValue;
                    break;
                }
                case 2: {
                    val = this._objValue;
                    break;
                }
                case 3: {
                    val = this._objValue;
                    break;
                }
                case 4: {
                    val = this._objValue;
                    break;
                }
                case 5: {
                    val = this._objValue;
                    break;
                }
                case 6: {
                    val = this._objValue;
                    break;
                }
                case 7: {
                    val = UIClassPackage.this.getConstantPoolEntry(this._index[0]).toValue().toString();
                    break;
                }
                case 8: {
                    val = UIClassPackage.this.getConstantPoolEntry(this._index[0]).toValue();
                    break;
                }
                case 9: {
                    val = UIClassPackage.this.getConstantPoolEntry(this._index[0]).toValue().toString() + "." + UIClassPackage.this.getConstantPoolEntry(this._index[1]).toValue().toString();
                    break;
                }
                case 10: {
                    val = UIClassPackage.this.getConstantPoolEntry(this._index[0]).toValue().toString() + "." + UIClassPackage.this.getConstantPoolEntry(this._index[1]).toValue().toString();
                    break;
                }
                case 11: {
                    val = UIClassPackage.this.getConstantPoolEntry(this._index[0]).toValue().toString() + "." + UIClassPackage.this.getConstantPoolEntry(this._index[1]).toValue().toString();
                    break;
                }
                case 12: {
                    val = UIClassPackage.this.getConstantPoolEntry(this._index[0]).toValue().toString() + UIClassPackage.this.getConstantPoolEntry(this._index[1]).toValue().toString();
                }
            }
            return val;
        }

        public String toString() {
            return this.toValue().toString();
        }
    }

    public static class InvalidClassFileException
    extends Exception {
    }
}

