/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class UIButton
extends JButton {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$utils$UIButton == null ? (class$com$sun$enterprise$tools$deployment$ui$utils$UIButton = UIButton.class$("com.sun.enterprise.tools.deployment.ui.utils.UIButton")) : class$com$sun$enterprise$tools$deployment$ui$utils$UIButton);
    private static final String BTN_ADD = localStrings.getLocalString("ui.uibutton.add_button", "Add");
    private static final String BTN_ADD__ = localStrings.getLocalString("ui.uibutton.add_button_ellipsis", "Add...");
    private static final String BTN_DELETE = localStrings.getLocalString("ui.uibutton.delete_button", "Delete");
    private static final String BTN_DELETE__ = localStrings.getLocalString("ui.uibutton.delete_button_ellipsis", "Delete...");
    private static final String BTN_EDIT = localStrings.getLocalString("ui.uibutton.edit_button", "Edit");
    private static final String BTN_EDIT__ = localStrings.getLocalString("ui.uibutton.edit_button_ellipsis", "Edit...");
    private static final String BTN_REMOVE = localStrings.getLocalString("ui.uibutton.remove_button", "Remove");
    private static final String BTN_REMOVE__ = localStrings.getLocalString("ui.uibutton.remove_button_ellipsis", "Remove...");
    private static final String BTN_OK = localStrings.getLocalString("ui.uibutton.ok_button", "OK");
    private static final String BTN_APPLY = localStrings.getLocalString("ui.uibutton.apply_button", "Apply");
    private static final String BTN_CANCEL = localStrings.getLocalString("ui.uibutton.cancel_button", "Cancel");
    public static final int OK_BUTTON = 1;
    public static final int APPLY_BUTTON = 2;
    public static final int CANCEL_BUTTON = 3;
    public static final int HELP_BUTTON = 4;
    public static final int ADD_BUTTON = 5;
    public static final int DELETE_BUTTON = 6;
    public static final int REMOVE_BUTTON = 7;
    public static final int EDIT_BUTTON = 8;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$utils$UIButton;

    public static UIButton createAddButton(ActionListener al2) {
        return UIButton.createAddButton(al2, false);
    }

    public static UIButton createAddButton(ActionListener al2, boolean el2) {
        return UIButton.createButton(5, el2, "add", al2);
    }

    public static UIButton createDeleteButton(ActionListener al2) {
        return UIButton.createDeleteButton(al2, false);
    }

    public static UIButton createDeleteButton(ActionListener al2, boolean el2) {
        return UIButton.createButton(6, el2, "delete", al2);
    }

    public static UIButton createRemoveButton(ActionListener al2) {
        return UIButton.createRemoveButton(al2, false);
    }

    public static UIButton createRemoveButton(ActionListener al2, boolean el2) {
        return UIButton.createButton(7, el2, "remove", al2);
    }

    public static UIButton createEditButton(ActionListener al2) {
        return UIButton.createEditButton(al2, false);
    }

    public static UIButton createEditButton(ActionListener al2, boolean el2) {
        return UIButton.createButton(8, el2, "edit", al2);
    }

    public static UIButton createOkButton(ActionListener al2) {
        return UIButton.createButton(1, false, "ok", al2);
    }

    public static UIButton createApplyButton(ActionListener al2) {
        return UIButton.createButton(2, false, "apply", al2);
    }

    public static UIButton createCancelButton(ActionListener al2) {
        return UIButton.createButton(3, false, "cancel", al2);
    }

    public static UIButton createHelpButton(String helpId) {
        return UIButton.createButton(4, false, helpId, null);
    }

    private static UIButton createButton(int type, boolean ellipsis, String command, ActionListener listener) {
        if (type == 4) {
            UIUtils.debugPrintln("Please use 'new UIHelpButton(...)'");
            if (listener != null) {
                UIUtils.printImplementationError("ActionListener cannot be specified for 'Help' buttons");
            }
            if (command == null) {
                UIUtils.printImplementationError("Command(Help-id) must be specified for 'Help' buttons");
            }
            return new UIHelpButton(command);
        }
        String title = "Button";
        char mnemonic = '\u0000';
        switch (type) {
            case 1: {
                title = BTN_OK;
                mnemonic = title.charAt(0);
                break;
            }
            case 2: {
                title = BTN_APPLY;
                mnemonic = title.charAt(0);
                break;
            }
            case 3: {
                title = BTN_CANCEL;
                mnemonic = title.charAt(0);
                break;
            }
            case 5: {
                title = ellipsis ? BTN_ADD__ : BTN_ADD;
                mnemonic = title.charAt(0);
                break;
            }
            case 6: {
                title = ellipsis ? BTN_DELETE__ : BTN_DELETE;
                mnemonic = title.charAt(0);
                break;
            }
            case 8: {
                title = ellipsis ? BTN_EDIT__ : BTN_EDIT;
                mnemonic = title.charAt(0);
                break;
            }
            case 7: {
                title = ellipsis ? BTN_REMOVE__ : BTN_REMOVE;
                mnemonic = title.charAt(0);
                break;
            }
            default: {
                UIUtils.debugImplementationError("Unrecognized button type");
            }
        }
        UIButton btn = new UIButton(title, command, listener);
        btn.setMnemonic(mnemonic);
        return btn;
    }

    public static UIButton createButton(int type) {
        return UIButton.createButton(type, false, null, null);
    }

    public static UIButton createButton(int type, String command) {
        return UIButton.createButton(type, false, command, null);
    }

    public static UIButton createButton(int type, ActionListener al2) {
        return UIButton.createButton(type, false, null, al2);
    }

    public UIButton() {
    }

    public UIButton(String title) {
        super(title);
    }

    public UIButton(String title, String ac2, ActionListener al2) {
        super(title);
        if (ac2 != null) {
            this.setActionCommand(ac2);
        }
        if (al2 != null) {
            this.addActionListener(al2);
        }
    }

    public void makeDefaultButton(boolean state) {
        JRootPane root = SwingUtilities.getRootPane(this);
        if (root != null) {
            if (state) {
                root.setDefaultButton(this);
            } else if (root.getDefaultButton() == this) {
                root.setDefaultButton(null);
            } else {
                UIUtils.printImplementationError("This button is not the JRootPane default");
            }
        } else {
            UIUtils.printImplementationError("Button must first be added to a JRootPane");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

