/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ServletFilterDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptorImpl;
import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class WebServletFiltersInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebServletFiltersInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebServletFiltersInspector = WebServletFiltersInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebServletFiltersInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$WebServletFiltersInspector);
    private static final String FILTER_TABLE_TITLE = localStrings.getLocalString("ui.webservletfiltersinspector.filter_table_title", "Servlet Filters");
    private static final String FILTER_TABLE_CLASS = localStrings.getLocalString("ui.webservletfiltersinspector.column_filter_class", "Filter Class");
    private static final String FILTER_TABLE_DISPLAY = localStrings.getLocalString("ui.webservletfiltersinspector.column_display_name", "Display Name");
    private static final String INIT_TABLE_TITLE = localStrings.getLocalString("ui.webservletfiltersinspector.init_parm_title", "Initialization Parameters Referenced in Filter");
    private static final String INIT_TABLE_PARM = localStrings.getLocalString("ui.webservletfiltersinspector.init_parm.column_coded_parm", "Coded Parameter");
    private static final String INIT_TABLE_VALUE = localStrings.getLocalString("ui.webservletfiltersinspector.init_parm.column_value", "Value");
    private static final String TABNAME = localStrings.getLocalString("ui.webservletfiltersinspector.tabname", "Servlet Filters");
    private static String wizardHelpID = "ServletFilters";
    private static String deployHelpID = "ServletFilters";
    private WebBundleDescriptor descriptor = null;
    private UITitledTable servletTablePanel = null;
    private ServletFilterTable servletFilterTable = null;
    private ServletFilterTableModel servletFilterTableModel = null;
    private UITitledTable parametersPanel = null;
    private ParametersTable parametersTable = null;
    private ParametersTableModel parametersTableModel = null;
    private static final Class[] filterClasses = new Class[]{class$javax$servlet$Filter == null ? (class$javax$servlet$Filter = WebServletFiltersInspector.class$("javax.servlet.Filter")) : class$javax$servlet$Filter};
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebServletFiltersInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$WebBundleDescriptor;
    static /* synthetic */ Class class$javax$servlet$Filter;

    private static String INIT_TABLE_TITLE_FOR(String v0) {
        return localStrings.getLocalString("ui.webservletfiltersinspector.init_parm_title_for", "Initialization Parameters Referenced in Filter {0}", new Object[]{v0});
    }

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new WebServletFiltersInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isWizardMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$WebBundleDescriptor == null ? (class$com$sun$enterprise$deployment$WebBundleDescriptor = WebServletFiltersInspector.class$("com.sun.enterprise.deployment.WebBundleDescriptor")) : class$com$sun$enterprise$deployment$WebBundleDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebBundleDescriptor ? (WebBundleDescriptor)desc : (desc instanceof WebComponentDescriptorImpl ? ((WebComponentDescriptorImpl)desc).getWebBundleDescriptor() : null);
            this.servletFilterTable.clearTableData();
            this.parametersTable.clearTableData();
        }
    }

    private WebServletFiltersInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c10 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.servletTablePanel = new UITitledTable(FILTER_TABLE_TITLE, true);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.add((Component)this.servletTablePanel, c10);
        this.servletFilterTableModel = new ServletFilterTableModel();
        this.servletFilterTable = new ServletFilterTable(this.servletFilterTableModel);
        this.servletTablePanel.setTableView(this.servletFilterTable);
        this.servletFilterTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e10) {
                if (e10.getValueIsAdjusting()) {
                    return;
                }
                WebServletFiltersInspector.this.showInitParmRefs(WebServletFiltersInspector.this.getSelectedServletFilter());
            }
        });
        UIButton addFiltBtn = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebServletFiltersInspector.this.addFilterAction();
            }
        });
        this.servletTablePanel.addControlButton(addFiltBtn);
        UIButton delFiltBtn = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebServletFiltersInspector.this.deleteFilterAction();
            }
        }, true);
        this.servletTablePanel.addSelectionEnabledButton(delFiltBtn);
        this.parametersPanel = new UITitledTable(INIT_TABLE_TITLE, true);
        this.servletTablePanel.setAccessoryView(this.parametersPanel);
        this.servletTablePanel.addComponentToSelectionEnabledList(this.parametersPanel);
        this.parametersTableModel = new ParametersTableModel();
        this.parametersTable = new ParametersTable(this.parametersTableModel);
        this.parametersPanel.setTableView(this.parametersTable);
        UIButton addInitBtn = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebServletFiltersInspector.this.addInitAction();
            }
        });
        this.parametersPanel.addControlButton(addInitBtn);
        UIButton delInitBtn = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebServletFiltersInspector.this.deleteInitAction();
            }
        }, true);
        this.parametersPanel.addSelectionEnabledButton(delInitBtn);
    }

    public void refresh() {
        Vector filters = this.descriptor.getServletFilterDescriptors();
        this.servletFilterTable.updateTableData(filters);
        Vector v2 = this.getWARFilterInterfaceClasses();
        this.servletFilterTable.resetFilterClassEditor(v2);
        this.showInitParmRefs(this.getSelectedServletFilter());
    }

    private ServletFilterDescriptor getSelectedServletFilter() {
        return (ServletFilterDescriptor)this.servletFilterTable.getSelectedRowObject();
    }

    private void showInitParmRefs(ServletFilterDescriptor sfd) {
        if (sfd != null) {
            this.parametersTable.updateTableData(sfd.getInitializationParameters());
            this.parametersPanel.setTitle(WebServletFiltersInspector.INIT_TABLE_TITLE_FOR(sfd.getName()));
        } else {
            this.parametersTable.clearTableData();
            this.parametersPanel.setTitle(INIT_TABLE_TITLE);
        }
    }

    private Vector getWARFilterInterfaceClasses() {
        Vector fc2 = this.getArchiveClasses(filterClasses);
        Vector<String> v2 = new Vector<String>();
        if (fc2 != null) {
            Enumeration fe2 = fc2.elements();
            while (fe2.hasMoreElements()) {
                Object obj = fe2.nextElement();
                String className = obj instanceof Class ? ((Class)obj).getName() : obj.toString();
                v2.add(className);
            }
        } else {
            UIUtils.debugPrintln("Unabled to obtain a list of Filter classes");
        }
        return v2;
    }

    public ServletFilterDescriptor getServletFilterByName(String name) {
        Enumeration e10 = this.descriptor.getServletFilterDescriptors().elements();
        while (e10.hasMoreElements()) {
            ServletFilterDescriptor sfd = (ServletFilterDescriptor)e10.nextElement();
            if (!sfd.getClassName().equals(name)) continue;
            return sfd;
        }
        return null;
    }

    private void addFilterAction() {
        if (this.servletFilterTable.getRowWithValue(0, "") == null) {
            this.descriptor.addServletFilter(new ServletFilterDescriptor("", ""));
        }
        this.servletFilterTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteFilterAction() {
        Object[] list = this.servletFilterTable.confirmDeleteSelection(null, null);
        if (list != null) {
            int i2 = 0;
            while (i2 < list.length) {
                ServletFilterDescriptor ref = (ServletFilterDescriptor)list[i2];
                this.descriptor.removeServletFilter(ref);
                ++i2;
            }
            this.invokeRefresh();
        }
    }

    private void addInitAction() {
        ServletFilterDescriptor sfd = this.getSelectedServletFilter();
        if (sfd == null) {
            return;
        }
        if (this.parametersTable.getRowWithValue(0, "") == null) {
            sfd.addInitializationParameter(new EnvironmentProperty("", "", ""));
            this.descriptor.changed();
        }
        this.parametersTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteInitAction() {
        ServletFilterDescriptor sfd = this.getSelectedServletFilter();
        if (sfd == null) {
            return;
        }
        Object[] list = this.parametersTable.confirmDeleteSelection(null, null);
        if (list != null) {
            int i2 = 0;
            while (i2 < list.length) {
                EnvironmentProperty ref = (EnvironmentProperty)list[i2];
                sfd.removeInitializationParameter(ref);
                ++i2;
            }
            this.descriptor.changed();
        }
        this.invokeRefresh();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ParametersTableModel
    extends InspectorTableModel {
        public ParametersTableModel() {
            super(new String[]{INIT_TABLE_PARM, INIT_TABLE_VALUE, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public EnvironmentProperty getRow(int index) {
            return (EnvironmentProperty)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getName();
                    break;
                }
                case 1: {
                    value = ref.getValue();
                    break;
                }
                case 2: {
                    value = ref.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    ref.setName(value.toString());
                    break;
                }
                case 1: {
                    ref.setValue(value.toString());
                    break;
                }
                case 2: {
                    ref.setDescription(value.toString());
                }
            }
            WebServletFiltersInspector.this.descriptor.changed();
        }
    }

    private class ParametersTable
    extends InspectorTable {
        public ParametersTable(ParametersTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
        }
    }

    private class ServletFilterTableModel
    extends InspectorTableModel {
        public ServletFilterTableModel() {
            super(new String[]{FILTER_TABLE_CLASS, FILTER_TABLE_DISPLAY, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public ServletFilterDescriptor getRow(int index) {
            return (ServletFilterDescriptor)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            ServletFilterDescriptor ref = (ServletFilterDescriptor)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getClassName();
                    break;
                }
                case 1: {
                    value = ref.getDisplayName();
                    break;
                }
                case 2: {
                    value = ref.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            ServletFilterDescriptor ref = (ServletFilterDescriptor)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    String val = value.toString();
                    ref.setClassName(val);
                    break;
                }
                case 1: {
                    ref.setName(value.toString());
                    ref.setDisplayName(value.toString());
                    break;
                }
                case 2: {
                    ref.setDescription(value.toString());
                }
            }
        }
    }

    private class ServletFilterTable
    extends InspectorTable {
        public ServletFilterTable(ServletFilterTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
        }

        public void resetFilterClassEditor(Vector items) {
            JComboBox cb2 = new JComboBox(items);
            TableColumn col = this.getColumn(FILTER_TABLE_CLASS);
            col.setCellEditor(new DefaultCellEditor(cb2));
        }
    }
}

