/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.WebComponentDescriptorImpl;
import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class WebComponentParametersInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentParametersInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentParametersInspector = WebComponentParametersInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebComponentParametersInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentParametersInspector);
    private static final String TABLE_TITLE = localStrings.getLocalString("ui.webcomponentparametersinspector.inzparm_title", "Initialization Parameters Referenced in Code");
    private static final String TABLE_TOOLTIP = localStrings.getLocalString("ui.webcomponentparametersinspector.inzparm_tooltip", "Table of parameters");
    private static final String TABLE_INIT_PARM = localStrings.getLocalString("ui.webcomponentparametersinspector.inzparm_name", "Coded Parameter");
    private static final String TABLE_VALUE = localStrings.getLocalString("ui.webcomponentparametersinspector.inzparm_value", "Value");
    private static String TABNAME = localStrings.getLocalString("ui.webcomponentparametersinspector.tabname", "Init.Parameters");
    private static String wizardHelpID = "InitParam";
    private static String deployHelpID = "Params";
    private WebComponentDescriptorImpl descriptor = null;
    private ParametersTable parametersTable = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentParametersInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$WebComponentDescriptorImpl;

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new WebComponentParametersInspector();
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$WebComponentDescriptorImpl == null ? (class$com$sun$enterprise$deployment$WebComponentDescriptorImpl = WebComponentParametersInspector.class$("com.sun.enterprise.deployment.WebComponentDescriptorImpl")) : class$com$sun$enterprise$deployment$WebComponentDescriptorImpl;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebComponentDescriptorImpl ? (WebComponentDescriptorImpl)desc : null;
            this.parametersTable.clearTableData();
        }
    }

    private WebComponentParametersInspector() {
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c10 = new GridBagConstraints();
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        UITitledTable initParmsPanel = new UITitledTable(TABLE_TITLE, true);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        gb1.setConstraints(initParmsPanel, c10);
        this.add(initParmsPanel);
        this.parametersTable = new ParametersTable(new ParametersTableModel());
        initParmsPanel.getGBConstraints().weighty = 0.85;
        initParmsPanel.setTableView(this.parametersTable);
        UIButton btnAdd = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                WebComponentParametersInspector.this.addAction();
            }
        });
        initParmsPanel.addControlButton(btnAdd);
        UIButton btnDelete = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebComponentParametersInspector.this.deleteAction();
            }
        }, true);
        initParmsPanel.addSelectionEnabledButton(btnDelete);
    }

    public void refresh() {
        this.parametersTable.updateTableData(this.descriptor.getInitializationParameters());
    }

    private void addAction() {
        if (this.parametersTable.getRowWithValue(0, "") == null) {
            this.descriptor.addInitializationParameter(new EnvironmentProperty("", "", ""));
        }
        this.parametersTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteAction() {
        Object[] list = this.parametersTable.confirmDeleteSelection(null, null);
        if (list != null) {
            int i2 = 0;
            while (i2 < list.length) {
                EnvironmentProperty ref = (EnvironmentProperty)list[i2];
                this.descriptor.removeInitializationParameter(ref);
                ++i2;
            }
            this.invokeRefresh();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ParametersTableModel
    extends InspectorTableModel {
        public ParametersTableModel() {
            super(new String[]{TABLE_INIT_PARM, TABLE_VALUE, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public EnvironmentProperty getRow(int index) {
            return (EnvironmentProperty)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getName();
                    break;
                }
                case 1: {
                    value = ref.getValue();
                    break;
                }
                case 2: {
                    value = ref.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    ref.setName(value.toString());
                    break;
                }
                case 1: {
                    ref.setValue(value.toString());
                    break;
                }
                case 2: {
                    ref.setDescription(value.toString());
                }
            }
            ((Descriptor)WebComponentParametersInspector.this.descriptor).changed();
        }
    }

    private class ParametersTable
    extends InspectorTable {
        public ParametersTable(ParametersTableModel model) {
            super(model);
            this.setToolTipText(TABLE_TOOLTIP);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
        }
    }
}

