/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.Wizard;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;

public class RolesInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$RolesInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$RolesInspector = RolesInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.RolesInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$RolesInspector);
    private static final String DEFINED_ROLES = localStrings.getLocalString("ui.rolesinspector.defined_roles", "Defined Roles");
    private static final String ARCHIVE = localStrings.getLocalString("ui.rolesinspector.archive", "Archive");
    private static final String TABLE_NAME = localStrings.getLocalString("ui.rolesinspector.table.name", "Name");
    private static final String TABLE_DESCRIPTION = localStrings.getLocalString("ui.rolesinspector.table.description", "Description");
    private static final String TABNAME = localStrings.getLocalString("ui.rolesinspector.tabname", "Roles");
    private static String wizardHelpID = "Role";
    private static String deployHelpID = "Role";
    private Roles descriptor = null;
    private UITitledTextField archiveName = null;
    private RolesTable rolesTable = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$RolesInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Roles;

    private static String EDIT_ROLES_FOR(String v0) {
        return localStrings.getLocalString("ui.rolesinspector.edit_roles_for", "Edit Roles for {0}", new Object[]{v0});
    }

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new RolesInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$Roles == null ? (class$com$sun$enterprise$deployment$Roles = RolesInspector.class$("com.sun.enterprise.deployment.Roles")) : class$com$sun$enterprise$deployment$Roles;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)((Object)this.descriptor);
    }

    public void setDescriptor(Descriptor desc) {
        this.descriptor = desc instanceof Roles ? (Roles)((Object)desc) : null;
        this.rolesTable.clearTableData();
    }

    private RolesInspector(String mode) {
        this(mode, false);
    }

    private RolesInspector(String mode, boolean showArchive) {
        this.setInspectorMode(mode);
        this._initLayout(showArchive);
    }

    private void _initLayout(boolean showArchive) {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.gridx = 0;
        c10.gridy = 0;
        c10.weightx = 0.5;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        if (showArchive) {
            this.archiveName = new UITitledTextField(ARCHIVE, false);
            this.archiveName.setReadOnly(true);
            c10.weighty = 0.0;
            c10.fill = 2;
            this.add((Component)this.archiveName, c10);
            ++c10.gridy;
        }
        UITitledTable rolesPanel = new UITitledTable(DEFINED_ROLES, true);
        c10.weighty = 0.5;
        c10.fill = 1;
        this.add((Component)rolesPanel, c10);
        this.rolesTable = new RolesTable(new RolesTableModel(new HashSet()));
        rolesPanel.setTableView(this.rolesTable);
        UIButton addPB = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                RolesInspector.this.addRoleAction();
            }
        });
        rolesPanel.addControlButton(addPB);
        UIButton delPB = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                RolesInspector.this.deleteRoleAction();
            }
        }, true);
        rolesPanel.addSelectionEnabledButton(delPB);
    }

    public void refresh() {
        if (this.archiveName != null) {
            Descriptor d10 = this.getDescriptor();
            this.archiveName.setText(d10 != null ? d10.getName() : "");
        }
        if (this.descriptor != null) {
            this.rolesTable.updateTableData(this.descriptor.getRoles());
        } else {
            this.rolesTable.clearTableData();
        }
    }

    protected void addRoleAction() {
        if (this.rolesTable.getRowWithValue(0, "") == null) {
            this.descriptor.addRole(new Role(""));
        }
        this.rolesTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    protected void deleteRoleAction() {
        Object[] list = this.rolesTable.confirmDeleteSelection(null, null);
        if (list != null) {
            int i2 = 0;
            while (i2 < list.length) {
                Role ref = (Role)list[i2];
                this.descriptor.removeRole(ref);
                ++i2;
            }
        }
        this.invokeRefresh();
    }

    public static InspectorPane.InspectorPaneDialog createRolesInspectorDialog(InspectorPane.InspectorPaneOwner inspOwner, Component winOwner, boolean modal) {
        String mode = inspOwner instanceof Wizard ? "WizardMode" : "DeploymentMode";
        InspectorPane ri = RolesInspector.newInspectorPane(mode, null);
        InspectorPane.InspectorPaneDialog rolesDialog = ri.createInspectorPaneDialog(inspOwner, winOwner, true);
        rolesDialog.setLocationRelativeTo(winOwner);
        return rolesDialog;
    }

    protected InspectorPane.InspectorPaneDialog _createInspectorPaneDialog(Window win, InspectorPane.InspectorPaneOwner inspOwner, boolean modal) {
        if (win instanceof Frame) {
            return new RolesInspectorDialog((Frame)win, inspOwner, modal);
        }
        if (win instanceof Dialog) {
            return new RolesInspectorDialog((Dialog)win, inspOwner, modal);
        }
        return null;
    }

    public static void main(String[] args) {
        final RolesInspector ei2 = new RolesInspector("WizardMode");
        JFrame f2 = new JFrame();
        ((Component)f2).setBounds(10, 10, 300, 300);
        f2.getContentPane().add(ei2);
        f2.show();
        final EjbBundleDescriptor descriptor = new EjbBundleDescriptor();
        descriptor.addNotificationListener(new NotificationListener(){

            public void notification(NotificationEvent ne) {
                ei2.setDescriptor(descriptor);
            }
        });
        ei2.setDescriptor(descriptor);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TempRoles
    extends Descriptor
    implements Roles {
        private HashSet tempRoles = new HashSet();

        public TempRoles(Roles roles) {
            this.tempRoles.addAll(roles.getRoles());
        }

        public Set getRoles() {
            return this.tempRoles;
        }

        public void addRole(Role role) {
            this.tempRoles.remove(role);
            this.tempRoles.add(role);
            this.changed();
        }

        public void removeRole(Role role) {
            this.tempRoles.remove(role);
            this.changed();
        }
    }

    private class RolesInspectorDialog
    extends InspectorPane.InspectorPaneDialog {
        private Roles rolesDescriptor = null;
        private Roles tempRoles = null;

        public RolesInspectorDialog(Frame f2, InspectorPane.InspectorPaneOwner o2, boolean m2) {
            super((InspectorPane)RolesInspector.this, f2, o2, m2);
            super.setCancelEnabled(true);
        }

        public RolesInspectorDialog(Dialog d10, InspectorPane.InspectorPaneOwner o2, boolean m2) {
            super((InspectorPane)RolesInspector.this, d10, o2, m2);
            super.setCancelEnabled(true);
        }

        public void setDescriptor(Descriptor d10) {
            if (d10 instanceof Roles) {
                this.rolesDescriptor = (Roles)((Object)d10);
                this.tempRoles = new TempRoles(this.rolesDescriptor);
                super.setDescriptor((Descriptor)((Object)this.tempRoles));
                this.setTitle(RolesInspector.EDIT_ROLES_FOR(d10.getName()));
            } else {
                this.rolesDescriptor = null;
                this.tempRoles = null;
                super.setDescriptor(null);
                this.setTitle(RolesInspector.EDIT_ROLES_FOR(d10.getName()));
            }
        }

        public void okAction() {
            Iterator ri = null;
            ri = new HashSet(this.rolesDescriptor.getRoles()).iterator();
            while (ri.hasNext()) {
                this.rolesDescriptor.removeRole((Role)ri.next());
            }
            ri = this.tempRoles.getRoles().iterator();
            while (ri.hasNext()) {
                Role r2 = (Role)ri.next();
                if (r2.getName().equals("")) continue;
                this.rolesDescriptor.addRole(r2);
            }
            super.okAction();
        }
    }

    private class RolesTableModel
    extends InspectorTableModel {
        private boolean skipUpdate = false;

        public RolesTableModel(Set roleSet) {
            super(new ArrayList(roleSet), new String[]{TABLE_NAME, TABLE_DESCRIPTION}, 0);
            super.setCompareWithEquals(true);
            super.setDataOrdering(1);
        }

        public Role getRow(int index) {
            return (Role)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            Role role = (Role)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = role.getName();
                    break;
                }
                case 1: {
                    value = role.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            Role role = (Role)obj;
            if (role == null) {
                return;
            }
            switch (col) {
                case 0: {
                    Role newRole = new Role(value.toString());
                    if (role != null) {
                        newRole.setDescription(role.getDescription());
                        this.skipUpdate = true;
                        if (this.replaceRowObject(role, newRole) < 0) {
                            UIUtils.debugPrintln("RolesTableModel.setObjectValue", "Previous Role not found!");
                        }
                        RolesInspector.this.descriptor.removeRole(role);
                        this.skipUpdate = false;
                    }
                    RolesInspector.this.descriptor.addRole(newRole);
                    break;
                }
                case 1: {
                    role.setDescription(value.toString());
                }
            }
        }

        public void _updateTableData(Collection c10) {
            if (this.skipUpdate) {
                return;
            }
            List list = this.getData();
            synchronized (list) {
                if (c10 == null) {
                    try {
                        this.getData().clear();
                    }
                    catch (UnsupportedOperationException uso) {
                        // empty catch block
                    }
                }
                int i2 = 0;
                while (i2 < this.getRowCount()) {
                    Role r1 = this.getRow(i2);
                    int j2 = this.getRowCount() - 1;
                    while (j2 > i2) {
                        Role r2 = this.getRow(j2);
                        if (r1.getName().equals(r2.getName())) {
                            this.getData().remove(r2);
                        }
                        --j2;
                    }
                    ++i2;
                }
                Iterator i3 = this.getData().iterator();
                while (i3.hasNext()) {
                    if (c10 != null && c10.contains(i3.next())) continue;
                    i3.remove();
                }
                if (c10 != null) {
                    Iterator i4 = c10.iterator();
                    while (i4.hasNext()) {
                        this.addRowObject(i4.next());
                    }
                }
            }
            this.setMaximumEditableRowIndex(this.getRowCount() - 1);
            this.fireTableRowsInserted(0, this.getMaximumEditableRowIndex());
        }
    }

    private class RolesTable
    extends InspectorTable {
        public RolesTable(RolesTableModel model) {
            super(model);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
        }
    }
}

