/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.ejb.sqlgen.DBInfo;
import com.sun.ejb.sqlgen.SQLGenerator;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.DeploymentSettingsInspector;
import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.descriptor.FinderSelectDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextArea;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.ejb.EJBException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DeploymentSettingsDialog
extends UIDialog
implements DeploymentSettingsInspector.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$DeploymentSettingsDialog == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$DeploymentSettingsDialog = DeploymentSettingsDialog.class$("com.sun.enterprise.tools.deployment.ui.descriptor.DeploymentSettingsDialog")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$DeploymentSettingsDialog);
    private static final String DEPLOYMENT_SETTINGS = localStrings.getLocalString("ui.deploymentsettingsdialog.title", "Deployment Settings");
    private static final String DB_SETTINGS = localStrings.getLocalString("ui.deploymentsettingsdialog.db_settings", "Database settings...");
    private static final String DB_TABLE = localStrings.getLocalString("ui.deploymentsettingsdialog.db_table", "Database Table");
    private static final String CREATE_ON_DEPLOY = localStrings.getLocalString("ui.deploymentsettingsdialog.create_table_on_deploy", "Create table on deploy");
    private static final String DELETE_ON_UNDEPLOY = localStrings.getLocalString("ui.deploymentsettingsdialog.delete_table_on_undeploy", "Delete table on undeploy");
    private static final String METH_IMPL_QUERIES = localStrings.getLocalString("ui.deploymentsettingsdialog.method_impl_queries", "Method Implementation Queries");
    private static final String GENERATE_SQL = localStrings.getLocalString("ui.deploymentsettingsdialog.generate_default_sql", "Generate Default SQL...");
    private static final String SQL_QUERY = localStrings.getLocalString("ui.deploymentsettingsdialog.sqlquery", "SQL Query:");
    private static final String EJB_QL_QUERY = localStrings.getLocalString("ui.deploymentsettingsdialog.implementationquery", "EJB QL Query:");
    private static final String METHOD_TABLE_METHOD = localStrings.getLocalString("ui.deploymentsettingsdialog.methodtablemethod", "Method");
    private static final String SHOW_FINDERS = localStrings.getLocalString("ui.deploymentsettingsdialog.show_finders", "Show:");
    private static final String SHOW_LOCAL_FINDERS = localStrings.getLocalString("ui.deploymentsettingsdialog.show_local_finders", "Local Finders");
    private static final String SHOW_REMOTE_FINDERS = localStrings.getLocalString("ui.deploymentsettingsdialog.show_remote_finders", "Remote Finders");
    private static final String SHOW_SELECT_METHODS = localStrings.getLocalString("ui.deploymentsettingsdialog.show_select_methods", "Select Methods");
    private static final String SHOW_CONTAINER_METHODS = localStrings.getLocalString("ui.deploymentsettingsdialog.show_container_methods", "Container Methods");
    private static final String METHOD_FIND = "find";
    private static final String METHOD_EJB_SELECT = "ejbSelect";
    private static final String METHOD_FindBPK = "findByPrimaryKey";
    private static String helpSetMapID1 = "EntityDeploySettings";
    private static String helpSetMapID2 = "DepObjDeploySettings";
    private static Object[] FINDER_OPTIONS = new Object[]{SHOW_LOCAL_FINDERS, SHOW_REMOTE_FINDERS, SHOW_SELECT_METHODS, SHOW_CONTAINER_METHODS};
    private UIRadioButtonBox showFinders = null;
    private EjbDescriptor descriptor = null;
    private PersistenceDescriptor persDesc = null;
    private EjbBundleDescriptor ejbBundle = null;
    private boolean cmp2x = false;
    private UITitledBox dbTableBox = null;
    private DeploymentSettingsInspector.DialogDisplayButton databaseSettingsPB = null;
    private JCheckBox createTblOnDeployCB;
    private JCheckBox deleteTblOnUnDeployCB;
    private UIHelpButton helpPB;
    private JButton sqlgenPB;
    private UITitledTable sqlMethodsList;
    private MethodTable methodTable;
    private UITitledTextArea sqlStmtText = null;
    private UITitledTextArea ejbQLText = null;
    private UITitledControlButtonBox ejbQLBox = null;
    private FinderSelectDialog finderSelectDialog = null;
    private Hashtable tableDataCache = new Hashtable();
    private JButton cancelPB = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$DeploymentSettingsDialog;

    private static String ERROR_GETTING_QUERY_METHODS(String v0) {
        return localStrings.getLocalString("ui.deploymentsettingsdialog.error_getting_query_methods", "Error encountered while trying to obtain query methods\n {0}", new Object[]{v0});
    }

    private static String ERROR_MISSING_WHERE_CLAUSE(String v0) {
        return localStrings.getLocalString("ui.deploymentsettingsdialog.sql_missing_where_clause", "Warning: SQL for finder method {0} does not have a WHERE clause", new Object[]{v0});
    }

    public DeploymentSettingsDialog(Frame frame) {
        super(frame, true);
        this.initLayout();
    }

    private void initLayout() {
        this.setTitle(DEPLOYMENT_SETTINGS);
        this.doNothingOnClose();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                DeploymentSettingsDialog.this.cancelAction();
            }
        });
        this.setEnableBusyCursor(true);
        JPanel contentPane = new JPanel();
        contentPane.setToolTipText(DEPLOYMENT_SETTINGS);
        contentPane.setPreferredSize(new Dimension(580, 400));
        GridBagLayout gridbag = new GridBagLayout();
        contentPane.setLayout(gridbag);
        this.setContentPane(contentPane);
        GridBagConstraints c10 = new GridBagConstraints();
        UITitledControlButtonBox upperHalf = new UITitledControlButtonBox(null, false);
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = -1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 0);
        c10.fill = 2;
        c10.anchor = 11;
        contentPane.add((Component)upperHalf, c10);
        UITitledBox lowerHalf = new UITitledBox(null, false);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = -1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 5, 5, 5);
        c10.fill = 1;
        c10.anchor = 15;
        contentPane.add((Component)lowerHalf, c10);
        UITitledBox dbSettingsPane = new UITitledBox(null, false);
        upperHalf.setView(dbSettingsPane);
        UITitledBox dbSettingsLeft = new UITitledBox(null, false);
        GridBagConstraints gbc = dbSettingsPane.getGBConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.fill = 2;
        dbSettingsPane.add((Component)dbSettingsLeft, gbc);
        UITitledBox dbSettingsRight = new UITitledBox(null, false);
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.fill = 0;
        gbc.anchor = 15;
        dbSettingsPane.add((Component)dbSettingsRight, gbc);
        this.dbTableBox = new UITitledBox(DB_TABLE, true);
        gbc = dbSettingsLeft.getGBConstraintsCopy();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = -1;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.anchor = 15;
        dbSettingsLeft.add((Component)this.dbTableBox, gbc);
        gbc = dbSettingsPane.getGBConstraintsCopy();
        gbc.weightx = 0.5;
        gbc.fill = 1;
        dbSettingsPane.add((Component)new JPanel(), gbc);
        this.createTblOnDeployCB = new JCheckBox(CREATE_ON_DEPLOY);
        this.createTblOnDeployCB.setMnemonic('D');
        this.createTblOnDeployCB.setSelected(false);
        this.dbTableBox.addWithGBConstraints(this.createTblOnDeployCB);
        this.deleteTblOnUnDeployCB = new JCheckBox(DELETE_ON_UNDEPLOY);
        this.deleteTblOnUnDeployCB.setMnemonic('U');
        this.deleteTblOnUnDeployCB.setSelected(false);
        this.dbTableBox.addWithGBConstraints(this.deleteTblOnUnDeployCB);
        UITitledBox dbButtonBox = new UITitledBox(null, false);
        gbc = dbSettingsLeft.getGBConstraintsCopy();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 14;
        dbSettingsRight.add((Component)dbButtonBox, gbc);
        this.sqlgenPB = new JButton(GENERATE_SQL);
        this.sqlgenPB.setMnemonic('G');
        this.sqlgenPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                DeploymentSettingsDialog.this.generateSQL();
            }
        });
        dbSettingsRight.addWithGBConstraints(this.sqlgenPB);
        this.databaseSettingsPB = new DeploymentSettingsInspector.DialogDisplayButton(this);
        this.databaseSettingsPB.setText(DB_SETTINGS);
        dbSettingsRight.getGBConstraints().insets.top += 5;
        dbSettingsRight.addWithGBConstraints(this.databaseSettingsPB);
        UIButton okPB = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                DeploymentSettingsDialog.this.okAction();
            }
        });
        upperHalf.addControlButton(okPB);
        this.cancelPB = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                DeploymentSettingsDialog.this.cancelAction();
            }
        });
        upperHalf.addControlButton(this.cancelPB);
        this.helpPB = new UIHelpButton();
        upperHalf.addControlButton(this.helpPB);
        UITitledBox methodBox = new UITitledBox(METH_IMPL_QUERIES, true);
        lowerHalf.addWithGBConstraints(methodBox);
        this.showFinders = new UIRadioButtonBox(SHOW_FINDERS, false);
        this.showFinders.setModel(FINDER_OPTIONS);
        this.showFinders.setClearWhenDisabled(true);
        this.showFinders.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                DeploymentSettingsDialog.this.refreshDialog();
            }
        });
        gbc = methodBox.getGBConstraintsCopy();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        gbc.insets = new Insets(5, 5, 5, 0);
        gbc.fill = 0;
        gbc.anchor = 11;
        methodBox.add((Component)this.showFinders, gbc);
        this.sqlMethodsList = new UITitledTable(null, false);
        this.methodTable = new MethodTable(new MethodTableModel());
        this.methodTable.setSelectionMode(0);
        this.methodTable.getSelectionModel().addListSelectionListener(new SqlMethodsListener());
        this.sqlMethodsList.setTableView(this.methodTable);
        Dimension sqlps = this.sqlMethodsList.getPreferredSize();
        gbc = methodBox.getGBConstraintsCopy();
        gbc.weightx = 0.4;
        gbc.weighty = 0.5;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        gbc.insets = new Insets(5, 0, 5, 0);
        gbc.fill = 1;
        gbc.anchor = 10;
        methodBox.add((Component)this.sqlMethodsList, gbc);
        this.sqlStmtText = new UITitledTextArea(SQL_QUERY, false);
        this.sqlStmtText.setClearWhenDisabled(true);
        this.sqlStmtText.setEnabled(false);
        this.sqlStmtText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                MethodItem ref = (MethodItem)DeploymentSettingsDialog.this.sqlMethodsList.getSelectedRowObject();
                if (ref != null) {
                    ref.setSQL(DeploymentSettingsDialog.this.sqlStmtText.getText());
                }
            }
        });
        gbc = methodBox.getGBConstraintsCopy();
        gbc.weightx = 0.6;
        gbc.weighty = 0.4;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        gbc.fill = 1;
        gbc.anchor = 10;
        methodBox.add((Component)this.sqlStmtText, gbc);
        this.ejbQLBox = new UITitledControlButtonBox(EJB_QL_QUERY, false);
        this.ejbQLBox.setEnabled(false);
        this.ejbQLBox.setControlButtonLocation(101);
        gbc.weightx = 0.6;
        gbc.weighty = 0.6;
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        gbc.fill = 1;
        gbc.anchor = 10;
        methodBox.add((Component)this.ejbQLBox, gbc);
        this.ejbQLText = new UITitledTextArea(null, false);
        this.ejbQLText.setReadOnly(true);
        this.ejbQLText.setClearWhenDisabled(true);
        this.ejbQLBox.setView(this.ejbQLText);
        UIButton editPB = UIButton.createEditButton(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                DeploymentSettingsDialog.this.editAction();
            }
        }, true);
        editPB.setMnemonic('E');
        this.ejbQLBox.addControlButton(editPB);
        ((Component)this).setSize(650, 400);
        this.setLocationRelativeToOwner(20, 20);
    }

    protected void _showDialog() {
        this.cancelPB.setEnabled(true);
        super._showDialog();
    }

    void setDescriptor(Object d10) {
        this.cmp2x = true;
        if (d10 instanceof EjbCMPEntityDescriptor) {
            EjbCMPEntityDescriptor ejbCmp = (EjbCMPEntityDescriptor)d10;
            this.descriptor = ejbCmp;
            this.persDesc = ejbCmp.getPersistenceDescriptor();
            this.ejbBundle = ejbCmp.getEjbBundleDescriptor();
            this.dbTableBox.setVisible(true);
            this.helpPB.setHelpID(helpSetMapID1);
            this.cmp2x = ejbCmp.isEJB20();
            this.showFinders.setVisible(this.cmp2x);
            this.ejbQLText.setVisible(this.cmp2x);
        } else {
            this.descriptor = null;
            this.persDesc = null;
            this.ejbBundle = null;
        }
        if (this.descriptor == null) {
            return;
        }
        if (this.ejbBundle == null) {
            UIUtils.debugPrintln("EJB bundle descriptor is NULL!");
            return;
        }
        ResourceReferenceDescriptor rrd = this.ejbBundle.getCMPResourceReference();
        if (rrd != null) {
            ResourcePrincipal rp = rrd.getResourcePrincipal();
            this.databaseSettingsPB.setDeploymentSettingsInspector(rrd.getJndiName(), rp.getName(), rp.getPassword());
            this.sqlgenPB.setEnabled(true);
        } else {
            this.databaseSettingsPB.setDeploymentSettingsInspector("", "", "");
            this.sqlgenPB.setEnabled(false);
        }
        this.createTblOnDeployCB.setSelected(this.persDesc.getCreateTableOnDeployment());
        this.deleteTblOnUnDeployCB.setSelected(this.persDesc.getDeleteTableOnUndeployment());
        this.updateSqlMethods(true);
        this.refreshDialog();
    }

    private void refreshDialog() {
        this.showFinders.setItemEnabled(SHOW_LOCAL_FINDERS, this.descriptor.getLocalHomeClassName() != null);
        this.showFinders.setItemEnabled(SHOW_REMOTE_FINDERS, this.descriptor.getHomeClassName() != null);
        String showMeth = (String)this.showFinders.getSelectedItem();
        if (showMeth == null) {
            if (this.showFinders.isItemEnabled(SHOW_LOCAL_FINDERS)) {
                this.showFinders.setSelectedItem(SHOW_LOCAL_FINDERS);
            } else if (this.showFinders.isItemEnabled(SHOW_REMOTE_FINDERS)) {
                this.showFinders.setSelectedItem(SHOW_REMOTE_FINDERS);
            } else {
                this.showFinders.setSelectedItem(SHOW_SELECT_METHODS);
            }
            showMeth = (String)this.showFinders.getSelectedItem();
        }
        this.methodTable.setColumnHidden(this.methodTable.getDescriptionColumn(), showMeth.equals(SHOW_CONTAINER_METHODS));
        Vector<MethodItem> queryList = new Vector<MethodItem>();
        Enumeration values = this.tableDataCache.elements();
        while (values.hasMoreElements()) {
            MethodItem mi = (MethodItem)values.nextElement();
            if (!mi.getType().equals(showMeth)) continue;
            queryList.add(mi);
        }
        this.methodTable.clearTableData();
        this.methodTable.updateTableData(queryList);
    }

    private Hashtable updateSqlMethods(boolean clear) {
        boolean updSQL = false;
        if (clear) {
            this.tableDataCache.clear();
            updSQL = true;
        }
        try {
            String className = this.descriptor.getLocalHomeClassName();
            if (className != null) {
                this.addMethods(this.getEjbClass(className).getMethods(), SHOW_LOCAL_FINDERS, METHOD_FIND, this.tableDataCache, updSQL);
            }
            if ((className = this.descriptor.getHomeClassName()) != null) {
                this.addMethods(this.getEjbClass(className).getMethods(), SHOW_REMOTE_FINDERS, METHOD_FIND, this.tableDataCache, updSQL);
            }
            this.addMethods(this.persDesc.getPersistentClass().getMethods(), SHOW_SELECT_METHODS, METHOD_EJB_SELECT, this.tableDataCache, updSQL);
            Set meths = this.persDesc.getAllSqlStatementedMethods();
            Iterator i2 = meths.iterator();
            while (i2.hasNext()) {
                MethodItem mi;
                String n2 = (String)i2.next();
                if (n2.startsWith(METHOD_FindBPK) || (mi = (MethodItem)this.tableDataCache.get(n2)) != null) continue;
                String eql = null;
                String sql = this.persDesc.getSqlStatementFor(n2);
                String desc = "";
                String type = SHOW_CONTAINER_METHODS;
                this.tableDataCache.put(n2, new MethodItem(n2, eql, sql, desc, type));
            }
        }
        catch (Exception ex2) {
            UIOptionPane.showErrorDialog(this, DeploymentSettingsDialog.ERROR_GETTING_QUERY_METHODS(ex2.toString()));
        }
        return this.tableDataCache;
    }

    private void addMethods(Method[] methods, String type, String mKey, Hashtable ht, boolean updSql) {
        int i2 = 0;
        while (i2 < methods.length) {
            String n2;
            Method meth = methods[i2];
            QueryDescriptor qd = this.persDesc.getQueryFor(meth);
            if (qd != null && (n2 = new MethodDescriptor(meth).getFormattedString()).startsWith(mKey) && !n2.startsWith(METHOD_FindBPK)) {
                MethodItem mi = (MethodItem)ht.get(n2);
                if (mi == null) {
                    String eql = qd.getIsEjbQl() ? qd.getQuery() : "";
                    String sql = qd.getSQL();
                    String desc = qd.getDescription();
                    ht.put(n2, new MethodItem(n2, eql, sql, desc, type));
                } else {
                    mi.setEjbQL(qd.getIsEjbQl() ? qd.getQuery() : "");
                    if (updSql) {
                        mi.setSQL(qd.getSQL());
                    }
                }
            }
            ++i2;
        }
    }

    private Class getEjbClass(String className) {
        try {
            EjbBundleArchivist arch = (EjbBundleArchivist)this.persDesc.getEjbBundleDescriptor().getArchivist();
            return arch.getClassLoader().loadClass(className);
        }
        catch (Exception ex2) {
            throw new EJBException(ex2);
        }
    }

    private void applyAction() {
        this.cancelPB.setEnabled(false);
        Iterator i2 = this.persDesc.getAllSqlStatementedMethods().iterator();
        while (i2.hasNext()) {
            MethodItem mi;
            String sql;
            String n2 = (String)i2.next();
            if (n2.startsWith(METHOD_FindBPK) || (sql = (mi = (MethodItem)this.tableDataCache.get(n2)).getSQL()) == null || sql.equals("")) continue;
            this.persDesc.setSqlStatementFor(mi.getName(), sql);
        }
        i2 = this.persDesc.getAllPossibleQueriedMethods().iterator();
        while (i2.hasNext()) {
            MethodItem mi;
            Method method = (Method)i2.next();
            String name = new MethodDescriptor(method).getFormattedString();
            if (name.startsWith(METHOD_FindBPK) || (mi = (MethodItem)this.tableDataCache.get(name)) == null) continue;
            QueryDescriptor qd = this.persDesc.getQueryFor(method);
            if (qd == null) {
                qd = new QueryDescriptor();
                qd.setQueryMethod(method);
                this.persDesc.setQueryFor(method, qd);
            }
            qd.setDescription(mi.getDescription());
            String sql = mi.getSQL();
            if (sql.equals("")) continue;
            if (!this.cmp2x && sql.toLowerCase().indexOf("where") < 0) {
                UIOptionPane.showWarningDialog(this, DeploymentSettingsDialog.ERROR_MISSING_WHERE_CLAUSE(name));
                continue;
            }
            qd.setSQL(sql);
        }
        this.persDesc.setCreateTableOnDeployment(this.createTblOnDeployCB.isSelected());
        this.persDesc.setDeleteTableOnUndeployment(this.deleteTblOnUnDeployCB.isSelected());
    }

    private void okAction() {
        this.applyAction();
        if (!this.persDesc.hasCMPData()) {
            UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploymentsettingsdialog.bean_missing_cmp_sql", "SQL statements must be generated for all methods of this enterprise bean."));
        } else {
            this.hide();
        }
    }

    private void cancelAction() {
        this.hide();
    }

    private void editAction() {
        if (this.finderSelectDialog == null) {
            this.finderSelectDialog = new FinderSelectDialog(this);
        }
        this.finderSelectDialog.setDescriptor(this.descriptor);
        this.finderSelectDialog.show();
        this.updateSqlMethods(false);
        this.refreshDialog();
    }

    public void resourceReferenceUpdated(String dbNameText, String userNameText, String passwdText) {
        ResourceReferenceDescriptor rrd = this.ejbBundle.getCMPResourceReference();
        if (rrd == null) {
            rrd = new ResourceReferenceDescriptor();
        }
        rrd.setJndiName(dbNameText);
        ResourcePrincipal rp = new ResourcePrincipal(userNameText, passwdText);
        rrd.setResourcePrincipal(rp);
        this.ejbBundle.setCMPResourceReference(rrd);
        this.sqlgenPB.setEnabled(true);
    }

    public void generateSQL(String dbNameText, String userNameText, String passwdText, JDialog owner) {
        this.generateSQL();
    }

    private void generateSQL() {
        try {
            ResourceReferenceDescriptor rrd = this.ejbBundle.getCMPResourceReference();
            if (rrd == null) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploymentsettingsdialog.no_db_name_specified", "ERROR: No database name specified"));
                return;
            }
            String currentServer = DT.getServerManager().getCurrentServer();
            if (currentServer == null) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploymentsettingsdialog.please_connect_to_server", "You must connect to the target server to generate the SQL"));
                return;
            }
            this.applyAction();
            DBInfo dBInfo = DT.getServerManager().getDBInfo(currentServer);
            SQLGenerator.generateSQL(this.ejbBundle, rrd, true, dBInfo);
            this.updateSqlMethods(true);
            this.refreshDialog();
            UIOptionPane.showInfoDialog(this, localStrings.getLocalString("ui.deploymentsettingsdialog.sql_complete", "SQL Generation complete"));
        }
        catch (Exception ex2) {
            UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploymentsettingsdialog.error_generating_sql", "ERROR: while generating SQL.\n{0}\nPlease make sure the database name/user/password is valid\nand the J2EE server and database are running.", new Object[]{ex2}));
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class MethodTableModel
    extends InspectorTableModel {
        public MethodTableModel() {
            super(new String[]{METHOD_TABLE_METHOD, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
            this.setDataOrdering(1);
        }

        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        public Object getObjectValue(Object obj, int col) {
            MethodItem ref = (MethodItem)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getName();
                    break;
                }
                case 1: {
                    value = ref.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            MethodItem ref = (MethodItem)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    ref.setDescription(value.toString());
                }
            }
        }
    }

    private class MethodTable
    extends InspectorTable {
        public MethodTable(MethodTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
        }
    }

    private class MethodItem
    extends InspectorTableModel.InspectorDataWrapper {
        public MethodItem(String n2, String e10, String s2, String d10, String t2) {
            super(new Object[]{n2, e10, s2, d10, t2});
            this.setDefaultNullValue("");
        }

        public String getName() {
            return (String)this.getObject(0);
        }

        public String getEjbQL() {
            return (String)this.getObject(1);
        }

        public String getSQL() {
            return (String)this.getObject(2);
        }

        public String getDescription() {
            return (String)this.getObject(3);
        }

        public String getType() {
            return (String)this.getObject(4);
        }

        public void setEjbQL(String v2) {
            this.setObject(1, v2);
        }

        public void setSQL(String v2) {
            this.setObject(2, v2);
        }

        public void setDescription(String v2) {
            this.setObject(3, v2);
        }
    }

    private class SqlMethodsListener
    implements ListSelectionListener {
        private SqlMethodsListener() {
        }

        public void valueChanged(ListSelectionEvent e10) {
            if (e10.getValueIsAdjusting()) {
                return;
            }
            MethodItem mi = (MethodItem)DeploymentSettingsDialog.this.sqlMethodsList.getSelectedRowObject();
            if (mi == null) {
                DeploymentSettingsDialog.this.sqlStmtText.setEnabled(false);
                DeploymentSettingsDialog.this.ejbQLBox.setEnabled(false);
            } else {
                DeploymentSettingsDialog.this.sqlStmtText.setText(mi.getSQL());
                DeploymentSettingsDialog.this.sqlStmtText.setEnabled(true);
                if (!mi.getType().equals(SHOW_CONTAINER_METHODS)) {
                    DeploymentSettingsDialog.this.ejbQLText.setText(mi.getEjbQL());
                    DeploymentSettingsDialog.this.ejbQLBox.setEnabled(true);
                } else {
                    DeploymentSettingsDialog.this.ejbQLBox.setEnabled(false);
                }
            }
        }
    }
}

