/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.main.ServerException;
import com.sun.enterprise.tools.deployment.ui.DeployedAppDescriptor;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class DeployedAppGeneralInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$DeployedAppGeneralInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$DeployedAppGeneralInspector = DeployedAppGeneralInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.DeployedAppGeneralInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$DeployedAppGeneralInspector);
    private static String UNINSTALL_LABEL = localStrings.getLocalString("ui.deployedappgeneralinspector.uninstall", "Undeploy");
    private static String TABNAME = localStrings.getLocalString("ui.deployedappgeneralinspector.tabname", "General");
    private static String wizardHelpID = "General";
    private static String deployHelpID = "General";
    private DeployedAppDescriptor deployedAppDescriptor = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$DeployedAppGeneralInspector;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$DeployedAppDescriptor;

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new DeployedAppGeneralInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$tools$deployment$ui$DeployedAppDescriptor == null ? (class$com$sun$enterprise$tools$deployment$ui$DeployedAppDescriptor = DeployedAppGeneralInspector.class$("com.sun.enterprise.tools.deployment.ui.DeployedAppDescriptor")) : class$com$sun$enterprise$tools$deployment$ui$DeployedAppDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.deployedAppDescriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof DeployedAppDescriptor) {
            this.deployedAppDescriptor = (DeployedAppDescriptor)obj;
            this.invokeRefresh();
        } else {
            this.deployedAppDescriptor = null;
        }
    }

    private DeployedAppGeneralInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeWidgets();
    }

    private void initializeWidgets() {
        GridBagConstraints c10 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        JButton uninstallButton = new JButton(UNINSTALL_LABEL);
        uninstallButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                DeployedAppGeneralInspector.this.uninstallAction();
            }
        });
        uninstallButton.setEnabled(this.isDeploymentMode());
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 0;
        c10.anchor = 10;
    }

    public void uninstallAction() {
        String appName;
        int userChoice;
        String currentServer = InspectorPane.getServerManager().getCurrentServer();
        if (currentServer != null && this.deployedAppDescriptor != null && (userChoice = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("deployedappinspector.chosen_uninstall", "You have chosen to undeploy application\n {0} from {1}", new Object[]{appName = this.deployedAppDescriptor.getName(), currentServer}) + localStrings.getLocalString("deployedappinspector.continue", ". Continue ?"), localStrings.getLocalString("deployedappinspector.confirm", "Confirm Action"), 0, 3)) == 0) {
            try {
                InspectorPane.getServerManager().undeployApplication(appName, currentServer);
            }
            catch (ServerException se) {
                JOptionPane.showMessageDialog(this, localStrings.getLocalString("deployedappinspector.communication_error", "Communication error with server: ") + se.getMessage());
                InspectorPane.getServerManager().removeServer(currentServer);
            }
            catch (Throwable t2) {
                JOptionPane.showMessageDialog(this, t2.getMessage());
            }
        }
    }

    public void refresh() {
        if (this.deployedAppDescriptor == null) {
            return;
        }
        this.invalidate();
        this.validate();
    }

    public String toString() {
        return "Deployed Application General Inspector";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

