/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.repository.ConnectorResource;
import com.sun.enterprise.repository.J2EEResourceCollection;
import com.sun.enterprise.repository.J2EEResourceFactory;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledPasswordField;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.table.TableCellEditor;

public class ConnectionFactoryDialog
extends UIDialog
implements ActionListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$ConnectionFactoryDialog == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$ConnectionFactoryDialog = ConnectionFactoryDialog.class$("com.sun.enterprise.tools.deployment.ui.descriptor.ConnectionFactoryDialog")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$ConnectionFactoryDialog);
    private static final String WINDOW_TITLE_NEW = localStrings.getLocalString("ui.connectionfactorydialog.dialog_title_new", "New Connection Factory");
    private static final String WINDOW_TITLE_EDIT = localStrings.getLocalString("ui.connectionfactorydialog.dialog_title_edit", "Edit Connection Factory");
    private static final String RESOURCE_ADAPTER = localStrings.getLocalString("ui.connectionfactorydialog.resource_adapter", "Resource Adapter");
    private static final String JNDI_NAME = localStrings.getLocalString("ui.connectionfactorydialog.jndi_name", "Connection Factory JNDI Name:");
    private static final String CONFIG_PROPS = localStrings.getLocalString("ui.connectionfactorydialog.config_props", "Configuration Properties");
    private static final String RECOVERY_SETTINGS = localStrings.getLocalString("ui.connectionfactorydialog.recovery_settings", "Recovery Settings");
    private static final String NO_CONNECTORS = localStrings.getLocalString("ui.connectionfactorydialog.no_connectors", "[No Resource-Adapters]");
    private static final String USER_NAME = localStrings.getLocalString("ui.connectionfactorydialog.user_name", "User Name:");
    private static final String USER_PASSWORD = localStrings.getLocalString("ui.connectionfactorydialog.user_password", "Password:");
    private static final String TABLE_PROPERTY = localStrings.getLocalString("ui.connectionfactorydialog.table.property", "Property");
    private static final String TABLE_TYPE = localStrings.getLocalString("ui.connectionfactorydialog.table.type", "Type");
    private static final String TABLE_VALUE = localStrings.getLocalString("ui.connectionfactorydialog.table.value", "Value");
    private static final String TABLE_TOOLTIP = localStrings.getLocalString("ui.connectionfactorydialog.table.tooltip", "Configuration Properties");
    public static final String SEPARATOR = ":";
    private ConnectorResource resource = null;
    private ConnectorDescriptor connector = null;
    private String connectorName = null;
    private String applicationName = null;
    private static final String helpSetMapID = "NewConnFactory";
    private UITitledComboBox cbResAdapt = null;
    private UITitledTextField jndiName = null;
    private UITitledTable cfgPropsTable = null;
    private UITitledTextField userName = null;
    private UITitledPasswordField userPassword = null;
    private boolean isNew = false;
    private boolean isOk = false;
    private Vector connDescList = null;
    private static final String JAVA_LANG = "java.lang.";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$ConnectionFactoryDialog;

    private static String ILLEGAL_VALUE(String v0) {
        return localStrings.getLocalString("ui.connectionfactorydialog.table.illegal_value", "''{0}'' is not a legal value for this entry type", new Object[]{v0});
    }

    private static String SUCCESSFUL(String v0, String v1) {
        return localStrings.getLocalString("ui.connectionfactorydialog.add_was_successful", "''{0}'' was successfully added to ''{1}''", new Object[]{v0, v1});
    }

    private static String ERROR_ADDING(String v0, String v1) {
        return localStrings.getLocalString("ui.connectionfactorydialog.error_while_adding", "An error was encountered while adding ''{0}''\n {1}", new Object[]{v0, v1});
    }

    private static String ERROR_REMOVING(String v0, String v1) {
        return localStrings.getLocalString("ui.connectionfactorydialog.error_while_removing", "An error was encountered while removing ''{0}''\n {1}", new Object[]{v0, v1});
    }

    private static String ERROR_GETTING_COLLECTION(String v0) {
        return localStrings.getLocalString("ui.connectionfactorydialog.error_getting_collection", "Unable to obtain resource collection\n {0}", new Object[]{v0});
    }

    private void setConnectorDescriptor(Object cd2) {
        if (cd2 == null) {
            this.connector = null;
            this.connectorName = null;
            this.applicationName = null;
        } else if (cd2 instanceof ConnectorDescriptorWrapper) {
            ConnectorDescriptorWrapper cdw = (ConnectorDescriptorWrapper)cd2;
            this.connector = null;
            this.connectorName = cdw.getConnectorName();
            this.applicationName = cdw.getApplicationName();
        } else if (cd2 instanceof ConnectorDescriptor) {
            this.connector = (ConnectorDescriptor)cd2;
            this.connectorName = ConnectionFactoryDialog.GetConnectorDeployName(this.connector);
            Application app = this.connector.getApplication();
            this.applicationName = app != null ? app.getName() : null;
        } else if (cd2 instanceof ConnectorResource) {
            this.connector = null;
            ConnectorResource cr2 = (ConnectorResource)cd2;
            this.connectorName = cr2.getConnectorName();
            this.applicationName = cr2.getApplicationName();
        } else if (cd2 instanceof String) {
            this.connector = null;
            int p2 = ((String)cd2).indexOf(SEPARATOR);
            if (p2 >= 0) {
                this.connectorName = p2 + 1 < ((String)cd2).length() ? ((String)cd2).substring(p2 + 1) : null;
                this.applicationName = ((String)cd2).substring(0, p2);
            } else {
                this.connectorName = (String)cd2;
                this.applicationName = null;
            }
        } else {
            UIUtils.printImplementationError("Invalid object type: " + cd2.getClass().getName());
        }
    }

    private String getFullConnectorName() {
        if (this.applicationName != null && !this.applicationName.equals("")) {
            return this.applicationName + SEPARATOR + this.connectorName;
        }
        return this.connectorName;
    }

    public static String GetConnectorDeployName(ConnectorDescriptor cd2) {
        String deployName = null;
        if (UIConfig.getConfigBoolean("ui.deploy.connectors.useDisplayName")) {
            deployName = cd2.getName();
        } else {
            File rarfile = new File(cd2.getArchivist().getArchiveUri());
            deployName = rarfile.getName();
        }
        return deployName;
    }

    public static ConnectionFactoryDialog showNewDialog(Component comp) {
        ConnectionFactoryDialog cfd = ConnectionFactoryDialog.createNewDialog(comp);
        cfd.show();
        return cfd;
    }

    public static ConnectionFactoryDialog createNewDialog(Component comp) {
        return ConnectionFactoryDialog._createDialog(comp, null);
    }

    public static ConnectionFactoryDialog showEditDialog(Component comp, String factoryName) {
        ConnectionFactoryDialog cfd = ConnectionFactoryDialog.createEditDialog(comp, factoryName);
        cfd.show();
        return cfd;
    }

    public static ConnectionFactoryDialog createEditDialog(Component comp, String factoryName) {
        if (factoryName == null || factoryName.equals("")) {
            UIUtils.printImplementationError("'Edit' requires a valid ConnectionFactory name");
            return null;
        }
        return ConnectionFactoryDialog._createDialog(comp, factoryName);
    }

    private static ConnectionFactoryDialog _createDialog(Component comp, String factoryName) {
        ConnectorResource factory = null;
        if (factoryName != null) {
            try {
                factory = ConnectionFactoryDialog.getConnectorResourceByName(factoryName);
            }
            catch (Exception ex2) {
                UIOptionPane.showErrorDialog(comp, ConnectionFactoryDialog.ERROR_GETTING_COLLECTION(ex2.toString()));
            }
        }
        Window owner = UIUtils.getAncestorWindow(comp);
        ConnectionFactoryDialog cfd = null;
        if (owner instanceof Frame) {
            cfd = new ConnectionFactoryDialog((Frame)owner, factory);
        } else if (owner instanceof Dialog) {
            cfd = new ConnectionFactoryDialog((Dialog)owner, factory);
        } else {
            UIUtils.printImplementationError("Component is not in a window");
            return null;
        }
        cfd.setLocationRelativeTo(comp);
        return cfd;
    }

    private ConnectionFactoryDialog(Frame owner, ConnectorResource factory) {
        super(owner, true);
        this._init(factory);
    }

    private ConnectionFactoryDialog(Dialog owner, ConnectorResource factory) {
        super(owner, true);
        this._init(factory);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _init(ConnectorResource factory) {
        GridBagConstraints gbc = null;
        this.isNew = factory == null;
        this.setTitle(this.isNew ? WINDOW_TITLE_NEW : WINDOW_TITLE_EDIT);
        this.doNothingOnClose();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                ConnectionFactoryDialog.this.isOk = false;
                ConnectionFactoryDialog.this.setVisible(false);
            }
        });
        ((Component)this).setSize(new Dimension(500, 400));
        UITitledBox contentPane = new UITitledBox(null, false);
        this.setContentPane(contentPane);
        UITitledBox panel = new UITitledBox(null, false);
        gbc = panel.getGBConstraintsCopy();
        gbc.insets = new Insets(5, 5, 5, 5);
        contentPane.add((Component)panel, gbc);
        this.cbResAdapt = new UITitledComboBox(RESOURCE_ADAPTER, false);
        gbc = panel.getGBConstraintsCopy();
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        panel.add((Component)this.cbResAdapt, gbc);
        if (this.isNew) {
            this.cbResAdapt.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae2) {
                    Object cdw = ConnectionFactoryDialog.this.cbResAdapt.getSelectedItem();
                    ConnectionFactoryDialog.this.setConnectorDescriptor(((ConnectorDescriptorWrapper)cdw).getConnector());
                    ConnectionFactoryDialog.this.cfgPropsTable.updateTableData(ConnectionFactoryDialog.this.getConfigProperties());
                }
            });
        }
        this.jndiName = new UITitledTextField(JNDI_NAME, false);
        this.jndiName.setText("");
        this.jndiName.addValidator(this.jndiName.getNonBlankEntryValidator());
        gbc = panel.getGBConstraintsCopy();
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        panel.add((Component)this.jndiName, gbc);
        this.cfgPropsTable = new UITitledTable(CONFIG_PROPS, true);
        this.cfgPropsTable.setTableView(new ConfigPropsTable(new ConfigPropsTableModel()));
        gbc = panel.getGBConstraintsCopy();
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.fill = 1;
        panel.add((Component)this.cfgPropsTable, gbc);
        UITitledBox recoveryBox = new UITitledBox(RECOVERY_SETTINGS, true);
        gbc = this.cfgPropsTable.getGBConstraintsCopy();
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.cfgPropsTable.add((Component)recoveryBox, gbc);
        this.userName = new UITitledTextField(USER_NAME, false);
        this.userName.setText("");
        recoveryBox.addWithGBConstraints(this.userName);
        this.userPassword = new UITitledPasswordField(USER_PASSWORD, false);
        this.userPassword.setText("");
        recoveryBox.addWithGBConstraints(this.userPassword);
        UITitledControlButtonBox buttonPane = new UITitledControlButtonBox();
        buttonPane.setControlButtonLocation(101);
        gbc = contentPane.getGBConstraintsCopy();
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        contentPane.add((Component)buttonPane, gbc);
        UIButton okBtn = UIButton.createOkButton(this);
        buttonPane.addControlButton(okBtn);
        UIButton cancelBtn = UIButton.createCancelButton(this);
        buttonPane.addControlButton(cancelBtn);
        buttonPane.addControlButton(new UIHelpButton(helpSetMapID));
        if (this.isNew) {
            this.resource = null;
            Vector cdv = this.getDeployedConnectorDescriptors();
            if (cdv.size() <= 0) {
                this.setConnectorDescriptor(null);
                this.cbResAdapt.setModel(new Object[]{new ConnectorDescriptorWrapper()});
                this.cbResAdapt.setReadOnly(true);
                this.jndiName.setEnabled(false);
                this.cfgPropsTable.setEnabled(false);
                okBtn.setEnabled(false);
                return;
            }
            this.cbResAdapt.setModel(cdv);
            this.cbResAdapt.setReadOnly(false);
            this.setConnectorDescriptor(cdv.elementAt(0));
            this.cbResAdapt.setSelectedItem(this.getFullConnectorName());
        } else {
            this.resource = factory;
            this.jndiName.setText(this.resource.getName());
            this.userName.setText(this.resource.getDbuser());
            this.userPassword.setText(this.resource.getDbpassword());
            this.setConnectorDescriptor(this.resource);
            this.cbResAdapt.setModel(new Object[]{new ConnectorDescriptorWrapper(this.getFullConnectorName())});
            this.cbResAdapt.setReadOnly(true);
        }
        this.cfgPropsTable.updateTableData(this.getConfigProperties());
    }

    private Vector getConfigProperties() {
        Vector<EnvironmentProperty> cfg = new Vector<EnvironmentProperty>();
        try {
            Set s2 = DT.getServerManager().getConnectionFactoryPropertyTemplate(this.applicationName, this.connectorName);
            Iterator i2 = s2.iterator();
            while (i2.hasNext()) {
                EnvironmentProperty ep2 = (EnvironmentProperty)i2.next();
                cfg.add(new EnvironmentProperty(ep2.getName(), ep2.getValue(), "", ep2.getType()));
            }
        }
        catch (Exception ex2) {
            UIUtils.debugPrintln("ERROR: " + ex2.toString());
        }
        return cfg;
    }

    public void actionPerformed(ActionEvent ae2) {
        String cmd = ae2.getActionCommand();
        if (cmd.equals("ok")) {
            if (this.jndiName.performValidation()) {
                this.isOk = true;
                this.updateConnectorResource();
                this.setVisible(false);
            }
        } else if (cmd.equals("cancel")) {
            this.isOk = false;
            this.setVisible(false);
        }
    }

    public boolean isOk() {
        return this.isOk;
    }

    private Vector getDeployedConnectorDescriptors() {
        Vector<ConnectorDescriptorWrapper> depList = new Vector<ConnectorDescriptorWrapper>();
        if (DT.getServerManager() == null) {
            return depList;
        }
        try {
            Vector cn2 = DT.getServerManager().getConnectorNames();
            Iterator i2 = ((AbstractList)cn2).iterator();
            while (i2.hasNext()) {
                String cr2 = (String)i2.next();
                ConnectorDescriptorWrapper cdr = new ConnectorDescriptorWrapper(cr2);
                if (depList.contains(cdr)) continue;
                depList.add(cdr);
            }
        }
        catch (Exception ex2) {
            UIUtils.debugPrintln("Exception while obtaining deployed Connectors: " + ex2.toString());
        }
        return depList;
    }

    public static ConnectorResource getConnectorResourceByName(String name) throws Exception {
        if (name != null && !name.equals("")) {
            J2EEResourceCollection resources = ConnectionFactoryDialog.getResourceCollection();
            return (ConnectorResource)resources.getResourceByName(6, name);
        }
        return null;
    }

    private static J2EEResourceCollection getResourceCollection() throws Exception {
        J2EEResourceFactory resourceFactory = ServerConfiguration.getJ2EEResourceFactory();
        return resourceFactory.loadDefaultResourceCollection();
    }

    public static Vector listConnectionFactories() throws Exception {
        Vector<ConnectorResource> cfs = new Vector<ConnectorResource>();
        try {
            Set r2 = DT.getServerManager().listConnectorResources();
            Iterator i2 = r2.iterator();
            while (i2.hasNext()) {
                ConnectorResource cr2 = (ConnectorResource)i2.next();
                cfs.add(cr2);
            }
        }
        catch (Exception ex2) {
            UIUtils.debugPrintln("Unable to obtain list of Connection Factories: " + ex2.toString());
            throw ex2;
        }
        return cfs;
    }

    private void updateConnectorResource() {
        if (this.connectorName == null) {
            UIUtils.printImplementationError("Cannot update without a Connector name");
            return;
        }
        String appName = this.applicationName;
        String jndiName = this.jndiName.getText();
        String userName = this.userName.getText();
        String userPass = this.userPassword.getText();
        Properties props = new Properties();
        Iterator i2 = this.cfgPropsTable.getTableData().iterator();
        while (i2.hasNext()) {
            EnvironmentProperty ep2 = (EnvironmentProperty)i2.next();
            ((Hashtable)props).put(ep2.getName(), ep2.getValue());
        }
        if (this.resource != null) {
            try {
                ConnectionFactoryDialog.removeConnectorResource(this.resource.getName());
                this.resource = null;
            }
            catch (Exception ex2) {
                UIOptionPane.showErrorDialog(this, ConnectionFactoryDialog.ERROR_REMOVING(this.resource.getName(), ex2.toString()));
                return;
            }
        }
        try {
            DT.getServerManager().addConnectionFactory(appName, this.connectorName, jndiName, userName, userPass, props);
            UIOptionPane.showInfoDialog(this, ConnectionFactoryDialog.SUCCESSFUL(jndiName, this.connectorName));
        }
        catch (Exception ex3) {
            UIOptionPane.showErrorDialog(this, ConnectionFactoryDialog.ERROR_ADDING(jndiName, ex3.toString()));
        }
    }

    public static void removeConnectorResource(String name) throws Exception {
        DT.getServerManager().removeConnectionFactory(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ConfigPropsTableModel
    extends InspectorTableModel {
        public ConfigPropsTableModel() {
            super(new String[]{TABLE_PROPERTY, TABLE_TYPE, TABLE_VALUE});
        }

        public EnvironmentProperty getRow(int index) {
            return (EnvironmentProperty)this.getRowObject(index);
        }

        public boolean isCellEditable(int row, int col) {
            return col == 2;
        }

        public Object getObjectValue(Object obj, int col) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getName();
                    break;
                }
                case 1: {
                    value = ref.getType().startsWith(ConnectionFactoryDialog.JAVA_LANG) ? ref.getType().substring(ConnectionFactoryDialog.JAVA_LANG.length()) : ref.getType();
                    break;
                }
                case 2: {
                    value = ref.getValue();
                    break;
                }
                case 3: {
                    value = ref.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            if (ref == null) {
                return;
            }
            String valStr = value.toString();
            switch (col) {
                case 0: {
                    ref.setName(value.toString());
                    break;
                }
                case 1: {
                    if (!valStr.startsWith(ConnectionFactoryDialog.JAVA_LANG)) {
                        valStr = ConnectionFactoryDialog.JAVA_LANG + valStr;
                    }
                    if (valStr.equals(ref.getType())) break;
                    ref.setType(valStr);
                    this.setObjectValue(obj, 2, "");
                    break;
                }
                case 2: {
                    try {
                        ref.setValue(super.validatePrimitiveValue(ref.getType(), valStr));
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        UIOptionPane.showErrorDialog(null, ConnectionFactoryDialog.ILLEGAL_VALUE(valStr));
                    }
                }
            }
        }
    }

    private class ConfigPropsTable
    extends InspectorTable {
        public ConfigPropsTable(ConfigPropsTableModel model) {
            super(model);
            this.setToolTipText(TABLE_TOOLTIP);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 1: {
                    rtn = super.getPrimitiveTypesEditor();
                    break;
                }
                case 2: {
                    EnvironmentProperty ref = (EnvironmentProperty)this.getRowObject(row);
                    rtn = super.getPrimitiveValueEditor(ref.getType());
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }

    private class ConnectorDescriptorWrapper {
        private String appName = null;
        private String conName = null;
        private String fullName = null;
        private Object connector = null;

        public ConnectorDescriptorWrapper() {
            this.connector = NO_CONNECTORS;
        }

        public ConnectorDescriptorWrapper(Object c10) {
            this.connector = c10;
        }

        public Object getConnector() {
            return this.connector;
        }

        public String getApplicationName() {
            if (this.appName == null) {
                String n2 = this.toString();
                int p2 = n2.indexOf(ConnectionFactoryDialog.SEPARATOR);
                this.appName = p2 >= 0 ? n2.substring(0, p2) : "";
            }
            return this.appName;
        }

        public String getConnectorName() {
            if (this.conName == null) {
                String n2 = this.toString();
                int p2 = n2.indexOf(ConnectionFactoryDialog.SEPARATOR);
                this.conName = p2 >= 0 ? n2.substring(p2 + 1) : n2;
            }
            return this.conName;
        }

        public boolean equals(Object obj) {
            String myName = this.toString();
            return this.toString().equals(this.fullConnectorName(obj));
        }

        public String toString() {
            if (this.fullName == null) {
                this.fullName = this.fullConnectorName(this.connector);
            }
            return this.fullName;
        }

        private String fullConnectorName(Object c10) {
            if (c10 == null) {
                return "";
            }
            if (c10 instanceof ConnectorDescriptorWrapper) {
                return c10.toString();
            }
            if (c10 instanceof ConnectorDescriptor) {
                ConnectorDescriptor cd2 = (ConnectorDescriptor)c10;
                String name = ConnectionFactoryDialog.GetConnectorDeployName(cd2);
                Application app = cd2.getApplication();
                return app != null ? app.getName() + ConnectionFactoryDialog.SEPARATOR + name : name;
            }
            if (c10 instanceof ConnectorResource) {
                ConnectorResource cr2 = (ConnectorResource)c10;
                String name = cr2.getConnectorName();
                String appName = cr2.getApplicationName();
                return appName != null && !appName.equals("") ? appName + ConnectionFactoryDialog.SEPARATOR + name : name;
            }
            return c10.toString();
        }
    }
}

