/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.DeployToolWindow;
import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public abstract class Wizard
extends UIDialog
implements DescriptionInspector.DescriptionInspectorManager,
InspectorPane.InspectorPaneOwner {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$Wizard == null ? (class$com$sun$enterprise$tools$deployment$ui$Wizard = Wizard.class$("com.sun.enterprise.tools.deployment.ui.Wizard")) : class$com$sun$enterprise$tools$deployment$ui$Wizard);
    private static String HELP = localStrings.getLocalString("ui.wizard.help", "Help");
    private static String CANCEL = localStrings.getLocalString("ui.wizard.cancel", "Cancel");
    private static String BACK = localStrings.getLocalString("ui.wizard.back", "< Back");
    private static String NEXT = localStrings.getLocalString("ui.wizard.next", "Next >");
    private static String FINISH = localStrings.getLocalString("ui.wizard.finish", "Finish");
    private static String INTRODUCTION = localStrings.getLocalString("ui.wizard.introduction", "Introduction");
    private static String SKIP_THIS = localStrings.getLocalString("ui.wizard.skip_this_screen", "Skip this Screen in the Future");
    private static String SLIM_WIZARD_IMAGE = "wizard_generic_sliver.gif";
    private Vector components = new Vector();
    private Hashtable descriptions = new Hashtable();
    private Hashtable subTitles = new Hashtable();
    private int currentState = 0;
    private boolean gotToEnd = false;
    private String frameTitle;
    private UIDialog dialog = null;
    private IntroPanel introPanel = null;
    private JPanel buttonsPanel;
    private JButton backButton;
    private JButton nextButton;
    private JButton finishButton;
    private String doneLabelString = FINISH;
    protected UIHelpButton helpButton = null;
    private int okToFinishIndex = -1;
    private DescriptionInspector descriptionInspector = null;
    private Vector notificationListenerList = new Vector();
    private int refreshCount = 0;
    private Runnable deferredRefresh = null;
    private static String HELP_IMAGE = "wizard_generic_full.gif";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$Wizard;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Descriptor;

    protected Wizard(Frame owner) {
        super(owner, true);
        if (owner instanceof DeployToolWindow) {
            this.addWindowListener((DeployToolWindow)owner);
        }
        this.descriptionInspector = new DescriptionInspector(this);
        super.dialogInit();
        this.dialog = this;
        this.setupLayout();
        if (owner != null) {
            int x2 = owner.getBounds().x + this.getBounds().width / 4;
            int y2 = owner.getBounds().y + this.getBounds().height / 4;
            int width = owner.getBounds().width / 2;
            int height = owner.getBounds().height / 2;
            ((Component)this).setBounds(x2, y2, width, height);
        }
    }

    private void setupLayout() {
        this.getContentPane().setLayout(new BorderLayout());
        this.helpButton = new UIHelpButton();
        ActionListener buttonListener = new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                String cmd = ae2.getActionCommand();
                if (cmd.equals("cancel")) {
                    Wizard.this.currentState = 0;
                    Wizard.this.removeDescriptorListeners();
                    Wizard.this.dialog.dispose();
                } else if (cmd.equals("back")) {
                    Wizard.this._goBackward();
                } else if (cmd.equals("next")) {
                    Wizard.this._goForward();
                } else if (cmd.equals("finish")) {
                    Wizard.this._finishAction();
                }
            }
        };
        JButton cancelButton = new JButton(CANCEL);
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(buttonListener);
        this.backButton = new JButton(BACK);
        this.backButton.setActionCommand("back");
        this.backButton.addActionListener(buttonListener);
        this.nextButton = new JButton(NEXT);
        this.nextButton.setActionCommand("next");
        this.nextButton.addActionListener(buttonListener);
        this.finishButton = new JButton(this.doneLabelString);
        this.finishButton.setActionCommand("finish");
        this.finishButton.addActionListener(buttonListener);
        this.finishButton.setEnabled(false);
        this.buttonsPanel = new JPanel(new BorderLayout());
        this.buttonsPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        Box helpBox = Box.createHorizontalBox();
        Box navBox = Box.createHorizontalBox();
        helpBox.add(Box.createHorizontalStrut(25));
        helpBox.add(this.helpButton);
        helpBox.add(Box.createHorizontalStrut(15));
        navBox.add(Box.createHorizontalStrut(15));
        navBox.add(cancelButton);
        navBox.add(Box.createHorizontalStrut(7));
        navBox.add(this.backButton);
        navBox.add(this.nextButton);
        navBox.add(Box.createHorizontalStrut(20));
        navBox.add(this.finishButton);
        navBox.add(Box.createHorizontalStrut(20));
        this.buttonsPanel.add((Component)helpBox, "West");
        this.buttonsPanel.add((Component)navBox, "East");
        this.buttonsPanel.add((Component)new ButtonLine(), "North");
    }

    public Class getDescriptorClass() {
        UIUtils.printImplementationError("Wizard.getDescriptorClass", "This method should never be called");
        return class$com$sun$enterprise$deployment$Descriptor == null ? (class$com$sun$enterprise$deployment$Descriptor = Wizard.class$("com.sun.enterprise.deployment.Descriptor")) : class$com$sun$enterprise$deployment$Descriptor;
    }

    public void setDescriptor(Descriptor d10) {
        UIUtils.printImplementationError("Wizard.setDescriptor", "This method should never be called");
    }

    public Descriptor getDescriptor() {
        UIUtils.printImplementationError("Wizard.setDescriptor", "This method should be overridden by the 'Wizard' subclass");
        return null;
    }

    protected void addIntroPanel(String helpText) {
        if (this.components.size() == 0) {
            this.introPanel = new IntroPanel(helpText);
            this.addComponent(this.introPanel, INTRODUCTION, "");
            this.currentState = 0;
        } else {
            UIUtils.printImplementationError("Wizard.addIntroPanel", "Intro panel is not the first panel added to this wizard");
        }
    }

    protected void addDescriptorListener(Descriptor desc, NotificationListener listener) {
        Vector vector = this.notificationListenerList;
        synchronized (vector) {
            desc.addNotificationListener(listener);
            this.notificationListenerList.add(new Object[]{desc, listener});
        }
    }

    public void removeDescriptorListeners() {
        Vector vector = this.notificationListenerList;
        synchronized (vector) {
            Enumeration enumeration = this.notificationListenerList.elements();
            while (enumeration.hasMoreElements()) {
                Object[] obj = (Object[])enumeration.nextElement();
                Descriptor desc = (Descriptor)obj[0];
                NotificationListener listener = (NotificationListener)obj[1];
                desc.removeNotificationListener(listener);
            }
            this.notificationListenerList.removeAllElements();
        }
    }

    protected void descriptorChanged() {
        JComponent comp = this.getCurrentComponent();
        if (comp instanceof InspectorPane) {
            InspectorPane insp = (InspectorPane)comp;
            Descriptor desc = this.getDescriptor();
            if (desc != insp.getDescriptor()) {
                insp.setDescriptor(desc);
            }
            ((InspectorPane)comp).invokeRefresh();
        }
    }

    public DescriptionInspector getDescriptionInspector() {
        return this.descriptionInspector;
    }

    public abstract String getHelpGroup();

    public void addInspectorPane(InspectorPane inspPane, String subTitle, String description) {
        inspPane.setOwner(this);
        this.components.addElement(inspPane);
        this.subTitles.put(inspPane, subTitle);
        this.descriptions.put(inspPane, description);
        String helpId = inspPane.getHelpID();
        if (helpId != null && helpId.length() > 0) {
            CSH.setHelpIDString((Component)inspPane, (String)(this.getHelpGroup() + helpId));
        }
    }

    public void addInspectorPane(InspectorPane inspPane) {
        String[] wizHelp = inspPane.getWizardDescription();
        String subTitle = wizHelp == null || wizHelp.length < 1 ? "" : wizHelp[0];
        String description = wizHelp == null || wizHelp.length < 2 ? "" : wizHelp[1];
        this.addInspectorPane(inspPane, subTitle, description);
    }

    public void addComponent(JComponent component, String subTitle, String description) {
        if (component instanceof InspectorPane) {
            UIUtils.printImplementationError("Wizard.addComponent", "'addInspectorPane()' should be used for 'InspectorPane's");
            this.addInspectorPane((InspectorPane)component, subTitle, description);
            return;
        }
        this.components.addElement(component);
        this.subTitles.put(component, subTitle);
        this.descriptions.put(component, description);
    }

    protected void okToEnableFinish(JComponent resetComponent) {
        this.okToEnableFinish(resetComponent, false);
    }

    protected void okToEnableFinish(JComponent resetComponent, boolean nextNdx) {
        if (resetComponent == null) {
            this.clearOkToEnableFinish();
            return;
        }
        int ndx = this.getIndexOf(resetComponent);
        if (ndx < 0) {
            UIUtils.printImplementationError("Wizard.okToEnableFinish", "Unrecognized specified component");
            return;
        }
        if (this.okToFinishIndex >= 0 && this.okToFinishIndex != ndx) {
            UIUtils.debugPrintln("Warning: 'okToFinishIndex' already specified");
        }
        this.okToFinishIndex = ndx + (nextNdx ? 1 : 0);
    }

    protected void clearOkToEnableFinish() {
        this.okToFinishIndex = -1;
    }

    protected boolean isOkToFinish() {
        return this.okToFinishIndex >= 0 && this.currentState >= this.okToFinishIndex;
    }

    protected int getIndexOf(JComponent component) {
        return this.components.indexOf(component);
    }

    protected void setDoneLabelString(String doneLabelString) {
        this.doneLabelString = doneLabelString;
    }

    String getCurrentDescription() {
        Object description = this.descriptions.get(this.getCurrentComponent());
        return description != null ? (String)description : "";
    }

    public void show() {
        if (this.helpButton != null) {
            this.helpButton.setHelpID(this.getCurrentComponent());
        }
        this.currentState = 0;
        if (this.introPanel != null && this.introPanel.skipIntroScreen()) {
            this.goForward();
        }
        this.invokeRefresh();
        super.show();
    }

    public boolean didComplete() {
        return this.gotToEnd;
    }

    protected boolean isInspectorAcceptable(int compIndex) {
        return true;
    }

    public boolean validateComponent(Component c10) {
        return true;
    }

    private boolean _performValidation() {
        JComponent c10 = this.getCurrentComponent();
        if (c10 instanceof InspectorPane && !((InspectorPane)c10).validateEntries()) {
            return false;
        }
        return this.validateComponent(c10);
    }

    protected void _goForward() {
        if (this._performValidation()) {
            this.goForward();
        }
    }

    public void goForward() {
        int newState = this.currentState;
        while (newState < this.components.size()) {
            if (this.isInspectorAcceptable(++newState)) break;
        }
        if (newState < this.components.size()) {
            this.currentState = newState;
        } else {
            UIUtils.printImplementationError("No acceptable inspectors found");
        }
        if (UIUtils.debugMode()) {
            String cn2 = UIUtils.debugClassName(this.getCurrentComponent().getClass());
            UIUtils.debugPrintln(cn2);
        }
        this.invokeRefresh();
    }

    public void _goBackward() {
        this.goBackward();
    }

    public void goBackward() {
        int newState = this.currentState;
        while (newState >= 0) {
            if (this.isInspectorAcceptable(--newState)) break;
        }
        if (newState >= 0) {
            this.currentState = newState;
        } else {
            UIUtils.printImplementationError("No acceptable inspectors found");
        }
        if (UIUtils.debugMode()) {
            String cn2 = UIUtils.debugClassName(this.getCurrentComponent().getClass());
            UIUtils.debugPrintln(cn2);
        }
        this.invokeRefresh();
    }

    protected void _finishAction() {
        if (this._performValidation()) {
            this.finishAction();
        }
    }

    public void finishAction() {
        this.gotToEnd = true;
        this.currentState = 0;
        this.removeDescriptorListeners();
        this.setVisible(false);
        this.finishButton.setEnabled(false);
    }

    public void setTitle(String s2) {
        this.frameTitle = s2;
        super.setTitle(s2);
    }

    protected int getCurrentComponentIndex() {
        return this.currentState;
    }

    protected JComponent getCurrentComponent() {
        return this.getComponentAt(this.currentState);
    }

    protected JComponent getComponentAt(int index) {
        return (JComponent)this.components.elementAt(index);
    }

    protected void invokeRefresh() {
        if (this.refreshCount == 0) {
            if (this.deferredRefresh == null) {
                this.deferredRefresh = new Runnable(){

                    public void run() {
                        Wizard.this._refresh();
                    }
                };
            }
            ++this.refreshCount;
            EventQueue.invokeLater(this.deferredRefresh);
        } else {
            ++this.refreshCount;
        }
    }

    private void _refresh() {
        this.refreshCount = 0;
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        String subttl = (String)this.subTitles.get(this.getCurrentComponent());
        super.setTitle(this.frameTitle + " - " + (subttl != null ? subttl : ""));
        this.backButton.setEnabled(this.currentState > 0);
        this.nextButton.setEnabled(this.currentState < this.components.size() - 1);
        boolean finishState = false;
        if (this.currentState == this.components.size() - 1) {
            finishState = true;
        } else if (this.okToFinishIndex >= 0) {
            if (this.currentState >= this.okToFinishIndex) {
                finishState = true;
            } else {
                this.clearOkToEnableFinish();
            }
        }
        this.finishButton.setEnabled(finishState);
        this.getContentPane().removeAll();
        JPanel wrapperPanel = new JPanel(new BorderLayout());
        wrapperPanel.add((Component)mainPanel, "Center");
        wrapperPanel.add((Component)this.buttonsPanel, "South");
        JComponent comp = this.getCurrentComponent();
        if (comp != this.introPanel) {
            JTextArea wandTitle = new JTextArea(this.getCurrentDescription());
            if (wandTitle != null && !wandTitle.equals("")) {
                wandTitle.setEditable(false);
                wandTitle.setLineWrap(true);
                wandTitle.setWrapStyleWord(true);
                wandTitle.setBackground(UIManager.getColor("Panel.background"));
                UIUtils.makeFontPlain(wandTitle);
                wandTitle.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
                mainPanel.add("North", wandTitle);
            }
            JPanel panel = new JPanel(new BorderLayout());
            panel.add(Box.createRigidArea(new Dimension(5, 5)), "East");
            panel.add((Component)new UIUtils.ImagePanel(UIIcons.getImageIconFor(SLIM_WIZARD_IMAGE).getImage()), "Center");
            wrapperPanel.add((Component)panel, "West");
            if (comp instanceof InspectorPane) {
                ((InspectorPane)comp).refresh();
            }
        }
        mainPanel.add("Center", this.getCurrentComponent());
        this.getContentPane().add("Center", wrapperPanel);
        this.getContentPane().validate();
    }

    public boolean isCurrentInspectorPane(InspectorPane pane) {
        return this.getCurrentComponent() == pane;
    }

    public Vector getArchiveContents() {
        return null;
    }

    public Vector getArchiveClasses() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class IntroPanel
    extends JPanel {
        private String helpIdKey = null;
        private JCheckBox skipThisScreen = null;

        public IntroPanel(String helpText) {
            GridBagLayout gridbag = new GridBagLayout();
            this.setLayout(gridbag);
            GridBagConstraints c10 = new GridBagConstraints();
            String helpGroup = Wizard.this.getHelpGroup();
            if (helpGroup != null) {
                this.helpIdKey = "ui.wizard.skipIntro_" + helpGroup;
                CSH.setHelpIDString((Component)this, (String)(helpGroup + "Intro"));
            } else {
                this.helpIdKey = null;
            }
            UIUtils.ImagePanel imagePanel = new UIUtils.ImagePanel(UIIcons.getImageIconFor(HELP_IMAGE).getImage());
            c10.weightx = 0.0;
            c10.weighty = 0.5;
            c10.gridx = 0;
            c10.gridy = 0;
            c10.gridwidth = 1;
            c10.gridheight = 2;
            c10.insets = new Insets(0, 0, 0, 0);
            c10.fill = 3;
            c10.anchor = 10;
            this.add((Component)imagePanel, c10);
            JEditorPane helpTextArea = new JEditorPane("text/html", helpText);
            helpTextArea.setBackground(UIManager.getColor("Panel.background"));
            helpTextArea.setEditable(false);
            JScrollPane scrollArea = new JScrollPane(helpTextArea);
            scrollArea.setBorder(null);
            c10.weightx = 0.5;
            c10.weighty = 0.5;
            c10.gridx = 1;
            c10.gridy = 0;
            c10.gridwidth = 1;
            c10.gridheight = 1;
            c10.insets = new Insets(0, 5, 0, 0);
            c10.fill = 1;
            c10.anchor = 10;
            this.add((Component)scrollArea, c10);
            if (this.helpIdKey != null) {
                this.skipThisScreen = new JCheckBox(SKIP_THIS);
                this.skipThisScreen.setSelected(UIConfig.getConfigBoolean(this.helpIdKey));
                this.skipThisScreen.addActionListener(new ActionListener(this){
                    private final /* synthetic */ IntroPanel this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent ae2) {
                        IntroPanel.access$500(this.this$1);
                    }
                });
                c10.weightx = 0.5;
                c10.weighty = 0.0;
                c10.gridx = 1;
                c10.gridy = 1;
                c10.gridwidth = 1;
                c10.gridheight = 1;
                c10.insets = new Insets(0, 5, 0, 0);
                c10.fill = 2;
                c10.anchor = 10;
                this.add((Component)this.skipThisScreen, c10);
            }
        }

        public boolean skipIntroScreen() {
            return this.skipThisScreen != null ? this.skipThisScreen.isSelected() : false;
        }

        private void updateScreenSkip() {
            if (this.helpIdKey != null) {
                UIConfig.setConfigBoolean(this.helpIdKey, this.skipThisScreen.isSelected());
                UIConfig.saveConfig();
            }
        }

        static /* synthetic */ void access$500(IntroPanel x0) {
            x0.updateScreenSkip();
        }
    }

    private static class ButtonLine
    extends JPanel {
        public ButtonLine() {
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, 5));
        }

        public void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            g2.setColor(Color.black);
            g2.drawLine(0, 0, this.getWidth() - 1, 0);
        }
    }
}

