/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.tools.deployment.ui.DescriptorTreeView;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import java.awt.Color;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class TreeCombo
extends UITitledComboBox {
    static final int OFFSET = 16;
    static Border emptyBorder = new EmptyBorder(0, 0, 0, 0);

    public TreeCombo() {
    }

    public TreeCombo(String title, boolean showBorder) {
        super(title, showBorder);
    }

    public TreeCombo(TreeModel aTreeModel) {
        this();
        this.setModel(aTreeModel);
    }

    public void setModel(TreeModel aTreeModel) {
        super.setModel((ComboBoxModel)new TreeToListModel(aTreeModel));
        this.getComboBox().setRenderer(new ListEntryRenderer());
    }

    public Object getSelectedDescriptor() {
        Object obj = this.getSelectedItem();
        ListEntry le = obj instanceof ListEntry ? (ListEntry)obj : null;
        return le == null ? null : ((DefaultMutableTreeNode)le.object()).getUserObject();
    }

    public void setSelectedDescriptor(Object obj) {
        if (obj == null) {
            this.setSelectedItem(null);
            return;
        }
        Enumeration e10 = ((TreeToListModel)this.getModel()).cache.elements();
        while (e10.hasMoreElements()) {
            ListEntry le = (ListEntry)e10.nextElement();
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)le.object();
            if (dmtn.getUserObject() != obj) continue;
            this.setSelectedItem(le);
            return;
        }
        this.setSelectedItem(null);
    }

    public static void main(String[] args) {
        JFrame f2 = new JFrame();
        ((Component)f2).setBounds(5, 5, 300, 300);
        f2.show();
        DefaultTreeModel dtm = new DefaultTreeModel(new DefaultMutableTreeNode("Danny"));
        TreeCombo tc = new TreeCombo(dtm);
        f2.getContentPane().add(tc);
    }

    class ListEntryRenderer
    extends JLabel
    implements ListCellRenderer {
        Color selBackColor = UIManager.getColor("ComboBox.selectionBackground");
        Color selForeColor = UIManager.getColor("ComboBox.selectionForeground");
        Color backColor = UIManager.getColor("ComboBox.background");
        Color foreColor = UIManager.getColor("ComboBox.foreground");

        public ListEntryRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList listbox, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                ListEntry listEntry = (ListEntry)value;
                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)listEntry.object();
                this.setText(dmtn.toString());
                this.setIcon(DescriptorTreeView.getIconForDescriptor(dmtn.getUserObject()));
                if (UIManager.getLookAndFeel().getName().equals("CDE/Motif")) {
                    this.setOpaque(index != -1);
                } else {
                    this.setOpaque(true);
                }
                this.setBorder(index == -1 ? emptyBorder : new EmptyBorder(0, 16 * listEntry.level(), 0, 0));
                this.setBackground(isSelected ? this.selBackColor : this.backColor);
                this.setForeground(isSelected ? this.selForeColor : this.foreColor);
            } else {
                this.setText("");
            }
            return this;
        }
    }

    class ListEntry {
        private Object object;
        private int level;
        private boolean isNode;

        public ListEntry(Object anObject, int aLevel, boolean isNode) {
            this.object = anObject;
            this.level = aLevel;
            this.isNode = isNode;
        }

        public Object object() {
            return this.object;
        }

        public int level() {
            return this.level;
        }

        public boolean isNode() {
            return this.isNode;
        }

        public String toString() {
            return this.object.toString();
        }
    }

    class TreeToListModel
    extends DefaultComboBoxModel
    implements TreeModelListener {
        TreeModel source;
        boolean invalid = true;
        Object currentValue;
        Vector cache = new Vector();

        public TreeToListModel(TreeModel aTreeModel) {
            this.source = aTreeModel;
            aTreeModel.addTreeModelListener(this);
            TreeCombo.this.getComboBox().setRenderer(new ListEntryRenderer());
        }

        public void setSelectedItem(Object obj) {
            this.currentValue = obj instanceof ListEntry ? obj : null;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.currentValue;
        }

        public int getSize() {
            this.validate();
            return this.cache.size();
        }

        public Object getElementAt(int index) {
            return this.cache.elementAt(index);
        }

        public int getIndexOf(Object obj) {
            if (!(obj instanceof String)) {
                return super.getIndexOf(obj);
            }
            int i2 = 0;
            int len = this.getSize();
            while (i2 < len) {
                Object item = this.getElementAt(i2);
                if (obj.equals(item.toString())) {
                    return i2;
                }
                ++i2;
            }
            return -1;
        }

        public void treeNodesChanged(TreeModelEvent e10) {
            this.invalid = true;
        }

        public void treeNodesInserted(TreeModelEvent e10) {
            this.invalid = true;
        }

        public void treeNodesRemoved(TreeModelEvent e10) {
            this.invalid = true;
        }

        public void treeStructureChanged(TreeModelEvent e10) {
            this.invalid = true;
        }

        void validate() {
            if (this.invalid) {
                this.cache = new Vector();
                this.cacheTree(this.source.getRoot(), 0);
                if (this.cache.size() > 0) {
                    this.currentValue = this.cache.elementAt(0);
                }
                this.invalid = false;
                this.fireContentsChanged(this, 0, 0);
            }
        }

        void cacheTree(Object anObject, int level) {
            if (anObject != this.source.getRoot() && this.source.isLeaf(anObject)) {
                this.addListEntry(anObject, level, false);
            } else {
                int c10 = this.source.getChildCount(anObject);
                if (level > 0) {
                    this.addListEntry(anObject, level, true);
                }
                ++level;
                int i2 = 0;
                while (i2 < c10) {
                    Object child = this.source.getChild(anObject, i2);
                    this.cacheTree(child, level);
                    ++i2;
                }
                --level;
            }
        }

        void addListEntry(Object anObject, int level, boolean isNode) {
            this.cache.addElement(new ListEntry(anObject, level, isNode));
        }
    }
}

